/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opensearchserverless.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.opensearchserverless.model.SecurityConfigSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListSecurityConfigsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<SecurityConfigSummary> securityConfigSummaries;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListSecurityConfigsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<SecurityConfigSummary> getSecurityConfigSummaries() {
        return this.securityConfigSummaries;
    }

    public void setSecurityConfigSummaries(Collection<SecurityConfigSummary> securityConfigSummaries) {
        if (securityConfigSummaries == null) {
            this.securityConfigSummaries = null;
            return;
        }
        this.securityConfigSummaries = new ArrayList<SecurityConfigSummary>(securityConfigSummaries);
    }

    public ListSecurityConfigsResult withSecurityConfigSummaries(SecurityConfigSummary ... securityConfigSummaries) {
        if (this.securityConfigSummaries == null) {
            this.setSecurityConfigSummaries(new ArrayList<SecurityConfigSummary>(securityConfigSummaries.length));
        }
        for (SecurityConfigSummary ele : securityConfigSummaries) {
            this.securityConfigSummaries.add(ele);
        }
        return this;
    }

    public ListSecurityConfigsResult withSecurityConfigSummaries(Collection<SecurityConfigSummary> securityConfigSummaries) {
        this.setSecurityConfigSummaries(securityConfigSummaries);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getSecurityConfigSummaries() != null) {
            sb.append("SecurityConfigSummaries: ").append(this.getSecurityConfigSummaries());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSecurityConfigsResult)) {
            return false;
        }
        ListSecurityConfigsResult other = (ListSecurityConfigsResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getSecurityConfigSummaries() == null ^ this.getSecurityConfigSummaries() == null) {
            return false;
        }
        return other.getSecurityConfigSummaries() == null || other.getSecurityConfigSummaries().equals(this.getSecurityConfigSummaries());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityConfigSummaries() == null ? 0 : this.getSecurityConfigSummaries().hashCode());
        return hashCode;
    }

    public ListSecurityConfigsResult clone() {
        try {
            return (ListSecurityConfigsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

