/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.nimblestudio.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.nimblestudio.model.LaunchProfileState;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListLaunchProfilesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private Integer maxResults;
    private String nextToken;
    private String principalId;
    private List<String> states;
    private String studioId;

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public ListLaunchProfilesRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListLaunchProfilesRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setPrincipalId(String principalId) {
        this.principalId = principalId;
    }

    public String getPrincipalId() {
        return this.principalId;
    }

    public ListLaunchProfilesRequest withPrincipalId(String principalId) {
        this.setPrincipalId(principalId);
        return this;
    }

    public List<String> getStates() {
        return this.states;
    }

    public void setStates(Collection<String> states) {
        if (states == null) {
            this.states = null;
            return;
        }
        this.states = new ArrayList<String>(states);
    }

    public ListLaunchProfilesRequest withStates(String ... states) {
        if (this.states == null) {
            this.setStates(new ArrayList<String>(states.length));
        }
        for (String ele : states) {
            this.states.add(ele);
        }
        return this;
    }

    public ListLaunchProfilesRequest withStates(Collection<String> states) {
        this.setStates(states);
        return this;
    }

    public ListLaunchProfilesRequest withStates(LaunchProfileState ... states) {
        ArrayList<String> statesCopy = new ArrayList<String>(states.length);
        for (LaunchProfileState value : states) {
            statesCopy.add(value.toString());
        }
        if (this.getStates() == null) {
            this.setStates(statesCopy);
        } else {
            this.getStates().addAll(statesCopy);
        }
        return this;
    }

    public void setStudioId(String studioId) {
        this.studioId = studioId;
    }

    public String getStudioId() {
        return this.studioId;
    }

    public ListLaunchProfilesRequest withStudioId(String studioId) {
        this.setStudioId(studioId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getPrincipalId() != null) {
            sb.append("PrincipalId: ").append(this.getPrincipalId()).append(",");
        }
        if (this.getStates() != null) {
            sb.append("States: ").append(this.getStates()).append(",");
        }
        if (this.getStudioId() != null) {
            sb.append("StudioId: ").append(this.getStudioId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLaunchProfilesRequest)) {
            return false;
        }
        ListLaunchProfilesRequest other = (ListLaunchProfilesRequest)obj;
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getPrincipalId() == null ^ this.getPrincipalId() == null) {
            return false;
        }
        if (other.getPrincipalId() != null && !other.getPrincipalId().equals(this.getPrincipalId())) {
            return false;
        }
        if (other.getStates() == null ^ this.getStates() == null) {
            return false;
        }
        if (other.getStates() != null && !other.getStates().equals(this.getStates())) {
            return false;
        }
        if (other.getStudioId() == null ^ this.getStudioId() == null) {
            return false;
        }
        return other.getStudioId() == null || other.getStudioId().equals(this.getStudioId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getPrincipalId() == null ? 0 : this.getPrincipalId().hashCode());
        hashCode = 31 * hashCode + (this.getStates() == null ? 0 : this.getStates().hashCode());
        hashCode = 31 * hashCode + (this.getStudioId() == null ? 0 : this.getStudioId().hashCode());
        return hashCode;
    }

    public ListLaunchProfilesRequest clone() {
        return (ListLaunchProfilesRequest)super.clone();
    }
}

