/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.neptunedata.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.neptunedata.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * CustomModelTrainingParametersMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class CustomModelTrainingParametersMarshaller {

    private static final MarshallingInfo<String> SOURCES3DIRECTORYPATH_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sourceS3DirectoryPath").build();
    private static final MarshallingInfo<String> TRAININGENTRYPOINTSCRIPT_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("trainingEntryPointScript").build();
    private static final MarshallingInfo<String> TRANSFORMENTRYPOINTSCRIPT_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("transformEntryPointScript").build();

    private static final CustomModelTrainingParametersMarshaller instance = new CustomModelTrainingParametersMarshaller();

    public static CustomModelTrainingParametersMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(CustomModelTrainingParameters customModelTrainingParameters, ProtocolMarshaller protocolMarshaller) {

        if (customModelTrainingParameters == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(customModelTrainingParameters.getSourceS3DirectoryPath(), SOURCES3DIRECTORYPATH_BINDING);
            protocolMarshaller.marshall(customModelTrainingParameters.getTrainingEntryPointScript(), TRAININGENTRYPOINTSCRIPT_BINDING);
            protocolMarshaller.marshall(customModelTrainingParameters.getTransformEntryPointScript(), TRANSFORMENTRYPOINTSCRIPT_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
