/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.licensemanagerlinuxsubscriptions.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a
 *      href="http://docs.aws.amazon.com/goto/WebAPI/license-manager-linux-subscriptions-2018-05-10/GetRegisteredSubscriptionProvider"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GetRegisteredSubscriptionProviderRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the BYOL registration resource to get details for.
     * </p>
     */
    private String subscriptionProviderArn;

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the BYOL registration resource to get details for.
     * </p>
     * 
     * @param subscriptionProviderArn
     *        The Amazon Resource Name (ARN) of the BYOL registration resource to get details for.
     */

    public void setSubscriptionProviderArn(String subscriptionProviderArn) {
        this.subscriptionProviderArn = subscriptionProviderArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the BYOL registration resource to get details for.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the BYOL registration resource to get details for.
     */

    public String getSubscriptionProviderArn() {
        return this.subscriptionProviderArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the BYOL registration resource to get details for.
     * </p>
     * 
     * @param subscriptionProviderArn
     *        The Amazon Resource Name (ARN) of the BYOL registration resource to get details for.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetRegisteredSubscriptionProviderRequest withSubscriptionProviderArn(String subscriptionProviderArn) {
        setSubscriptionProviderArn(subscriptionProviderArn);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getSubscriptionProviderArn() != null)
            sb.append("SubscriptionProviderArn: ").append(getSubscriptionProviderArn());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof GetRegisteredSubscriptionProviderRequest == false)
            return false;
        GetRegisteredSubscriptionProviderRequest other = (GetRegisteredSubscriptionProviderRequest) obj;
        if (other.getSubscriptionProviderArn() == null ^ this.getSubscriptionProviderArn() == null)
            return false;
        if (other.getSubscriptionProviderArn() != null && other.getSubscriptionProviderArn().equals(this.getSubscriptionProviderArn()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getSubscriptionProviderArn() == null) ? 0 : getSubscriptionProviderArn().hashCode());
        return hashCode;
    }

    @Override
    public GetRegisteredSubscriptionProviderRequest clone() {
        return (GetRegisteredSubscriptionProviderRequest) super.clone();
    }

}
