/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticache.model.IncreaseNodeGroupsInGlobalReplicationGroupRequest;
import com.amazonaws.services.elasticache.model.RegionalConfiguration;
import com.amazonaws.services.elasticache.model.ReshardingConfiguration;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class IncreaseNodeGroupsInGlobalReplicationGroupRequestMarshaller
implements Marshaller<Request<IncreaseNodeGroupsInGlobalReplicationGroupRequest>, IncreaseNodeGroupsInGlobalReplicationGroupRequest> {
    public Request<IncreaseNodeGroupsInGlobalReplicationGroupRequest> marshall(IncreaseNodeGroupsInGlobalReplicationGroupRequest increaseNodeGroupsInGlobalReplicationGroupRequest) {
        if (increaseNodeGroupsInGlobalReplicationGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)increaseNodeGroupsInGlobalReplicationGroupRequest, "AmazonElastiCache");
        request.addParameter("Action", "IncreaseNodeGroupsInGlobalReplicationGroup");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (increaseNodeGroupsInGlobalReplicationGroupRequest.getGlobalReplicationGroupId() != null) {
            request.addParameter("GlobalReplicationGroupId", StringUtils.fromString((String)increaseNodeGroupsInGlobalReplicationGroupRequest.getGlobalReplicationGroupId()));
        }
        if (increaseNodeGroupsInGlobalReplicationGroupRequest.getNodeGroupCount() != null) {
            request.addParameter("NodeGroupCount", StringUtils.fromInteger((Integer)increaseNodeGroupsInGlobalReplicationGroupRequest.getNodeGroupCount()));
        }
        if (!increaseNodeGroupsInGlobalReplicationGroupRequest.getRegionalConfigurations().isEmpty() || !((SdkInternalList)increaseNodeGroupsInGlobalReplicationGroupRequest.getRegionalConfigurations()).isAutoConstruct()) {
            SdkInternalList regionalConfigurationsList = (SdkInternalList)increaseNodeGroupsInGlobalReplicationGroupRequest.getRegionalConfigurations();
            int regionalConfigurationsListIndex = 1;
            for (RegionalConfiguration regionalConfigurationsListValue : regionalConfigurationsList) {
                if (regionalConfigurationsListValue != null) {
                    if (regionalConfigurationsListValue.getReplicationGroupId() != null) {
                        request.addParameter("RegionalConfigurations.RegionalConfiguration." + regionalConfigurationsListIndex + ".ReplicationGroupId", StringUtils.fromString((String)regionalConfigurationsListValue.getReplicationGroupId()));
                    }
                    if (regionalConfigurationsListValue.getReplicationGroupRegion() != null) {
                        request.addParameter("RegionalConfigurations.RegionalConfiguration." + regionalConfigurationsListIndex + ".ReplicationGroupRegion", StringUtils.fromString((String)regionalConfigurationsListValue.getReplicationGroupRegion()));
                    }
                    if (!regionalConfigurationsListValue.getReshardingConfiguration().isEmpty() || !((SdkInternalList)regionalConfigurationsListValue.getReshardingConfiguration()).isAutoConstruct()) {
                        SdkInternalList reshardingConfigurationList = (SdkInternalList)regionalConfigurationsListValue.getReshardingConfiguration();
                        int reshardingConfigurationListIndex = 1;
                        for (ReshardingConfiguration reshardingConfigurationListValue : reshardingConfigurationList) {
                            if (reshardingConfigurationListValue != null) {
                                if (reshardingConfigurationListValue.getNodeGroupId() != null) {
                                    request.addParameter("RegionalConfigurations.RegionalConfiguration." + regionalConfigurationsListIndex + ".ReshardingConfiguration.ReshardingConfiguration." + reshardingConfigurationListIndex + ".NodeGroupId", StringUtils.fromString((String)reshardingConfigurationListValue.getNodeGroupId()));
                                }
                                if (!reshardingConfigurationListValue.getPreferredAvailabilityZones().isEmpty() || !((SdkInternalList)reshardingConfigurationListValue.getPreferredAvailabilityZones()).isAutoConstruct()) {
                                    SdkInternalList preferredAvailabilityZonesList = (SdkInternalList)reshardingConfigurationListValue.getPreferredAvailabilityZones();
                                    int preferredAvailabilityZonesListIndex = 1;
                                    for (String preferredAvailabilityZonesListValue : preferredAvailabilityZonesList) {
                                        if (preferredAvailabilityZonesListValue != null) {
                                            request.addParameter("RegionalConfigurations.RegionalConfiguration." + regionalConfigurationsListIndex + ".ReshardingConfiguration.ReshardingConfiguration." + reshardingConfigurationListIndex + ".PreferredAvailabilityZones.AvailabilityZone." + preferredAvailabilityZonesListIndex, StringUtils.fromString((String)preferredAvailabilityZonesListValue));
                                        }
                                        ++preferredAvailabilityZonesListIndex;
                                    }
                                }
                            }
                            ++reshardingConfigurationListIndex;
                        }
                    }
                }
                ++regionalConfigurationsListIndex;
            }
        }
        if (increaseNodeGroupsInGlobalReplicationGroupRequest.getApplyImmediately() != null) {
            request.addParameter("ApplyImmediately", StringUtils.fromBoolean((Boolean)increaseNodeGroupsInGlobalReplicationGroupRequest.getApplyImmediately()));
        }
        return request;
    }
}

