/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtraildata;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.cloudtraildata.AWSCloudTrailDataAsync;
import com.amazonaws.services.cloudtraildata.AWSCloudTrailDataAsyncClientBuilder;
import com.amazonaws.services.cloudtraildata.AWSCloudTrailDataClient;
import com.amazonaws.services.cloudtraildata.model.PutAuditEventsRequest;
import com.amazonaws.services.cloudtraildata.model.PutAuditEventsResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSCloudTrailDataAsyncClient
extends AWSCloudTrailDataClient
implements AWSCloudTrailDataAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSCloudTrailDataAsyncClientBuilder asyncBuilder() {
        return AWSCloudTrailDataAsyncClientBuilder.standard();
    }

    AWSCloudTrailDataAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSCloudTrailDataAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<PutAuditEventsResult> putAuditEventsAsync(PutAuditEventsRequest request) {
        return this.putAuditEventsAsync(request, null);
    }

    @Override
    public Future<PutAuditEventsResult> putAuditEventsAsync(PutAuditEventsRequest request, final AsyncHandler<PutAuditEventsRequest, PutAuditEventsResult> asyncHandler) {
        final PutAuditEventsRequest finalRequest = (PutAuditEventsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutAuditEventsResult>(){

            @Override
            public PutAuditEventsResult call() throws Exception {
                PutAuditEventsResult result = null;
                try {
                    result = AWSCloudTrailDataAsyncClient.this.executePutAuditEvents(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

