/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.backupgateway.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.backupgateway.model.VirtualMachine;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListVirtualMachinesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<VirtualMachine> virtualMachines;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListVirtualMachinesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<VirtualMachine> getVirtualMachines() {
        return this.virtualMachines;
    }

    public void setVirtualMachines(Collection<VirtualMachine> virtualMachines) {
        if (virtualMachines == null) {
            this.virtualMachines = null;
            return;
        }
        this.virtualMachines = new ArrayList<VirtualMachine>(virtualMachines);
    }

    public ListVirtualMachinesResult withVirtualMachines(VirtualMachine ... virtualMachines) {
        if (this.virtualMachines == null) {
            this.setVirtualMachines(new ArrayList<VirtualMachine>(virtualMachines.length));
        }
        for (VirtualMachine ele : virtualMachines) {
            this.virtualMachines.add(ele);
        }
        return this;
    }

    public ListVirtualMachinesResult withVirtualMachines(Collection<VirtualMachine> virtualMachines) {
        this.setVirtualMachines(virtualMachines);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getVirtualMachines() != null) {
            sb.append("VirtualMachines: ").append(this.getVirtualMachines());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVirtualMachinesResult)) {
            return false;
        }
        ListVirtualMachinesResult other = (ListVirtualMachinesResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getVirtualMachines() == null ^ this.getVirtualMachines() == null) {
            return false;
        }
        return other.getVirtualMachines() == null || other.getVirtualMachines().equals(this.getVirtualMachines());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getVirtualMachines() == null ? 0 : this.getVirtualMachines().hashCode());
        return hashCode;
    }

    public ListVirtualMachinesResult clone() {
        try {
            return (ListVirtualMachinesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

