/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.timerManagement;

import com.amazon.ask.model.services.timerManagement.Status;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class TimerResponse {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="status")
    private String status = null;
    @JsonProperty(value="duration")
    private String duration = null;
    @JsonProperty(value="triggerTime")
    private OffsetDateTime triggerTime = null;
    @JsonProperty(value="timerLabel")
    private String timerLabel = null;
    @JsonProperty(value="createdTime")
    private OffsetDateTime createdTime = null;
    @JsonProperty(value="updatedTime")
    private OffsetDateTime updatedTime = null;
    @JsonProperty(value="remainingTimeWhenPaused")
    private String remainingTimeWhenPaused = null;

    private TimerResponse() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private TimerResponse(Builder builder) {
        if (builder.id != null) {
            this.id = builder.id;
        }
        if (builder.status != null) {
            this.status = builder.status;
        }
        if (builder.duration != null) {
            this.duration = builder.duration;
        }
        if (builder.triggerTime != null) {
            this.triggerTime = builder.triggerTime;
        }
        if (builder.timerLabel != null) {
            this.timerLabel = builder.timerLabel;
        }
        if (builder.createdTime != null) {
            this.createdTime = builder.createdTime;
        }
        if (builder.updatedTime != null) {
            this.updatedTime = builder.updatedTime;
        }
        if (builder.remainingTimeWhenPaused != null) {
            this.remainingTimeWhenPaused = builder.remainingTimeWhenPaused;
        }
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public Status getStatus() {
        return Status.fromValue(this.status);
    }

    @JsonProperty(value="status")
    public String getStatusAsString() {
        return this.status;
    }

    @JsonProperty(value="duration")
    public String getDuration() {
        return this.duration;
    }

    @JsonProperty(value="triggerTime")
    public OffsetDateTime getTriggerTime() {
        return this.triggerTime;
    }

    @JsonProperty(value="timerLabel")
    public String getTimerLabel() {
        return this.timerLabel;
    }

    @JsonProperty(value="createdTime")
    public OffsetDateTime getCreatedTime() {
        return this.createdTime;
    }

    @JsonProperty(value="updatedTime")
    public OffsetDateTime getUpdatedTime() {
        return this.updatedTime;
    }

    @JsonProperty(value="remainingTimeWhenPaused")
    public String getRemainingTimeWhenPaused() {
        return this.remainingTimeWhenPaused;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimerResponse servicesTimerManagementTimerResponse = (TimerResponse)o;
        return Objects.equals(this.id, servicesTimerManagementTimerResponse.id) && Objects.equals(this.status, servicesTimerManagementTimerResponse.status) && Objects.equals(this.duration, servicesTimerManagementTimerResponse.duration) && Objects.equals(this.triggerTime, servicesTimerManagementTimerResponse.triggerTime) && Objects.equals(this.timerLabel, servicesTimerManagementTimerResponse.timerLabel) && Objects.equals(this.createdTime, servicesTimerManagementTimerResponse.createdTime) && Objects.equals(this.updatedTime, servicesTimerManagementTimerResponse.updatedTime) && Objects.equals(this.remainingTimeWhenPaused, servicesTimerManagementTimerResponse.remainingTimeWhenPaused);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.status, this.duration, this.triggerTime, this.timerLabel, this.createdTime, this.updatedTime, this.remainingTimeWhenPaused);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TimerResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    triggerTime: ").append(this.toIndentedString(this.triggerTime)).append("\n");
        sb.append("    timerLabel: ").append(this.toIndentedString(this.timerLabel)).append("\n");
        sb.append("    createdTime: ").append(this.toIndentedString(this.createdTime)).append("\n");
        sb.append("    updatedTime: ").append(this.toIndentedString(this.updatedTime)).append("\n");
        sb.append("    remainingTimeWhenPaused: ").append(this.toIndentedString(this.remainingTimeWhenPaused)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String id;
        private String status;
        private String duration;
        private OffsetDateTime triggerTime;
        private String timerLabel;
        private OffsetDateTime createdTime;
        private OffsetDateTime updatedTime;
        private String remainingTimeWhenPaused;

        private Builder() {
        }

        @JsonProperty(value="id")
        public Builder withId(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="status")
        public Builder withStatus(String status) {
            this.status = status;
            return this;
        }

        public Builder withStatus(Status status) {
            this.status = status != null ? status.toString() : null;
            return this;
        }

        @JsonProperty(value="duration")
        public Builder withDuration(String duration) {
            this.duration = duration;
            return this;
        }

        @JsonProperty(value="triggerTime")
        public Builder withTriggerTime(OffsetDateTime triggerTime) {
            this.triggerTime = triggerTime;
            return this;
        }

        @JsonProperty(value="timerLabel")
        public Builder withTimerLabel(String timerLabel) {
            this.timerLabel = timerLabel;
            return this;
        }

        @JsonProperty(value="createdTime")
        public Builder withCreatedTime(OffsetDateTime createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        @JsonProperty(value="updatedTime")
        public Builder withUpdatedTime(OffsetDateTime updatedTime) {
            this.updatedTime = updatedTime;
            return this;
        }

        @JsonProperty(value="remainingTimeWhenPaused")
        public Builder withRemainingTimeWhenPaused(String remainingTimeWhenPaused) {
            this.remainingTimeWhenPaused = remainingTimeWhenPaused;
            return this;
        }

        public TimerResponse build() {
            return new TimerResponse(this);
        }
    }
}

