/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.gameEngine;

import com.amazon.ask.model.services.gameEngine.InputEventActionType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class Pattern {
    @JsonProperty(value="gadgetIds")
    private List<String> gadgetIds = new ArrayList<String>();
    @JsonProperty(value="colors")
    private List<String> colors = new ArrayList<String>();
    @JsonProperty(value="action")
    private String action = null;
    @JsonProperty(value="repeat")
    private Integer repeat = null;

    private Pattern() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private Pattern(Builder builder) {
        if (builder.gadgetIds != null) {
            this.gadgetIds = builder.gadgetIds;
        }
        if (builder.colors != null) {
            this.colors = builder.colors;
        }
        if (builder.action != null) {
            this.action = builder.action;
        }
        if (builder.repeat != null) {
            this.repeat = builder.repeat;
        }
    }

    @JsonProperty(value="gadgetIds")
    public List<String> getGadgetIds() {
        return this.gadgetIds;
    }

    @JsonProperty(value="colors")
    public List<String> getColors() {
        return this.colors;
    }

    public InputEventActionType getAction() {
        return InputEventActionType.fromValue(this.action);
    }

    @JsonProperty(value="action")
    public String getActionAsString() {
        return this.action;
    }

    @JsonProperty(value="repeat")
    public Integer getRepeat() {
        return this.repeat;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pattern servicesGameEnginePattern = (Pattern)o;
        return Objects.equals(this.gadgetIds, servicesGameEnginePattern.gadgetIds) && Objects.equals(this.colors, servicesGameEnginePattern.colors) && Objects.equals(this.action, servicesGameEnginePattern.action) && Objects.equals(this.repeat, servicesGameEnginePattern.repeat);
    }

    public int hashCode() {
        return Objects.hash(this.gadgetIds, this.colors, this.action, this.repeat);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Pattern {\n");
        sb.append("    gadgetIds: ").append(this.toIndentedString(this.gadgetIds)).append("\n");
        sb.append("    colors: ").append(this.toIndentedString(this.colors)).append("\n");
        sb.append("    action: ").append(this.toIndentedString(this.action)).append("\n");
        sb.append("    repeat: ").append(this.toIndentedString(this.repeat)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private List<String> gadgetIds;
        private List<String> colors;
        private String action;
        private Integer repeat;

        private Builder() {
        }

        @JsonProperty(value="gadgetIds")
        public Builder withGadgetIds(List<String> gadgetIds) {
            this.gadgetIds = gadgetIds;
            return this;
        }

        public Builder addGadgetIdsItem(String gadgetIdsItem) {
            if (this.gadgetIds == null) {
                this.gadgetIds = new ArrayList<String>();
            }
            this.gadgetIds.add(gadgetIdsItem);
            return this;
        }

        @JsonProperty(value="colors")
        public Builder withColors(List<String> colors) {
            this.colors = colors;
            return this;
        }

        public Builder addColorsItem(String colorsItem) {
            if (this.colors == null) {
                this.colors = new ArrayList<String>();
            }
            this.colors.add(colorsItem);
            return this;
        }

        @JsonProperty(value="action")
        public Builder withAction(String action) {
            this.action = action;
            return this;
        }

        public Builder withAction(InputEventActionType action) {
            this.action = action != null ? action.toString() : null;
            return this;
        }

        @JsonProperty(value="repeat")
        public Builder withRepeat(Integer repeat) {
            this.repeat = repeat;
            return this;
        }

        public Pattern build() {
            return new Pattern(this);
        }
    }
}

