/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.endpointEnumeration;

import com.amazon.ask.model.services.ApiConfiguration;
import com.amazon.ask.model.services.ApiResponse;
import com.amazon.ask.model.services.BaseServiceClient;
import com.amazon.ask.model.services.Pair;
import com.amazon.ask.model.services.ServiceClientResponse;
import com.amazon.ask.model.services.ServiceException;
import com.amazon.ask.model.services.endpointEnumeration.EndpointEnumerationResponse;
import com.amazon.ask.model.services.endpointEnumeration.EndpointEnumerationService;
import com.amazon.ask.model.services.endpointEnumeration.Error;
import com.amazon.ask.model.services.util.UserAgentHelper;
import java.util.ArrayList;
import java.util.HashMap;

public class EndpointEnumerationServiceClient
extends BaseServiceClient
implements EndpointEnumerationService {
    private final UserAgentHelper userAgentHelper = UserAgentHelper.builder().withSdkVersion("1.79.0").build();

    public EndpointEnumerationServiceClient(ApiConfiguration apiConfiguration) {
        super(apiConfiguration);
    }

    @Override
    public ApiResponse<EndpointEnumerationResponse> callGetEndpoints() throws ServiceException {
        ArrayList queryParams = new ArrayList();
        HashMap pathParams = new HashMap();
        ArrayList<Pair> headerParams = new ArrayList<Pair>();
        headerParams.add(new Pair((Object)"Content-type", (Object)"application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair((Object)"Authorization", (Object)apiAuthorizationValue));
        String resourcePath = "/v1/endpoints";
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(EndpointEnumerationResponse.class, 200, "Successfully retrieved the list of connected endpoints."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 400, "Bad request. Returned when a required parameter is not present or badly formatted."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 401, "Unauthenticated. Returned when the request is not authenticated."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 403, "Forbidden. Returned when the request is authenticated but does not have sufficient permission."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 500, "Server Error. Returned when the server encountered an error processing the request."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 503, "Service Unavailable. Returned when the server is not ready to handle the request."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 0, "Unexpected error"));
        headerParams.add(new Pair((Object)"User-Agent", (Object)this.userAgentHelper.getUserAgent()));
        return this.executeRequest("GET", this.apiEndpoint, resourcePath, queryParams, headerParams, pathParams, serviceResponseDefinitions, null, EndpointEnumerationResponse.class, false);
    }

    @Override
    public EndpointEnumerationResponse getEndpoints() throws ServiceException {
        return (EndpointEnumerationResponse)this.callGetEndpoints().getResponse();
    }
}

