/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.lwa;

import com.amazon.ask.model.services.ApiConfiguration;
import com.amazon.ask.model.services.AuthenticationConfiguration;
import com.amazon.ask.model.services.BaseServiceClient;
import com.amazon.ask.model.services.Pair;
import com.amazon.ask.model.services.ServiceClientResponse;
import com.amazon.ask.model.services.lwa.model.AccessToken;
import com.amazon.ask.model.services.lwa.model.AccessTokenRequest;
import com.amazon.ask.model.services.lwa.model.AccessTokenResponse;
import com.amazon.ask.model.services.lwa.model.Error;
import com.amazon.ask.model.services.lwa.model.GrantType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class LwaClient
extends BaseServiceClient {
    private final AuthenticationConfiguration authenticationConfiguration;
    private final Map<String, AccessToken> scopeTokenStore;
    private final String endpoint;
    private final GrantType grantType;
    private static final long EXPIRY_OFFSET_MILLIS = 60000L;
    private static final String DEFAULT_LWA_ENDPOINT = "https://api.amazon.com";
    private static final String DEFAULT_API_ENDPOINT = "https://api.amazonalexa.com";

    private LwaClient(Builder builder) {
        super(builder.apiConfiguration);
        if (builder.authenticationConfiguration == null) {
            throw new IllegalArgumentException("AuthenticationConfiguration must be provided");
        }
        this.authenticationConfiguration = builder.authenticationConfiguration;
        this.scopeTokenStore = new ConcurrentHashMap<String, AccessToken>();
        String lwaEndpoint = builder.apiConfiguration.getApiEndpoint();
        this.endpoint = lwaEndpoint != null && !lwaEndpoint.equals(DEFAULT_API_ENDPOINT) ? lwaEndpoint : DEFAULT_LWA_ENDPOINT;
        this.grantType = builder.grantType != null ? builder.grantType : GrantType.CLIENT_CREDENTIALS;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getAccessTokenForRefreshToken() {
        return this.getAccessTokenForScope(GrantType.REFRESH_TOKEN.toString());
    }

    public String getAccessTokenForScope(String scope) {
        if (scope == null || scope.isEmpty()) {
            throw new IllegalArgumentException("Scope must be provided");
        }
        AccessToken token = this.scopeTokenStore.get(scope);
        if (token != null && token.getExpiry() > System.currentTimeMillis() + 60000L) {
            return token.getToken();
        }
        long currentEpochMillis = System.currentTimeMillis();
        AccessTokenResponse lwaResponse = this.generateAccessToken(AccessTokenRequest.builder().withScope(scope).withClientId(this.authenticationConfiguration.getClientId()).withClientSecret(this.authenticationConfiguration.getClientSecret()).withRefreshToken(this.authenticationConfiguration.getRefreshToken()).build());
        this.scopeTokenStore.put(scope, new AccessToken(lwaResponse.getAccessToken(), currentEpochMillis + TimeUnit.SECONDS.toMillis(lwaResponse.getExpiresIn())));
        return lwaResponse.getAccessToken();
    }

    private AccessTokenResponse generateAccessToken(AccessTokenRequest request) {
        ArrayList<Pair<String, String>> queryParams = new ArrayList<Pair<String, String>>();
        HashMap<String, String> pathParams = new HashMap<String, String>();
        ArrayList<Pair<String, String>> headerParams = new ArrayList<Pair<String, String>>();
        headerParams.add(new Pair<String, String>("Content-Type", "application/x-www-form-urlencoded"));
        String payload = "grant_type=" + this.grantType.getValue() + "&client_id=" + request.getClientId() + "&client_secret=" + request.getClientSecret();
        payload = request.getScope().equals(GrantType.REFRESH_TOKEN.name()) ? payload + "&refresh_token=" + request.getRefreshToken() : payload + "&scope=" + request.getScope();
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(AccessTokenResponse.class, 200, "Token request sent."));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 400, "Bad Request"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 401, "Authentication Failed"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 500, "Internal Server Error"));
        String lwaEndpoint = this.endpoint != null ? this.endpoint : DEFAULT_LWA_ENDPOINT;
        return (AccessTokenResponse)this.invoke("POST", lwaEndpoint, "/auth/O2/token", queryParams, headerParams, pathParams, serviceResponseDefinitions, payload, AccessTokenResponse.class, true);
    }

    public static final class Builder {
        private AuthenticationConfiguration authenticationConfiguration;
        private ApiConfiguration apiConfiguration;
        private GrantType grantType;

        public Builder withAuthenticationConfiguration(AuthenticationConfiguration authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration;
            return this;
        }

        public Builder withApiConfiguration(ApiConfiguration apiConfiguration) {
            this.apiConfiguration = apiConfiguration;
            return this;
        }

        public Builder withGrantType(GrantType grantType) {
            this.grantType = grantType;
            return this;
        }

        public LwaClient build() {
            return new LwaClient(this);
        }
    }
}

