/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services;

import com.amazon.ask.model.services.ApiClient;
import com.amazon.ask.model.services.ApiClientRequest;
import com.amazon.ask.model.services.ApiClientResponse;
import com.amazon.ask.model.services.ApiConfiguration;
import com.amazon.ask.model.services.ApiResponse;
import com.amazon.ask.model.services.Pair;
import com.amazon.ask.model.services.Serializer;
import com.amazon.ask.model.services.ServiceClientResponse;
import com.amazon.ask.model.services.ServiceException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;

public abstract class BaseServiceClient {
    protected ApiClient apiClient;
    protected Serializer serializer;
    protected String authorizationValue;
    protected String apiEndpoint;

    protected BaseServiceClient(ApiConfiguration apiConfiguration) {
        if (apiConfiguration == null) {
            throw new IllegalArgumentException("ApiConfiguration must be provided");
        }
        this.apiClient = apiConfiguration.getApiClient();
        this.serializer = apiConfiguration.getSerializer();
        this.authorizationValue = apiConfiguration.getAuthorizationValue();
        this.apiEndpoint = apiConfiguration.getApiEndpoint();
    }

    @Deprecated
    protected Object invoke(String method, String endpoint, String path, List<Pair<String, String>> queryParams, List<Pair<String, String>> headerParams, Map<String, String> pathParams, List<ServiceClientResponse> responseDefinitions, Object body, Class responseType) throws ServiceException {
        return this.invoke(method, endpoint, path, queryParams, headerParams, pathParams, responseDefinitions, body, responseType, false);
    }

    @Deprecated
    protected Object invoke(String method, String endpoint, String path, List<Pair<String, String>> queryParams, List<Pair<String, String>> headerParams, Map<String, String> pathParams, List<ServiceClientResponse> responseDefinitions, Object body, Class responseType, boolean rawRequest) throws ServiceException {
        ApiResponse response = this.executeRequest(method, endpoint, path, queryParams, headerParams, pathParams, responseDefinitions, body, responseType, rawRequest);
        return response != null ? response.getResponse() : null;
    }

    protected <T> ApiResponse<T> executeRequest(String method, String endpoint, String path, List<Pair<String, String>> queryParams, List<Pair<String, String>> headerParams, Map<String, String> pathParams, List<ServiceClientResponse> responseDefinitions, Object body, Class<T> responseType, boolean rawRequest) throws ServiceException {
        ApiClientResponse response;
        ApiClientRequest request = new ApiClientRequest();
        request.setUrl(BaseServiceClient.buildUrl(endpoint, path, queryParams, pathParams));
        request.setMethod(method);
        request.setHeaders(headerParams);
        if (body != null) {
            if (!rawRequest) {
                request.setBody(this.serializer.serialize(body));
            } else {
                request.setBody((String)body);
            }
        }
        try {
            response = this.apiClient.invoke(request);
        }
        catch (Exception ex) {
            throw new ServiceException("Call to service failed: " + ex.getMessage(), 500, null, null, ex);
        }
        if (BaseServiceClient.isCodeSuccessful(response.getStatusCode())) {
            if (responseType == null || response.getStatusCode() == 204 && (response.getBody() == null || "".equals(response.getBody()))) {
                return new ApiResponse<Object>(null, response.getStatusCode(), response.getHeaders());
            }
            T unmarshalledResponse = this.serializer.deserialize(response.getBody(), responseType);
            return new ApiResponse<T>(unmarshalledResponse, response.getStatusCode(), response.getHeaders());
        }
        ServiceClientResponse errorMetadata = responseDefinitions.stream().filter(x -> x.getStatusCode() == response.getStatusCode()).findFirst().orElseThrow(() -> new ServiceException("Unknown error", response.getStatusCode(), response.getHeaders(), response.getBody()));
        Object errorBody = this.serializer.deserialize(response.getBody(), errorMetadata.getType());
        throw new ServiceException(errorMetadata.getMessage(), errorMetadata.getStatusCode(), response.getHeaders(), errorBody);
    }

    private static boolean isCodeSuccessful(int responseCode) {
        return responseCode >= 200 && responseCode < 300;
    }

    private static String buildUrl(String endpoint, String path, List<Pair<String, String>> queryParameters, Map<String, String> pathParameters) {
        String processedEndpoint = endpoint.endsWith("/") ? endpoint.substring(0, endpoint.length() - 1) : endpoint;
        String pathWithParams = BaseServiceClient.interpolatePathParams(path, pathParameters);
        boolean isConstantQueryPresent = pathWithParams.contains("?");
        String queryString = BaseServiceClient.buildQueryString(queryParameters, isConstantQueryPresent);
        StringBuilder sb = new StringBuilder();
        sb.append(processedEndpoint);
        sb.append(pathWithParams);
        sb.append(queryString);
        return sb.toString();
    }

    private static String buildQueryString(List<Pair<String, String>> queryParameters, boolean isQueryStart) {
        if (queryParameters == null || queryParameters.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (isQueryStart) {
            sb.append("&");
        } else {
            sb.append("?");
        }
        for (int i = 0; i < queryParameters.size(); ++i) {
            Pair<String, String> param = queryParameters.get(i);
            sb.append(BaseServiceClient.escapeString(param.getName()));
            sb.append("=");
            sb.append(BaseServiceClient.escapeString(param.getValue()));
            sb.append("&");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    private static String escapeString(String s) {
        try {
            return URLEncoder.encode(s, StandardCharsets.UTF_8.name()).replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 unsupported on system. Unable to encode query string", e);
        }
    }

    private static String interpolatePathParams(String path, Map<String, String> params) {
        if (params == null || params.isEmpty()) {
            return path;
        }
        String result = path;
        for (Map.Entry<String, String> param : params.entrySet()) {
            String paramName = param.getKey();
            String paramValue = param.getValue();
            result = result.replaceAll("\\{" + paramName + "\\}", BaseServiceClient.escapeString(paramValue));
        }
        return result;
    }
}

