/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.hups;

import umontreal.ssj.hups.CachedPointSet;
import umontreal.ssj.hups.PointSetRandomization;
import umontreal.ssj.rng.RandomStream;

public class StratifiedUnitCubeAnti
extends CachedPointSet {
    protected int[] numDiv;
    protected double[] delta;

    public StratifiedUnitCubeAnti(int[] k, int dim) {
        this.dim = dim;
        this.delta = new double[dim];
        this.numDiv = new int[dim];
        this.numPoints = 2;
        for (int j = 0; j < dim; ++j) {
            this.numDiv[j] = k[j];
            this.numPoints *= k[j];
            this.delta[j] = 1.0 / (double)this.numDiv[j];
        }
        this.x = new double[this.numPoints][dim];
    }

    public StratifiedUnitCubeAnti(int k, int dim) {
        this.dim = dim;
        this.delta = new double[dim];
        this.numDiv = new int[dim];
        this.numPoints = 2;
        for (int j = 0; j < dim; ++j) {
            this.numDiv[j] = k;
            this.numPoints *= k;
            this.delta[j] = 1.0 / (double)k;
        }
        this.x = new double[this.numPoints][dim];
    }

    public void randomize(RandomStream stream) {
        int[] current = new int[this.dim];
        for (int j = 0; j < this.dim; ++j) {
            current[j] = 0;
        }
        int numBoxes = this.numPoints / 2;
        for (int b = 0; b < numBoxes; ++b) {
            int i = 2 * b;
            for (int j = 0; j < this.dim; ++j) {
                double u = stream.nextDouble();
                this.x[i][j] = ((double)current[j] + u) * this.delta[j];
                this.x[i + 1][j] = ((double)current[j] + 1.0 - u) * this.delta[j];
            }
            for (int l = 0; l < this.dim; ++l) {
                int n = l;
                current[n] = current[n] + 1;
                if (current[l] >= this.numDiv[l]) {
                    current[l] = 0;
                    continue;
                }
                l = this.dim;
            }
        }
    }

    @Override
    public void addRandomShift(int fromDim, int toDim, RandomStream stream) {
        this.randomize(stream);
    }

    @Override
    public void randomize(PointSetRandomization rand) {
        this.randomize(rand.getStream());
    }

    @Override
    public String toString() {
        return "StratifiedUnitCubeAnti: locally antithetic stratified point set over the unit cube in " + this.dim + "dimensions.";
    }
}

