/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.discrepancy;

import java.math.BigDecimal;
import java.math.MathContext;
import umontreal.ssj.discrepancy.BigDiscShiftBaker1;

public class BigDiscShiftBaker1Lattice
extends BigDiscShiftBaker1 {
    static final double TRENTEUN24 = 1.2916666666666667;
    static final double SEPT24 = 0.2916666666666667;
    static final BigDecimal BIGp5625 = new BigDecimal(0.5625);
    static final BigDecimal BIGp046875 = new BigDecimal(0.046875);
    static final BigDecimal BIGp0625 = new BigDecimal(0.0625);
    static final BigDecimal BIGp5 = new BigDecimal(0.5);
    static final BigDecimal BIG1p5 = new BigDecimal(1.5);
    static final BigDecimal BIG2 = new BigDecimal(2.0);
    static final BigDecimal BIG3 = new BigDecimal(3.0);
    static final BigDecimal BIG4 = new BigDecimal(4.0);
    static final BigDecimal BIG4p5 = new BigDecimal(4.5);
    static final BigDecimal BIG5 = new BigDecimal(5.0);
    static final BigDecimal BIG6 = new BigDecimal(6.0);
    static final BigDecimal BIG8 = new BigDecimal(8.0);
    static final BigDecimal BIG14 = new BigDecimal(14.0);
    static final BigDecimal BIG31s24 = new BigDecimal("1.2916666666666666666666666666666667");
    static final BigDecimal BIG7s24 = new BigDecimal("0.2916666666666666666666666666666667");

    public BigDiscShiftBaker1Lattice(int n, int s, double[] gamma) {
        super(n, s, gamma);
        this.setUBig(n);
        this.reserveCBig(s);
        this.setCBig(this.gamma, s);
        this.reserveFactorBig(n, s);
        this.setFactorBig(n, s);
    }

    public BigDiscShiftBaker1Lattice(int n, int s) {
        this(n, s, null);
    }

    protected void setFactorBig(int n, int s) {
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < s; ++j) {
                this.FactorBig[i][j] = BigDiscShiftBaker1Lattice.computeFactor(this.UBig[i], this.C1Big[j], this.C2Big[j], this.C3Big[j]);
            }
        }
    }

    private static BigDecimal computeFactor(BigDecimal x, BigDecimal C1, BigDecimal C2, BigDecimal C3) {
        BigDecimal pol1 = new BigDecimal(0);
        BigDecimal pol2 = new BigDecimal(0);
        BigDecimal pol3 = new BigDecimal(0);
        BigDecimal temp = new BigDecimal(0);
        pol1 = x;
        pol2 = x;
        pol3 = x;
        temp = x;
        if (x.compareTo(BIGp5) >= 0) {
            pol1 = pol1.multiply(BIG2);
            pol1 = pol1.subtract(BIG4p5);
            pol1 = pol1.multiply(x);
            pol1 = pol1.add(BIG3);
            pol1 = pol1.multiply(x);
            pol1 = pol1.subtract(BIGp5625);
            pol2 = pol2.multiply(BIG5);
            pol2 = pol2.negate();
            pol2 = pol2.add(BIG6);
            pol2 = pol2.multiply(x);
            pol2 = pol2.add(BIG4);
            pol2 = pol2.multiply(x);
            pol2 = pol2.negate();
            pol2 = pol2.add(BIG6);
            pol2 = pol2.multiply(x);
            pol2 = pol2.subtract(BIG31s24);
            temp = temp.multiply(BIG4);
            temp = temp.subtract(BIG6);
            temp = temp.multiply(x);
            temp = temp.add(BigDecimal.ONE);
            pol3 = pol3.multiply(BIG4);
            pol3 = pol3.subtract(BIG3);
            pol3 = pol3.multiply(temp);
            pol3 = pol3.multiply(temp);
            pol3 = pol3.multiply(BIGp046875);
        } else {
            pol1 = pol1.multiply(BIG2);
            pol1 = pol1.negate();
            pol1 = pol1.add(BIG1p5);
            pol1 = pol1.multiply(x);
            pol1 = pol1.multiply(x);
            pol1 = pol1.subtract(BIGp0625);
            pol2 = pol2.multiply(BIG5);
            pol2 = pol2.subtract(BIG14);
            pol2 = pol2.multiply(x);
            pol2 = pol2.add(BIG8);
            pol2 = pol2.multiply(x);
            pol2 = pol2.multiply(x);
            pol2 = pol2.subtract(BIG7s24);
            temp = temp.multiply(BIG4);
            temp = temp.negate();
            temp = temp.add(BIG2);
            temp = temp.multiply(x);
            temp = temp.add(BigDecimal.ONE);
            pol3 = pol3.multiply(BIG4);
            pol3 = pol3.subtract(BigDecimal.ONE);
            pol3 = pol3.multiply(temp);
            pol3 = pol3.multiply(temp);
            pol3 = pol3.multiply(BIGp046875);
            pol3 = pol3.negate();
        }
        BigDecimal sum = new BigDecimal(0);
        pol1 = pol1.multiply(C1);
        sum = sum.add(pol1);
        pol2 = pol2.multiply(C2);
        sum = sum.add(pol2);
        pol3 = pol3.multiply(C3);
        sum = sum.add(pol3);
        return sum;
    }

    public double compute(long[] a, int s) {
        BigDecimal prod = new BigDecimal(1);
        BigDecimal tem = new BigDecimal(0);
        BigDecimal sum = new BigDecimal(0);
        long nl = this.numPoints;
        for (long i = 0L; i < nl; ++i) {
            prod = BigDecimal.ONE;
            for (int j = 0; j < s; ++j) {
                int r = (int)(i * a[j] % nl);
                tem = this.FactorBig[r][j];
                tem = tem.negate();
                tem = tem.add(BigDecimal.ONE);
                prod = prod.multiply(tem);
            }
            sum = sum.add(prod);
        }
        sum = sum.divide(new BigDecimal(nl), MathContext.DECIMAL128);
        double disc = (sum = sum.subtract(BigDecimal.ONE)).doubleValue();
        if (disc < 0.0) {
            return -1.0;
        }
        return Math.sqrt(disc);
    }

    @Override
    public double compute(double[][] points, int n, int s) {
        BigDiscShiftBaker1Lattice.setONES(s);
        return this.compute(points, n, s, ONES);
    }

    @Override
    public double compute(double[][] points, int n, int s, double[] gamma) {
        throw new UnsupportedOperationException("method NOT IMPLEMENTED");
    }
}

