/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.stat.density;

import umontreal.ssj.probdist.ContinuousDistribution;
import umontreal.ssj.stat.density.DensityEstimator;

public class DEKernelDensity
extends DensityEstimator {
    private ContinuousDistribution kernel;
    private double h;
    private double eps = 1.0E-10;

    public DEKernelDensity(double[] data) {
        this.data = data;
    }

    public DEKernelDensity(ContinuousDistribution kernel) {
        this.setKernel(kernel);
    }

    public DEKernelDensity(ContinuousDistribution kernel, double[] data) {
        this.setKernel(kernel);
        this.data = data;
    }

    public DEKernelDensity(double h) {
        this.setH(h);
    }

    public DEKernelDensity(double h, double[] data) {
        this(h);
        this.data = data;
    }

    public DEKernelDensity(ContinuousDistribution kernel, double h) {
        this(kernel);
        this.setH(h);
    }

    public DEKernelDensity(ContinuousDistribution kernel, double h, double[] data) {
        this(kernel, data);
        this.setH(h);
    }

    @Override
    public void setData(double[] data) {
        this.data = data;
    }

    public void setH(double h) {
        this.h = h;
    }

    public double getH() {
        return this.h;
    }

    public ContinuousDistribution getKernel() {
        return this.kernel;
    }

    public void setKernel(ContinuousDistribution kernel) {
        this.kernel = kernel;
    }

    public double getEps() {
        return this.eps;
    }

    public void setEps(double eps) {
        this.eps = eps;
    }

    @Override
    public double evalDensity(double x) {
        int n = this.data.length;
        double invh = 1.0 / this.h;
        double invhn = invh / (double)n;
        double sum = 0.0;
        int imin = 0;
        double term = this.kernel.density((x - this.data[imin]) * invh);
        while (term < this.eps && imin < n - 1 && this.data[imin] < x) {
            term = this.kernel.density((x - this.data[++imin]) * invh);
        }
        sum = term;
        for (int i = imin + 1; i < n && (term > this.eps || this.data[i] < x); ++i) {
            term = this.kernel.density((x - this.data[i]) * invh);
            sum += term;
        }
        double density = sum * invhn;
        return density;
    }

    @Override
    public double[] evalDensity(double[] evalPoints) {
        int k = evalPoints.length;
        double[] density = new double[k];
        int n = this.data.length;
        double invh = 1.0 / this.h;
        double invhn = invh / (double)n;
        double sum = 0.0;
        int imin = 0;
        for (int j = 0; j < k; ++j) {
            double y = evalPoints[j];
            double term = this.kernel.density((y - this.data[imin]) * invh);
            while (term < this.eps && imin < n - 1 && this.data[imin] < y) {
                term = this.kernel.density((y - this.data[++imin]) * invh);
            }
            sum = term;
            for (int i = imin + 1; i < n && (term > this.eps || this.data[i] < y); ++i) {
                term = this.kernel.density((y - this.data[i]) * invh);
                sum += term;
            }
            density[j] = sum * invhn;
        }
        return density;
    }

    @Override
    public String toString() {
        String str = "KDE [h = " + this.h + ", Kernel: " + this.kernel.toString() + "]";
        return str;
    }

    public static double evalDensity(double x, ContinuousDistribution kernel, double h, double[] data, double eps) {
        int n = data.length;
        double invh = 1.0 / h;
        double invhn = invh / (double)n;
        double sum = 0.0;
        int imin = 0;
        double term = kernel.density((x - data[imin]) * invh);
        while (term < eps && imin < n - 1 && data[imin] < x) {
            term = kernel.density((x - data[++imin]) * invh);
        }
        sum = term;
        for (int i = imin + 1; i < n && (term > eps || data[i] < x); ++i) {
            term = kernel.density((x - data[i]) * invh);
            sum += term;
        }
        double density = sum * invhn;
        return density;
    }

    public static double[] evalDensity(double[] evalPoints, ContinuousDistribution kernel, double h, double[] data, double eps) {
        int k = evalPoints.length;
        double[] density = new double[k];
        int n = data.length;
        double invh = 1.0 / h;
        double invhn = invh / (double)n;
        double sum = 0.0;
        int imin = 0;
        for (int j = 0; j < k; ++j) {
            double y = evalPoints[j];
            double term = kernel.density((y - data[imin]) * invh);
            while (term < eps && imin < n - 1 && data[imin] < y) {
                term = kernel.density((y - data[++imin]) * invh);
            }
            sum = term;
            for (int i = imin + 1; i < n && (term > eps || data[i] < y); ++i) {
                term = kernel.density((y - data[i]) * invh);
                sum += term;
            }
            density[j] = sum * invhn;
        }
        return density;
    }

    public static double[][] evalDensity(double[] evalPoints, ContinuousDistribution kernel, double h, double[][] data, double eps) {
        int m = data.length;
        int k = evalPoints.length;
        double[][] density = new double[m][k];
        for (int rep = 0; rep < m; ++rep) {
            density[rep] = DEKernelDensity.evalDensity(evalPoints, kernel, h, data[rep], eps);
        }
        return density;
    }
}

