/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.latnetbuilder;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import umontreal.ssj.hups.PointSet;

public abstract class Search {
    String pathToOutputFolder = "latnetbuilder_results";
    static String PATH_TO_LATNETBUILDER = "latnetbuilder";
    String sizeParameter;
    int dimension;
    boolean multilevel = false;
    String combiner;
    String explorationMethod;
    String figure;
    String normType;
    ArrayList<String> weights = new ArrayList();
    ArrayList<String> filters = new ArrayList();
    boolean successful = false;
    double merit = 0.0;
    double time = 0.0;

    protected Search() {
    }

    public String toString() {
        return "Point Set Type: " + this.pointSetType() + "\nConstruction method: " + this.construction() + "\nSize parameter: " + this.sizeParameter + "\nMultilevel: " + this.multilevel + "\nDimension: " + this.dimension + "\nInterlacing: " + this.interlacing() + "\nExploration method: " + this.explorationMethod + "\nFigure of merit: " + this.figure + "\nNorm-type: " + this.normType + "\nCombiner: " + this.combiner + "\nFilters: " + this.filters + "\nWeights: " + this.weights + "\nOutput folder: " + this.pathToOutputFolder;
    }

    public abstract String pointSetType();

    public abstract int interlacing();

    public abstract String construction();

    private String constructCommandLine() {
        StringBuffer sb = new StringBuffer(PATH_TO_LATNETBUILDER + " -v 0");
        sb.append(" -t " + this.pointSetType());
        sb.append(" -c " + this.construction());
        sb.append(" -M " + this.multilevel);
        sb.append(" -s " + this.sizeParameter);
        sb.append(" -f " + this.figure);
        sb.append(" -q " + this.normType);
        sb.append(" -e " + this.explorationMethod);
        sb.append(" -d " + this.dimension);
        sb.append(" -i " + this.interlacing());
        sb.append(" --output-folder " + this.pathToOutputFolder);
        sb.append(" -w");
        for (String w : this.weights) {
            sb.append(" " + w);
        }
        if (this.filters.size() > 0) {
            sb.append(" -F ");
        }
        for (String f : this.filters) {
            sb.append(" " + f);
        }
        if (this.multilevel) {
            sb.append(" -C " + this.combiner);
        }
        return sb.toString();
    }

    protected ArrayList<String> executeCommandLine() {
        String cmd = this.constructCommandLine();
        BufferedReader br = null;
        try {
            String line;
            Process p = Runtime.getRuntime().exec(cmd);
            BufferedReader stderr = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            try {
                p.waitFor();
                String res = "";
                if (p.exitValue() != 0) {
                    while (stderr.ready()) {
                        res = res + "\n" + stderr.readLine();
                    }
                    throw new RuntimeException("LatNet Builder exited with status " + p.exitValue() + "\nCOMMAND LINE: " + cmd + res);
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException("LatNet Builder interrupted");
            }
            File f = new File(this.pathToOutputFolder, "outputMachine.txt");
            br = new BufferedReader(new FileReader(f));
            ArrayList<String> res = new ArrayList<String>();
            while ((line = br.readLine()) != null) {
                res.add(line);
            }
            ArrayList<String> arrayList = res;
            return arrayList;
        }
        catch (IOException e) {
            throw new RuntimeException("Error in the communication with LatNet Builder");
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Error in the communication with LatNet Builder");
            }
        }
    }

    public abstract PointSet search() throws RuntimeException;

    public double merit() {
        return this.merit;
    }

    public double time() {
        return this.time;
    }

    public boolean successful() {
        return this.successful;
    }

    public void setPathToLatNetBuilder(String path) {
        PATH_TO_LATNETBUILDER = path;
    }

    public void setDimension(int dimension) {
        this.dimension = dimension;
    }

    public void setSizeParameter(String sizeParameter) {
        this.sizeParameter = sizeParameter;
    }

    public void setMultilevel(boolean multilevel) {
        this.multilevel = multilevel;
    }

    public void setCombiner(String combiner) {
        this.combiner = combiner;
    }

    public void setExplorationMethod(String explorationMethod) {
        this.explorationMethod = explorationMethod;
    }

    public void setFigureOfMerit(String figure) {
        this.figure = figure;
    }

    public void setNormType(String normType) {
        this.normType = normType;
    }

    public void setWeights(List<String> weights) {
        this.weights = new ArrayList<String>(weights);
    }

    public void addWeight(String weight) {
        this.weights.add(weight);
    }

    public void setFilters(List<String> filters) {
        this.filters = new ArrayList<String>(filters);
    }

    public void setPathToOutputFolder(String path) {
        this.pathToOutputFolder = path;
    }
}

