/*
 * Decompiled with CFR 0.152.
 */
package org.sharengo.wikitty.multistorage;

import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.wikitty.UpdateResponse;
import org.sharengo.wikitty.WikittyException;
import org.sharengo.wikitty.WikittyExtension;
import org.sharengo.wikitty.WikittyExtensionStorage;
import org.sharengo.wikitty.WikittyTransaction;
import org.sharengo.wikitty.multistorage.MultiStorageConfiguration;

public class WikittyExtensionMultiStorage
implements WikittyExtensionStorage {
    private static Log log = LogFactory.getLog(WikittyExtensionMultiStorage.class);
    protected MultiStorageConfiguration configuration;

    public WikittyExtensionMultiStorage(MultiStorageConfiguration configuration) {
        this.configuration = configuration;
    }

    public UpdateResponse store(WikittyTransaction transaction, Collection<WikittyExtension> extensions) {
        List<WikittyExtensionStorage> extensionStorageMasters = this.configuration.getExtensionStorageMasters();
        for (WikittyExtensionStorage extensionStorage : extensionStorageMasters) {
            extensionStorage.store(transaction, extensions);
        }
        List<WikittyExtensionStorage> extensionStorageReplications = this.configuration.getExtensionStorageReplications();
        for (WikittyExtensionStorage extensionStorage : extensionStorageReplications) {
            extensionStorage.store(transaction, extensions);
        }
        UpdateResponse result = new UpdateResponse();
        return result;
    }

    public boolean exists(WikittyTransaction transaction, String id) {
        WikittyExtensionStorage currentMasterExtensionStorage = this.configuration.getCurrentMasterExtensionStorage();
        boolean result = currentMasterExtensionStorage.exists(transaction, id);
        return result;
    }

    public List<String> getAllExtensionIds(WikittyTransaction transaction) {
        WikittyExtensionStorage currentMasterExtensionStorage = this.configuration.getCurrentMasterExtensionStorage();
        List result = currentMasterExtensionStorage.getAllExtensionIds(transaction);
        return result;
    }

    public List<String> getAllExtensionsRequires(WikittyTransaction transaction, String extensionName) {
        WikittyExtensionStorage currentMasterExtensionStorage = this.configuration.getCurrentMasterExtensionStorage();
        List result = currentMasterExtensionStorage.getAllExtensionsRequires(transaction, extensionName);
        return result;
    }

    public String getLastVersion(WikittyTransaction transaction, String extName) {
        WikittyExtensionStorage currentMasterExtensionStorage = this.configuration.getCurrentMasterExtensionStorage();
        String result = currentMasterExtensionStorage.getLastVersion(transaction, extName);
        return result;
    }

    public WikittyExtension restore(WikittyTransaction transaction, String name, String version) throws WikittyException {
        WikittyExtensionStorage currentMasterExtensionStorage = this.configuration.getCurrentMasterExtensionStorage();
        WikittyExtension result = currentMasterExtensionStorage.restore(transaction, name, version);
        return result;
    }

    public void clear(WikittyTransaction transaction) {
        List<WikittyExtensionStorage> extensionStorageMasters = this.configuration.getExtensionStorageMasters();
        for (WikittyExtensionStorage master : extensionStorageMasters) {
            master.clear(transaction);
        }
        List<WikittyExtensionStorage> extensionStorageReplications = this.configuration.getExtensionStorageReplications();
        for (WikittyExtensionStorage extensionStorage : extensionStorageReplications) {
            extensionStorage.clear(transaction);
        }
    }
}

