/*
 * Decompiled with CFR 0.152.
 */
package org.sharengo.wikitty.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.UpdateResponse;
import org.sharengo.wikitty.WikittyException;
import org.sharengo.wikitty.WikittyExtension;
import org.sharengo.wikitty.WikittyExtensionStorage;
import org.sharengo.wikitty.WikittyTransaction;
import org.sharengo.wikitty.WikittyUtil;
import org.sharengo.wikitty.jdbc.WikittyJDBCUtil;

public class WikittyExtensionStorageJDBC
implements WikittyExtensionStorage {
    protected static Log log = LogFactory.getLog(WikittyExtensionStorageJDBC.class);
    protected final Properties conf;
    protected Map<String, WikittyExtension> extensionCache = new HashMap<String, WikittyExtension>();
    protected Map<String, String> lastVersion = null;

    public WikittyExtensionStorageJDBC() {
        this(null);
    }

    public WikittyExtensionStorageJDBC(Properties properties) {
        this.conf = WikittyJDBCUtil.loadProperties(properties);
        try {
            Class.forName(this.conf.getProperty("jdbc.con.driver"));
        }
        catch (ClassNotFoundException eee) {
            if (log.isFatalEnabled()) {
                log.fatal((Object)"Couldn't find the driver!");
            }
            throw new WikittyException((Exception)eee);
        }
        Connection connection = WikittyJDBCUtil.getJDBCConnection(this.conf);
        try {
            Statement statement = connection.createStatement();
            statement.execute(this.conf.getProperty("jdbc.queries.creation.extension.admin"));
            statement.execute(this.conf.getProperty("jdbc.queries.creation.extension.data"));
            WikittyJDBCUtil.commitJDBCConnection(connection);
        }
        catch (SQLException eee) {
            WikittyJDBCUtil.rollbackJDBCConnection(connection);
            throw new WikittyException((Exception)eee);
        }
        finally {
            WikittyJDBCUtil.closeQuietly(connection);
        }
    }

    public UpdateResponse store(WikittyTransaction transaction, Collection<WikittyExtension> extensions) throws WikittyException {
        Connection connection = WikittyJDBCUtil.getConnection(this.conf);
        try {
            UpdateResponse result;
            for (WikittyExtension ext : extensions) {
                String id = ext.getId();
                String query = String.format(this.conf.getProperty("jdbc.queries.select.where"), "version", WikittyJDBCUtil.TABLE_EXTENSION_ADMIN, "id");
                PreparedStatement statement = connection.prepareStatement(query);
                statement.setString(1, id);
                ResultSet versionResultSet = statement.executeQuery();
                if (!versionResultSet.first()) {
                    WikittyJDBCUtil.doQuery(connection, this.conf.getProperty("jdbc.queries.insert.extension.admin"), ext.getId(), ext.getName(), ext.getVersion(), ext.getRequires(), WikittyUtil.tagValuesToString((Map)ext.getTagValues()));
                    for (String fieldName : ext.getFieldNames()) {
                        FieldType type = ext.getFieldType(fieldName);
                        WikittyJDBCUtil.doQuery(connection, this.conf.getProperty("jdbc.queries.insert.extension.data"), ext.getId(), fieldName, type.toDefinition(fieldName));
                    }
                    continue;
                }
                log.warn((Object)("The extension is found " + id));
            }
            this.lastVersion = null;
            UpdateResponse updateResponse = result = new UpdateResponse();
            return updateResponse;
        }
        catch (SQLException eee) {
            throw new WikittyException((Exception)eee);
        }
        finally {
            WikittyJDBCUtil.closeQuietly(connection);
        }
    }

    public boolean exists(WikittyTransaction transaction, String id) {
        Connection connection = WikittyJDBCUtil.getConnection(this.conf);
        try {
            boolean result;
            String q = String.format(this.conf.getProperty("jdbc.queries.select.where"), "id", WikittyJDBCUtil.TABLE_EXTENSION_ADMIN, "id");
            PreparedStatement statement = connection.prepareStatement(q);
            statement.setString(1, id);
            ResultSet resultSet = statement.executeQuery();
            boolean bl = result = resultSet.first();
            return bl;
        }
        catch (SQLException eee) {
            throw new WikittyException((Exception)eee);
        }
        finally {
            WikittyJDBCUtil.closeQuietly(connection);
        }
    }

    public List<String> getAllExtensionIds(WikittyTransaction transaction) {
        Connection connection = WikittyJDBCUtil.getConnection(this.conf);
        try {
            ArrayList<String> result = new ArrayList<String>();
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(String.format(this.conf.getProperty("jdbc.queries.select"), "id", WikittyJDBCUtil.TABLE_EXTENSION_ADMIN));
            resultSet.beforeFirst();
            while (resultSet.next()) {
                String id = resultSet.getString("id");
                result.add(id);
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        catch (SQLException eee) {
            throw new WikittyException((Exception)eee);
        }
        finally {
            WikittyJDBCUtil.closeQuietly(connection);
        }
    }

    public List<String> getAllExtensionsRequires(WikittyTransaction transaction, String extensionName) {
        Connection connection = WikittyJDBCUtil.getConnection(this.conf);
        try {
            ArrayList<String> result = new ArrayList<String>();
            String q = String.format(this.conf.getProperty("jdbc.queries.select.where"), "id", WikittyJDBCUtil.TABLE_EXTENSION_ADMIN, "requires");
            PreparedStatement statement = connection.prepareStatement(q);
            statement.setString(1, extensionName);
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                String id = resultSet.getString("id");
                result.add(id);
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        catch (SQLException eee) {
            throw new WikittyException((Exception)eee);
        }
        finally {
            WikittyJDBCUtil.closeQuietly(connection);
        }
    }

    public String getLastVersion(WikittyTransaction transaction, String extName) {
        if (this.lastVersion == null) {
            this.lastVersion = new HashMap<String, String>();
            Connection connection = WikittyJDBCUtil.getConnection(this.conf);
            try {
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery(String.format(this.conf.getProperty("jdbc.queries.select"), "name,version", WikittyJDBCUtil.TABLE_EXTENSION_ADMIN));
                resultSet.beforeFirst();
                while (resultSet.next()) {
                    String name = resultSet.getString("name");
                    String version = resultSet.getString("version");
                    String prevVersion = this.lastVersion.get(name);
                    if (prevVersion != null && !WikittyUtil.versionGreaterThan((String)version, (String)prevVersion)) continue;
                    this.lastVersion.put(name, version);
                }
            }
            catch (SQLException eee) {
                throw new WikittyException((Exception)eee);
            }
            finally {
                WikittyJDBCUtil.closeQuietly(connection);
            }
        }
        String result = this.lastVersion.get(extName);
        return result;
    }

    public WikittyExtension restore(WikittyTransaction transaction, String name, String version) throws WikittyException {
        String id = WikittyExtension.computeId((String)name, (String)version);
        WikittyExtension result = this.extensionCache.get(id);
        if (result == null) {
            Connection connection = WikittyJDBCUtil.getConnection(this.conf);
            try {
                String q = String.format(this.conf.getProperty("jdbc.queries.select.where"), "*", WikittyJDBCUtil.TABLE_EXTENSION_ADMIN, "id");
                PreparedStatement statement = connection.prepareStatement(q);
                statement.setString(1, id);
                ResultSet adminResultSet = statement.executeQuery();
                if (adminResultSet.first()) {
                    String extName = adminResultSet.getString("name");
                    String extVersion = adminResultSet.getString("version");
                    LinkedHashMap<String, FieldType> fieldTypes = new LinkedHashMap<String, FieldType>();
                    String qdata = String.format(this.conf.getProperty("jdbc.queries.select.where"), "*", WikittyJDBCUtil.TABLE_EXTENSION_DATA, "id");
                    PreparedStatement sta = connection.prepareStatement(qdata);
                    sta.setString(1, id);
                    ResultSet dataResultSet = sta.executeQuery();
                    dataResultSet.beforeFirst();
                    while (dataResultSet.next()) {
                        String fieldDef = dataResultSet.getString("fieldType");
                        FieldType fieldType = new FieldType();
                        String fieldName = WikittyUtil.parseField((String)fieldDef, (FieldType)fieldType);
                        fieldTypes.put(fieldName, fieldType);
                    }
                    String extRequires = adminResultSet.getString("requires");
                    result = new WikittyExtension(extName, extVersion, extRequires, fieldTypes);
                    String extTagValues = adminResultSet.getString("tagvalues");
                    result.setTagValues(WikittyUtil.tagValuesToMap((String)extTagValues));
                    this.extensionCache.put(id, result);
                }
            }
            catch (SQLException eee) {
                throw new WikittyException(String.format("Can't load extension %s", id), (Exception)eee);
            }
            finally {
                WikittyJDBCUtil.closeQuietly(connection);
            }
        }
        return result;
    }

    public void clear(WikittyTransaction transaction) {
        Connection connection = WikittyJDBCUtil.getConnection(this.conf);
        try {
            this.lastVersion = null;
            WikittyJDBCUtil.doQuery(connection, this.conf.getProperty("jdbc.queries.clear.extension"), new Object[0]);
        }
        catch (Exception eee) {
            throw new WikittyException(eee);
        }
        finally {
            WikittyJDBCUtil.closeQuietly(connection);
        }
    }
}

