package org.nuiton.wikitty.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;

public class PegasusHelper {

    /**
     * utility class all provided methods are accessible the static way
     */
    private PegasusHelper() {// empty
}

    public static String getSex(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(Pegasus.EXT_PEGASUS, Pegasus.FIELD_PEGASUS_SEX);
        return value;
}

    public static String setSex(Wikitty wikitty, String sex) {
        String oldValue = getSex(wikitty);
        wikitty.setField(Pegasus.EXT_PEGASUS, Pegasus.FIELD_PEGASUS_SEX, sex);
        return oldValue;
}

    public static String getRealm(Wikitty wikitty) {
        String value = wikitty.getFieldAsWikitty(Pegasus.EXT_PEGASUS, Pegasus.FIELD_PEGASUS_REALM);
        return value;
}

    public static String setRealm(Wikitty wikitty, String realm) {
        String oldValue = getRealm(wikitty);
        wikitty.setField(Pegasus.EXT_PEGASUS, Pegasus.FIELD_PEGASUS_REALM, realm);
        return oldValue;
}

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(Pegasus.EXT_PEGASUS, Pegasus.FIELD_PEGASUS_SEX);
            Object f2 = w2.getFieldAsObject(Pegasus.EXT_PEGASUS, Pegasus.FIELD_PEGASUS_SEX);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Pegasus.EXT_PEGASUS, Pegasus.FIELD_PEGASUS_REALM);
            Object f2 = w2.getFieldAsObject(Pegasus.EXT_PEGASUS, Pegasus.FIELD_PEGASUS_REALM);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return 
     */
    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * check if wikitty has current extension
     * @param wikitty 
     * @return 
     */
    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(Pegasus.EXT_PEGASUS);
}

    /**
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */
    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : PegasusAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}

    /**
     * Return toString representation. Use tagValue 'toString' format, if exist, else standard toString is call
     * @param wikitty 
     * @return 
     */
    public static String toString(Wikitty wikitty) {

        return wikitty.toString(Pegasus.EXT_PEGASUS);
}

} //PegasusHelper
