package org.nuiton.wikitty.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserHelper;
import org.nuiton.wikitty.entities.WikittyUserImpl;

public abstract class KingAbstract extends BusinessEntityImpl implements King {

    public static final List<WikittyExtension> extensions;

    public static final WikittyExtension extensionKing;

    @Override
    public String getLogin() {
String value = WikittyUserHelper.getLogin(getWikitty());
return value;
}

    @Override
    public void setLogin(String login) {
String oldValue = getLogin();
WikittyUserHelper.setLogin(getWikitty(), login);
getPropertyChangeSupport().firePropertyChange(WikittyUser.FIELD_WIKITTYUSER_LOGIN, oldValue, getLogin());
}

    @Override
    public String getPassword() {
String value = WikittyUserHelper.getPassword(getWikitty());
return value;
}

    @Override
    public void setPassword(String password) {
String oldValue = getPassword();
WikittyUserHelper.setPassword(getWikitty(), password);
getPropertyChangeSupport().firePropertyChange(WikittyUser.FIELD_WIKITTYUSER_PASSWORD, oldValue, getPassword());
}

    public KingAbstract() {
        super();
}

    public KingAbstract(Wikitty wikitty) {
        super(wikitty);
}

    public KingAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

    static {
    
        extensionKing = new WikittyExtension(EXT_KING,
                "1.0", // version
                WikittyUtil.tagValuesToMap(""), // tag/values
                WikittyUser.EXT_WIKITTYUSER,
                WikittyUtil.buildFieldMapExtension( // building field map
                    ));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.addAll(WikittyUserAbstract.extensions); 
        // current after requires ones

        exts.add(extensionKing);
        extensions = Collections.unmodifiableList(exts);

    }

    /**
     * Return toString representation. Use tagValue 'toString' format, if exist, else standard toString is call
     * @return 
     */
    @Override
    public String toString() {
        return KingHelper.toString(getWikitty());
}

} //KingAbstract
