/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty;

import java.util.Arrays;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.config.ArgumentsParserException;
import org.nuiton.config.ConfigActionDef;
import org.nuiton.config.ConfigOptionDef;
import org.nuiton.i18n.I18n;
import org.nuiton.wikitty.WikittyConfigAction;
import org.nuiton.wikitty.WikittyConfigOption;

public class WikittyConfig {
    private static Log log = LogFactory.getLog(WikittyConfig.class);

    private WikittyConfig() {
    }

    public static ApplicationConfig getConfig() {
        return WikittyConfig.getConfig(null, null, new String[0]);
    }

    public static ApplicationConfig getConfig(String[] args) {
        return WikittyConfig.getConfig(null, null, args);
    }

    public static ApplicationConfig getConfig(String configFilename) {
        return WikittyConfig.getConfig(null, configFilename, new String[0]);
    }

    public static ApplicationConfig getConfig(Properties props) {
        return WikittyConfig.getConfig(props, null, new String[0]);
    }

    public static ApplicationConfig getConfig(Properties props, String configFilename, String ... args) {
        ApplicationConfig config;
        block2: {
            config = new ApplicationConfig(props, configFilename);
            config.loadDefaultOptions((ConfigOptionDef[])WikittyConfigOption.values());
            config.loadActions((ConfigActionDef[])WikittyConfigAction.values());
            try {
                config.parse(args);
            }
            catch (ArgumentsParserException eee) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)"Can't load wikitty configuration", (Throwable)eee);
            }
        }
        return config;
    }

    public static String getCryptPassword(ApplicationConfig config, String password) {
        if (StringUtils.isBlank((CharSequence)password)) {
            password = config.getOption(WikittyConfigOption.WIKITTY_STORAGE_CRYPT_PASSWORD.getKey());
        }
        return password;
    }

    public static void help() {
        System.out.println("Wikitty configuration and action");
        System.out.println("Options (set with --option <key> <value>:");
        for (WikittyConfigOption wikittyConfigOption : WikittyConfigOption.values()) {
            log.debug((Object)("\t" + wikittyConfigOption.key + "(" + wikittyConfigOption.defaultValue + "):" + I18n.t((String)wikittyConfigOption.description, (Object[])new Object[0])));
        }
        log.debug((Object)"Actions:");
        for (Enum enum_ : WikittyConfigAction.values()) {
            log.debug((Object)("\t" + Arrays.toString(((WikittyConfigAction)enum_).aliases) + "(" + ((WikittyConfigAction)enum_).action + "):" + I18n.t((String)((WikittyConfigAction)enum_).description, (Object[])new Object[0])));
        }
        System.exit(0);
    }
}

