/*
 * #%L
 * Wikitty :: api
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;


public  class WikittyAuthorisationHelper {

    /**
     * WikittyAuthorisationHelper :
     * utility class all provided methods are accessible the static way
     */

    private WikittyAuthorisationHelper() {// empty
}

    /**
     * getOwner :
     * @param wikitty 
     * @return String 
     */

    public static String getOwner(Wikitty wikitty) {
        String value = wikitty.getFieldAsWikitty(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_OWNER);
        return value;
}

    /**
     * setOwner :
     * @param wikitty 
     * @param owner 
     * @return String 
     */

    public static String setOwner(Wikitty wikitty, String owner) {
        String oldValue = getOwner(wikitty);
        wikitty.setField(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_OWNER, owner);
        return oldValue;
}

    /**
     * getAdmin :
     * @param wikitty 
     * @return Set<String> 
     */

    public static Set<String> getAdmin(Wikitty wikitty) {
        Set<String> result = wikitty.getFieldAsSet(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_ADMIN, String.class);
        return result;
}

    /**
     * setAdmin :
     * @param wikitty 
     * @param admin 
     */

    public static void setAdmin(Wikitty wikitty, Set<String> admin) {
        clearAdmin(wikitty);
        addAllAdmin(wikitty, admin);
}

    /**
     * addAllAdmin :
     * @param wikitty 
     * @param admin 
     */

    public static void addAllAdmin(Wikitty wikitty, Set<String> admin) {
        if(admin != null){
            for (String id:admin){
                addAdmin(wikitty, id);
            }
        }
}

    /**
     * addAdmin :
     * @param wikitty 
     * @param element 
     */

    public static void addAdmin(Wikitty wikitty, String element) {
        wikitty.addToField(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_ADMIN, element);
}

    /**
     * removeAdmin :
     * @param wikitty 
     * @param element 
     */

    public static void removeAdmin(Wikitty wikitty, String element) {
        wikitty.removeFromField(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_ADMIN, element);
}

    /**
     * clearAdmin :
     * @param wikitty 
     */

    public static void clearAdmin(Wikitty wikitty) {
        wikitty.clearField(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_ADMIN);
}

    /**
     * getWriter :
     * @param wikitty 
     * @return Set<String> 
     */

    public static Set<String> getWriter(Wikitty wikitty) {
        Set<String> result = wikitty.getFieldAsSet(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_WRITER, String.class);
        return result;
}

    /**
     * setWriter :
     * @param wikitty 
     * @param writer 
     */

    public static void setWriter(Wikitty wikitty, Set<String> writer) {
        clearWriter(wikitty);
        addAllWriter(wikitty, writer);
}

    /**
     * addAllWriter :
     * @param wikitty 
     * @param writer 
     */

    public static void addAllWriter(Wikitty wikitty, Set<String> writer) {
        if(writer != null){
            for (String id:writer){
                addWriter(wikitty, id);
            }
        }
}

    /**
     * addWriter :
     * @param wikitty 
     * @param element 
     */

    public static void addWriter(Wikitty wikitty, String element) {
        wikitty.addToField(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_WRITER, element);
}

    /**
     * removeWriter :
     * @param wikitty 
     * @param element 
     */

    public static void removeWriter(Wikitty wikitty, String element) {
        wikitty.removeFromField(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_WRITER, element);
}

    /**
     * clearWriter :
     * @param wikitty 
     */

    public static void clearWriter(Wikitty wikitty) {
        wikitty.clearField(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_WRITER);
}

    /**
     * getReader :
     * @param wikitty 
     * @return Set<String> 
     */

    public static Set<String> getReader(Wikitty wikitty) {
        Set<String> result = wikitty.getFieldAsSet(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_READER, String.class);
        return result;
}

    /**
     * setReader :
     * @param wikitty 
     * @param reader 
     */

    public static void setReader(Wikitty wikitty, Set<String> reader) {
        clearReader(wikitty);
        addAllReader(wikitty, reader);
}

    /**
     * addAllReader :
     * @param wikitty 
     * @param reader 
     */

    public static void addAllReader(Wikitty wikitty, Set<String> reader) {
        if(reader != null){
            for (String id:reader){
                addReader(wikitty, id);
            }
        }
}

    /**
     * addReader :
     * @param wikitty 
     * @param element 
     */

    public static void addReader(Wikitty wikitty, String element) {
        wikitty.addToField(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_READER, element);
}

    /**
     * removeReader :
     * @param wikitty 
     * @param element 
     */

    public static void removeReader(Wikitty wikitty, String element) {
        wikitty.removeFromField(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_READER, element);
}

    /**
     * clearReader :
     * @param wikitty 
     */

    public static void clearReader(Wikitty wikitty) {
        wikitty.clearField(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_READER);
}

    /**
     * getParent :
     * @param wikitty 
     * @return String 
     */

    public static String getParent(Wikitty wikitty) {
        String value = wikitty.getFieldAsWikitty(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_PARENT);
        return value;
}

    /**
     * setParent :
     * @param wikitty 
     * @param parent 
     * @return String 
     */

    public static String setParent(Wikitty wikitty, String parent) {
        String oldValue = getParent(wikitty);
        wikitty.setField(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_PARENT, parent);
        return oldValue;
}

    /**
     * equals :
     * @param w1 
     * @param w2 
     * @return boolean 
     */

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_OWNER);
            Object f2 = w2.getFieldAsObject(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_OWNER);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_ADMIN);
            Object f2 = w2.getFieldAsObject(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_ADMIN);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_WRITER);
            Object f2 = w2.getFieldAsObject(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_WRITER);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_READER);
            Object f2 = w2.getFieldAsObject(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_READER);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_PARENT);
            Object f2 = w2.getFieldAsObject(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_PARENT);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * isExtension :
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return boolean 
     */

    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * hasExtension :
     * check if wikitty has current extension
     * @param wikitty 
     * @return boolean 
     */

    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION);
}

    /**
     * addExtension :
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */

    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : WikittyAuthorisationAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}

    /**
     * addMetaExtension :
     * add WikittyAuthorisation meta-extension on given extension to the given wikitty
     * @param extension 
     * @param wikitty 
     */

    public static void addMetaExtension(WikittyExtension extension, Wikitty wikitty) {
        wikitty.addMetaExtension(WikittyAuthorisationAbstract.extensionWikittyAuthorisation, extension);
}

    /**
     * hasMetaExtension :
     * true if given wikitty has WikittyAuthorisation meta-extension on given extension
     * @param extension 
     * @param wikitty 
     * @return boolean 
     */

    public static boolean hasMetaExtension(WikittyExtension extension, Wikitty wikitty) {
        return wikitty.hasMetaExtension(WikittyAuthorisation.EXT_WIKITTYAUTHORISATION, extension.getName());
}

    /**
     * getMetaFieldName :
     * for extension 'Ext' and field 'f', return 'Ext:WikittyAuthorisation.f'
     * @param extension 
     * @param fieldName 
     * @return String 
     */

    public static String getMetaFieldName(WikittyExtension extension, String fieldName) {
        String metaFieldName = getMetaFieldName(extension.getName(), fieldName); 
        return metaFieldName;
}

    /**
     * getMetaFieldName :
     * for extension 'Ext' and field 'f', return 'Ext:WikittyAuthorisation.f'
     * @param extensionName 
     * @param fieldName 
     * @return String 
     */

    public static String getMetaFieldName(String extensionName, String fieldName) {
        String metaFieldName = WikittyUtil.getMetaFieldName("WikittyAuthorisation", extensionName, fieldName);
        return metaFieldName;
}

    /**
     * getOwner :
     * @param extensionName 
     * @param wikitty 
     * @return String 
     */

    public static String getOwner(String extensionName, Wikitty wikitty) {
        String fieldName = getMetaFieldName(extensionName, "owner");
        String value = (String) wikitty.getFqField(fieldName);        
        return value;
}

    /**
     * setOwner :
     * @param extensionName 
     * @param wikitty 
     * @param owner 
     * @return String 
     */

    public static String setOwner(String extensionName, Wikitty wikitty, String owner) {
        String oldValue = getOwner(extensionName, wikitty);
        String fieldName = getMetaFieldName(extensionName, "owner");
        wikitty.setFqField(fieldName, owner);
        return oldValue;
}

    /**
     * getAdmin :
     * @param extensionName 
     * @param wikitty 
     * @return Set<String> 
     */

    public static Set<String> getAdmin(String extensionName, Wikitty wikitty) {
        String fieldName = getMetaFieldName(extensionName, "admin");
        Set<String> result = (Set<String>) wikitty.getFqField(fieldName);
        return result;
}

    /**
     * setAdmin :
     * @param extensionName 
     * @param wikitty 
     * @param admin 
     */

    public static void setAdmin(String extensionName, Wikitty wikitty, Set<String> admin) {
        clearAdmin(extensionName, wikitty);
        addAllAdmin(extensionName, wikitty, admin);
}

    /**
     * addAllAdmin :
     * @param extensionName 
     * @param wikitty 
     * @param admin 
     */

    public static void addAllAdmin(String extensionName, Wikitty wikitty, Set<String> admin) {
        if(admin != null){
            for (String id:admin){
                addAdmin(extensionName, wikitty, id);
            }
        }
}

    /**
     * addAdmin :
     * @param extensionName 
     * @param wikitty 
     * @param element 
     */

    public static void addAdmin(String extensionName, Wikitty wikitty, String element) {        
        String fieldName = getMetaFieldName(extensionName, "admin");
        wikitty.addToField(fieldName, element);
}

    /**
     * removeAdmin :
     * @param extensionName 
     * @param wikitty 
     * @param element 
     */

    public static void removeAdmin(String extensionName, Wikitty wikitty, String element) {
        String fieldName = getMetaFieldName(extensionName, "admin");
        wikitty.removeFromField(fieldName, element);
}

    /**
     * clearAdmin :
     * @param extensionName 
     * @param wikitty 
     */

    public static void clearAdmin(String extensionName, Wikitty wikitty) {
        String fieldName = getMetaFieldName(extensionName, "admin");
        wikitty.clearField(fieldName);
}

    /**
     * getWriter :
     * @param extensionName 
     * @param wikitty 
     * @return Set<String> 
     */

    public static Set<String> getWriter(String extensionName, Wikitty wikitty) {
        String fieldName = getMetaFieldName(extensionName, "writer");
        Set<String> result = (Set<String>) wikitty.getFqField(fieldName);
        return result;
}

    /**
     * setWriter :
     * @param extensionName 
     * @param wikitty 
     * @param writer 
     */

    public static void setWriter(String extensionName, Wikitty wikitty, Set<String> writer) {
        clearWriter(extensionName, wikitty);
        addAllWriter(extensionName, wikitty, writer);
}

    /**
     * addAllWriter :
     * @param extensionName 
     * @param wikitty 
     * @param writer 
     */

    public static void addAllWriter(String extensionName, Wikitty wikitty, Set<String> writer) {
        if(writer != null){
            for (String id:writer){
                addWriter(extensionName, wikitty, id);
            }
        }
}

    /**
     * addWriter :
     * @param extensionName 
     * @param wikitty 
     * @param element 
     */

    public static void addWriter(String extensionName, Wikitty wikitty, String element) {        
        String fieldName = getMetaFieldName(extensionName, "writer");
        wikitty.addToField(fieldName, element);
}

    /**
     * removeWriter :
     * @param extensionName 
     * @param wikitty 
     * @param element 
     */

    public static void removeWriter(String extensionName, Wikitty wikitty, String element) {
        String fieldName = getMetaFieldName(extensionName, "writer");
        wikitty.removeFromField(fieldName, element);
}

    /**
     * clearWriter :
     * @param extensionName 
     * @param wikitty 
     */

    public static void clearWriter(String extensionName, Wikitty wikitty) {
        String fieldName = getMetaFieldName(extensionName, "writer");
        wikitty.clearField(fieldName);
}

    /**
     * getReader :
     * @param extensionName 
     * @param wikitty 
     * @return Set<String> 
     */

    public static Set<String> getReader(String extensionName, Wikitty wikitty) {
        String fieldName = getMetaFieldName(extensionName, "reader");
        Set<String> result = (Set<String>) wikitty.getFqField(fieldName);
        return result;
}

    /**
     * setReader :
     * @param extensionName 
     * @param wikitty 
     * @param reader 
     */

    public static void setReader(String extensionName, Wikitty wikitty, Set<String> reader) {
        clearReader(extensionName, wikitty);
        addAllReader(extensionName, wikitty, reader);
}

    /**
     * addAllReader :
     * @param extensionName 
     * @param wikitty 
     * @param reader 
     */

    public static void addAllReader(String extensionName, Wikitty wikitty, Set<String> reader) {
        if(reader != null){
            for (String id:reader){
                addReader(extensionName, wikitty, id);
            }
        }
}

    /**
     * addReader :
     * @param extensionName 
     * @param wikitty 
     * @param element 
     */

    public static void addReader(String extensionName, Wikitty wikitty, String element) {        
        String fieldName = getMetaFieldName(extensionName, "reader");
        wikitty.addToField(fieldName, element);
}

    /**
     * removeReader :
     * @param extensionName 
     * @param wikitty 
     * @param element 
     */

    public static void removeReader(String extensionName, Wikitty wikitty, String element) {
        String fieldName = getMetaFieldName(extensionName, "reader");
        wikitty.removeFromField(fieldName, element);
}

    /**
     * clearReader :
     * @param extensionName 
     * @param wikitty 
     */

    public static void clearReader(String extensionName, Wikitty wikitty) {
        String fieldName = getMetaFieldName(extensionName, "reader");
        wikitty.clearField(fieldName);
}

    /**
     * getParent :
     * @param extensionName 
     * @param wikitty 
     * @return String 
     */

    public static String getParent(String extensionName, Wikitty wikitty) {
        String fieldName = getMetaFieldName(extensionName, "parent");
        String value = (String) wikitty.getFqField(fieldName);        
        return value;
}

    /**
     * setParent :
     * @param extensionName 
     * @param wikitty 
     * @param parent 
     * @return String 
     */

    public static String setParent(String extensionName, Wikitty wikitty, String parent) {
        String oldValue = getParent(extensionName, wikitty);
        String fieldName = getMetaFieldName(extensionName, "parent");
        wikitty.setFqField(fieldName, parent);
        return oldValue;
}


} //WikittyAuthorisationHelper
