/*
 * #%L
 * Wikitty :: api
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;


public  abstract class WikittyAccessStatAbstract extends BusinessEntityImpl implements WikittyAccessStat {

    public static final List<WikittyExtension> extensions;
    public static final WikittyExtension extensionWikittyAccessStat;
    /**
     * getToken :
     * @return String 
     */

    @Override
    public String getToken() {
        String value = WikittyAccessStatHelper.getToken(getWikitty());
        return value;
}

    /**
     * setToken :
     * @param token 
     */

    @Override
    public void setToken(String token) {
        String oldValue = getToken();
        WikittyAccessStatHelper.setToken(getWikitty(), token);
        getPropertyChangeSupport().firePropertyChange(WikittyAccessStat.FIELD_WIKITTYACCESSSTAT_TOKEN, oldValue, getToken());
}

    /**
     * getUser :
     * @return String 
     */

    @Override
    public String getUser() {
        String value = WikittyAccessStatHelper.getUser(getWikitty());
        return value;
}

    /**
     * setUser :
     * @param user 
     */

    @Override
    public void setUser(String user) {
        String oldValue = getUser();
        WikittyAccessStatHelper.setUser(getWikitty(), user);
        getPropertyChangeSupport().firePropertyChange(WikittyAccessStat.FIELD_WIKITTYACCESSSTAT_USER, oldValue, getUser());
}

    /**
     * getRestored :
     * @return String 
     */

    @Override
    public String getRestored() {
        String value = WikittyAccessStatHelper.getRestored(getWikitty());
        return value;
}

    /**
     * setRestored :
     * @param restored 
     */

    @Override
    public void setRestored(String restored) {
        String oldValue = getRestored();
        WikittyAccessStatHelper.setRestored(getWikitty(), restored);
        getPropertyChangeSupport().firePropertyChange(WikittyAccessStat.FIELD_WIKITTYACCESSSTAT_RESTORED, oldValue, getRestored());
}

    /**
     * getDate :
     * @return Date 
     */

    @Override
    public Date getDate() {
        Date value = WikittyAccessStatHelper.getDate(getWikitty());
        return value;
}

    /**
     * setDate :
     * @param date 
     */

    @Override
    public void setDate(Date date) {
        Date oldValue = getDate();
        WikittyAccessStatHelper.setDate(getWikitty(), date);
        getPropertyChangeSupport().firePropertyChange(WikittyAccessStat.FIELD_WIKITTYACCESSSTAT_DATE, oldValue, getDate());
}

    /**
     * WikittyAccessStatAbstract :
     */

    public WikittyAccessStatAbstract() {
        super();
}

    /**
     * WikittyAccessStatAbstract :
     * @param wikitty 
     */

    public WikittyAccessStatAbstract(Wikitty wikitty) {
        super(wikitty);
}

    /**
     * WikittyAccessStatAbstract :
     * @param businessEntityImpl 
     */

    public WikittyAccessStatAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    /**
     * getStaticExtensions :
     * @return Collection<WikittyExtension> 
     */

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

static {
    
        extensionWikittyAccessStat =
                new WikittyExtension(EXT_WIKITTYACCESSSTAT,
                                     "1.0", // version
                                     null,
                                     WikittyUtil.buildFieldMapExtension( // building field map
                                             "Wikitty token unique=\"true\"", 
                                             "Wikitty user unique=\"true\"", 
                                             "Wikitty restored unique=\"true\"", 
                                             "Date date unique=\"true\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.add(extensionWikittyAccessStat);
        extensions = Collections.unmodifiableList(exts);

    }
    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return getWikitty().toString();
}


} //WikittyAccessStatAbstract
