package org.nuiton.wikitty.search;

import java.io.Serializable;

/**
 * Equals operator is used to build restriction containing "element == value"
 * where element could be an Id, a String, a multimedia, a closed list, an
 * Integer, a Float or a Date. <br>
 * <br>
 * For example, use: RestrictionHelper.eq( myElement , "REF1234567890" )
 */
public class Equals extends BinaryOperator implements Serializable {

    // serialVersionUID is used for serialization.
    private static final long serialVersionUID = 1L;

    /**
     * Default constructor
     */
    public Equals() {
        super();
    }

    /**
     * Equality test based attributes values
     * 
     * @param value
     *            Value to compare
     */
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Equals)) {
            return false;
        }

        final Equals equals = (Equals) other;

        return super.equals(equals);
    }

    public int hashCode() {
        int result = Equals.class.getName().hashCode();
        result = 29 * result + super.hashCode();
        return result;
    }

}