/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.templates;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.plexus.component.annotations.Component;
import org.nuiton.eugene.EugeneCoreTagValues;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.Template;
import org.nuiton.eugene.java.JavaGeneratorUtil;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.extension.tagvalue.TagValueMetadata;
import org.nuiton.eugene.models.extension.tagvalue.TagValueUtil;
import org.nuiton.eugene.models.extension.tagvalue.WithTagValuesOrStereotypes;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAssociationClass;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelJavaModifier;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelPackage;
import org.nuiton.eugene.models.object.ObjectModelParameter;
import org.nuiton.eugene.models.object.xml.ObjectModelInterfaceImpl;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaDaoSupplier;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityContextable;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.event.ListenableTopiaEntity;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;
import org.nuiton.topia.templates.TopiaCoreTagValues;
import org.nuiton.topia.templates.TopiaHibernateTagValues;
import org.nuiton.topia.templates.TopiaTemplateHelper;

@Component(role=Template.class, hint="org.nuiton.topia.templates.EntityTransformer")
public class EntityTransformer
extends ObjectModelTransformerToJava {
    private static final Log log = LogFactory.getLog(EntityTransformer.class);
    protected ObjectModelInterface outputInterface;
    protected ObjectModelClass outputAbstract;
    protected ObjectModelClass outputImpl;
    private boolean associationClass;
    protected boolean generateInterface;
    protected boolean generateAbstract;
    protected boolean generateImpl;
    protected boolean generateBooleanGetMethods;
    protected boolean generatePropertyChangeSupport;
    protected TopiaTemplateHelper templateHelper;
    protected final TopiaCoreTagValues topiaCoreTagValues = new TopiaCoreTagValues();
    protected final TopiaHibernateTagValues topiaHibernateTagValues = new TopiaHibernateTagValues();
    private ObjectModelOperation internalAcceptOperation;
    private StringBuilder internalAcceptOperationBody;

    protected void clean() {
        this.outputInterface = null;
        this.outputAbstract = null;
        this.outputImpl = null;
    }

    public void transformFromClass(ObjectModelClass input) {
        String i18nPrefix;
        if (this.templateHelper == null) {
            this.templateHelper = new TopiaTemplateHelper((ObjectModel)this.model);
        }
        if (!this.templateHelper.isEntity((ObjectModelClassifier)input)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("for entity : " + input.getQualifiedName()));
            log.debug((Object)("Will use classLoader " + this.getClassLoader()));
        }
        ObjectModelPackage aPackage = this.getPackage((ObjectModelClassifier)input);
        String prefix = this.getConstantPrefix((ObjectModelClassifier)input);
        if (StringUtils.isEmpty((CharSequence)prefix) && log.isWarnEnabled()) {
            log.warn((Object)("[" + input.getName() + "] Will generate constants with NO prefix, not a good idea... \nUse '" + EugeneCoreTagValues.Store.constantPrefix + "' tagvalue in your xmi properties. For example for all the model : model.tagvalue." + EugeneCoreTagValues.Store.constantPrefix + "=PROPERTY_"));
        }
        this.setConstantPrefix(prefix);
        this.generateInterface = this.isGenerateInterface(input);
        this.generateAbstract = this.isGenerateAbstract(input);
        this.generateImpl = this.isGenerateImpl(input);
        this.generateBooleanGetMethods = this.eugeneTagValues.isGenerateBooleanGetMethods((ObjectModelClassifier)input, aPackage, (ObjectModel)this.model);
        this.generatePropertyChangeSupport = this.topiaCoreTagValues.isGeneratePropertyChangeSupport(input, (ObjectModel)this.model);
        if (this.generateInterface) {
            this.createEntityInterface(aPackage, input);
        } else {
            this.outputInterface = new ObjectModelInterfaceImpl();
            ((ObjectModelInterfaceImpl)this.outputInterface).setName(input.getName());
        }
        if (this.generateAbstract) {
            this.createEntityAbstractClass(aPackage, input);
        }
        if (!StringUtils.isEmpty((CharSequence)(i18nPrefix = this.eugeneTagValues.getI18nPrefixTagValue((ObjectModelElement)input, aPackage, (ObjectModel)this.model)))) {
            this.generateI18nBlock((ObjectModelClassifier)input, (ObjectModelClassifier)this.outputAbstract, i18nPrefix);
        }
        this.createAcceptOperation();
        this.createAcceptInternalOperation(input);
        this.generateProperties(input.getAttributes(), (ObjectModelClassifier)input, aPackage);
        if (input instanceof ObjectModelAssociationClass) {
            ObjectModelAssociationClass association = (ObjectModelAssociationClass)input;
            this.associationClass = true;
            this.generateProperties(association.getParticipantsAttributes(), (ObjectModelClassifier)input, aPackage);
            this.associationClass = false;
        }
        this.closeAcceptInternalOperation();
        this.generateExtraConstants(input);
        this.generateExtraOperations(input);
        if (!this.topiaCoreTagValues.getNotGenerateToStringTagValue((ObjectModelClassifier)input, aPackage, (ObjectModel)this.model)) {
            this.generateToStringOperation(input);
        }
        this.generateSerialVersionUID(input, this.outputAbstract);
        if (this.generateImpl) {
            this.generateImpl(input);
            this.generateSerialVersionUID(input, this.outputImpl);
        }
        this.clean();
    }

    protected void generateSerialVersionUID(ObjectModelClass input, ObjectModelClass ouput) {
        Object svUID = TagValueUtil.findTagValue((TagValueMetadata)TopiaCoreTagValues.Store.serialVersionUID, (WithTagValuesOrStereotypes[])new WithTagValuesOrStereotypes[]{input});
        if (svUID == null) {
            svUID = GeneratorUtil.generateSerialVersionUID((ObjectModelClassifier)ouput) + "L";
        }
        this.addConstant((ObjectModelClassifier)ouput, "serialVersionUID", Long.TYPE, (String)svUID, (ObjectModelModifier)ObjectModelJavaModifier.PRIVATE);
    }

    protected void createEntityInterface(ObjectModelPackage aPackage, ObjectModelClass input) {
        this.outputInterface = this.createInterface(input.getName(), input.getPackageName());
        if (GeneratorUtil.hasDocumentation((ObjectModelElement)input)) {
            this.setDocumentation((ObjectModelElement)this.outputInterface, input.getDocumentation());
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Will add interfaces on " + this.outputInterface.getQualifiedName()));
        }
        LinkedList<String> interfaceAlreadyDone = new LinkedList<String>();
        for (Object parent : input.getInterfaces()) {
            this.addInterface(interfaceAlreadyDone, (ObjectModelClassifier)this.outputInterface, (ObjectModelClassifier)parent);
        }
        boolean needTopiaEntity = true;
        for (ObjectModelClassifier parent : input.getSuperclasses()) {
            if (!this.templateHelper.isEntity(parent)) continue;
            this.addInterface(interfaceAlreadyDone, (ObjectModelClassifier)this.outputInterface, parent);
            needTopiaEntity = false;
        }
        if (needTopiaEntity) {
            Class<TopiaEntity> interfaze = TopiaEntity.class;
            if (this.topiaCoreTagValues.getContextableTagValue((ObjectModelClassifier)input, aPackage, (ObjectModel)this.model)) {
                interfaze = TopiaEntityContextable.class;
            }
            this.addInterface(interfaceAlreadyDone, (ObjectModelClassifier)this.outputInterface, interfaze);
        } else if (this.topiaCoreTagValues.getContextableTagValue((ObjectModelClassifier)input, aPackage, (ObjectModel)this.model)) {
            this.addInterface(interfaceAlreadyDone, (ObjectModelClassifier)this.outputInterface, TopiaEntityContextable.class);
        }
        if (this.generatePropertyChangeSupport) {
            this.addInterface(interfaceAlreadyDone, (ObjectModelClassifier)this.outputInterface, ListenableTopiaEntity.class);
        }
    }

    protected void createEntityAbstractClass(ObjectModelPackage aPackage, ObjectModelClass input) {
        this.outputAbstract = this.createAbstractClass(input.getName() + "Abstract", input.getPackageName());
        StringBuilder doc = new StringBuilder();
        doc.append("Implantation POJO pour l'entit\u00e9 {@link ");
        doc.append(StringUtils.capitalize((String)this.outputInterface.getName()));
        doc.append("}\n");
        String dbName = this.templateHelper.getDbName((ObjectModelElement)input);
        if (dbName != null) {
            doc.append("<p>Nom de l'entit\u00e9 en BD : ");
            doc.append(dbName);
            doc.append(".</p>");
        }
        this.setDocumentation((ObjectModelElement)this.outputAbstract, doc.toString());
        this.addInterface((ObjectModelClassifier)this.outputAbstract, this.outputInterface.getName());
        for (ObjectModelClass parent : input.getSuperclasses()) {
            String extendClass = this.templateHelper.getDOType((ObjectModelElement)parent, (ObjectModel)this.model);
            this.setSuperClass(this.outputAbstract, extendClass);
        }
        if (this.outputAbstract.getSuperclasses().isEmpty()) {
            String superClassName = this.topiaCoreTagValues.getEntitySuperClassTagValue((ObjectModelClassifier)input, aPackage, (ObjectModel)this.model);
            if (superClassName == null) {
                superClassName = AbstractTopiaEntity.class.getName();
            }
            this.setSuperClass(this.outputAbstract, superClassName);
        }
        if (this.topiaCoreTagValues.getContextableTagValue((ObjectModelClassifier)input, aPackage, (ObjectModel)this.model)) {
            this.addContextableMethods(input, this.outputAbstract);
        }
    }

    protected void addContextableMethods(ObjectModelClass input, ObjectModelClass outputAbstract) {
        this.addImport((ObjectModelClassifier)outputAbstract, TopiaDaoSupplier.class);
        this.addImport((ObjectModelClassifier)outputAbstract, TopiaDao.class);
        ObjectModelAttribute topiaContextAttribute = this.addAttribute((ObjectModelClassifier)outputAbstract, "topiaDaoSupplier", TopiaDaoSupplier.class, null, new ObjectModelModifier[]{ObjectModelJavaModifier.PROTECTED, ObjectModelJavaModifier.TRANSIENT});
        this.setDocumentation((ObjectModelElement)topiaContextAttribute, "TopiaDAO instance associated with the current \ninstance. For internal usage only");
        ObjectModelOperation op = this.addOperation((ObjectModelClassifier)outputAbstract, "getTopiaDaoSupplier", TopiaDaoSupplier.class, new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.setDocumentation((ObjectModelElement)op, "@since 3.0");
        this.addAnnotation((ObjectModelClassifier)outputAbstract, (ObjectModelElement)op, Override.class);
        this.setOperationBody(op, "\n        return topiaDaoSupplier;\n    ");
        op = this.addOperation((ObjectModelClassifier)outputAbstract, "setTopiaDaoSupplier", "void", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addException(op, TopiaException.class);
        this.addParameter(op, TopiaDaoSupplier.class, "topiaDaoSupplier");
        this.setDocumentation((ObjectModelElement)op, "@since 3.0");
        this.addAnnotation((ObjectModelClassifier)outputAbstract, (ObjectModelElement)op, Override.class);
        this.setOperationBody(op, "\n        if (this.topiaDaoSupplier == null) {\n            this.topiaDaoSupplier = topiaDaoSupplier;\n        }\n    ");
        String daoClassName = this.templateHelper.getConcreteDaoName(input);
        op = this.addOperation((ObjectModelClassifier)outputAbstract, "getInternalDao", daoClassName, new ObjectModelModifier[]{ObjectModelJavaModifier.PROTECTED});
        this.setDocumentation((ObjectModelElement)op, "@since 3.0");
        this.setOperationBody(op, "\n        TopiaDaoSupplier daoSupplier = getTopiaDaoSupplier();\n        " + daoClassName + " result = null;\n        if (daoSupplier != null) { // This may happend when entity is created manually\n            result = daoSupplier.getDao(" + input.getName() + ".class, " + daoClassName + ".class);\n        }\n        return result;\n    ");
        op = this.addOperation((ObjectModelClassifier)outputAbstract, "getGenericEntityDao", "TopiaDao<?>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)outputAbstract, (ObjectModelElement)op, Override.class);
        this.setDocumentation((ObjectModelElement)op, "@since 3.0");
        this.setOperationBody(op, "\n        return getInternalDao();\n    ");
        op = this.addOperation((ObjectModelClassifier)outputAbstract, "update", "void", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addException(op, TopiaException.class);
        this.addAnnotation((ObjectModelClassifier)outputAbstract, (ObjectModelElement)op, Override.class);
        this.setOperationBody(op, "\n        getInternalDao().update(this);\n    ");
        op = this.addOperation((ObjectModelClassifier)outputAbstract, "delete", "void", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addException(op, TopiaException.class);
        this.addAnnotation((ObjectModelClassifier)outputAbstract, (ObjectModelElement)op, Override.class);
        this.setOperationBody(op, "\n        getInternalDao().delete(this);\n    ");
        op = this.addOperation((ObjectModelClassifier)outputAbstract, "getComposite", List.class.getName() + "<" + TopiaEntity.class.getName() + ">", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addException(op, TopiaException.class);
        this.addAnnotation((ObjectModelClassifier)outputAbstract, (ObjectModelElement)op, Override.class);
        this.setOperationBody(op, "\n        List<TopiaEntity> result = getInternalDao().getComposite(this);\n        return result;\n    ");
        op = this.addOperation((ObjectModelClassifier)outputAbstract, "getAggregate", List.class.getName() + "<" + TopiaEntity.class.getName() + ">", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addException(op, TopiaException.class);
        this.addAnnotation((ObjectModelClassifier)outputAbstract, (ObjectModelElement)op, Override.class);
        this.setOperationBody(op, "\n        List<TopiaEntity> result = getInternalDao().getAggregate(this);\n        return result;\n    ");
    }

    protected boolean isGenerateInterface(ObjectModelClass input) {
        return !this.getResourcesHelper().isJavaFileInClassPath(input.getQualifiedName());
    }

    protected boolean isGenerateAbstract(ObjectModelClass input) {
        String fqn = input.getQualifiedName() + " Abstract";
        return !this.getResourcesHelper().isJavaFileInClassPath(fqn);
    }

    protected boolean isGenerateImpl(ObjectModelClass input) {
        Collection operations = input.getOperations();
        String fqn = input.getQualifiedName() + "Impl";
        boolean alreadyInClassPath = this.getResourcesHelper().isJavaFileInClassPath(fqn);
        if (alreadyInClassPath) {
            return false;
        }
        if (!operations.isEmpty()) {
            log.info((Object)("Will not generate [" + fqn + "], there is some operations to manually implement"));
            return false;
        }
        for (ObjectModelOperation otherOp : input.getAllOtherOperations(false)) {
            if (!otherOp.isAbstract()) continue;
            log.info((Object)("Will not generate [" + fqn + "], there is an abstract operation [" + otherOp.getName() + "] in allOtherOperations."));
            return false;
        }
        return true;
    }

    protected void generateImpl(ObjectModelClass input) {
        String implName = input.getName() + "Impl";
        String packageName = input.getPackageName();
        if (this.isVerbose()) {
            log.info((Object)("Will generate [" + implName + "]"));
        }
        this.outputImpl = this.isAbstract(input) ? this.createAbstractClass(implName, packageName) : this.createClass(implName, packageName);
        this.setDocumentation((ObjectModelElement)this.outputImpl, "Implantation des operations pour l'entit\u00e9 " + input.getName() + ".");
        this.setSuperClass(this.outputImpl, input.getQualifiedName() + "Abstract");
    }

    protected void generateExtraConstants(ObjectModelClass input) {
        Set constants = this.addConstantsFromDependency((ObjectModelClassifier)input, (ObjectModelClassifier)this.outputInterface);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Add constants from dependency : " + constants));
        }
    }

    protected void generateExtraOperations(ObjectModelClass input) {
        for (ObjectModelOperation operation : input.getOperations()) {
            String opName = operation.getName();
            String opType = operation.getReturnType();
            ObjectModelJavaModifier visibility = ObjectModelJavaModifier.fromVisibility((String)operation.getVisibility());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Extra operation for : " + input.getQualifiedName() + " - method : " + opName + " - returnType : " + opType + " - visibility : " + (ObjectModelModifier)visibility));
            }
            if (!visibility.equals(ObjectModelJavaModifier.PUBLIC)) {
                this.addOperation((ObjectModelClassifier)this.outputAbstract, opName, opType, new ObjectModelModifier[]{visibility, ObjectModelJavaModifier.ABSTRACT});
                continue;
            }
            this.cloneOperationSignature(operation, (ObjectModelClassifier)this.outputInterface, true, new ObjectModelModifier[0]);
        }
    }

    protected void generateProperties(Collection<ObjectModelAttribute> attributes, ObjectModelClassifier aClass, ObjectModelPackage aPackage) {
        for (ObjectModelAttribute attribute : attributes) {
            if (!this.associationClass) {
                if (!attribute.isNavigable() && attribute.hasAssociationClass()) {
                    this.generatePropertyConstant(attribute);
                    this.generatePropertyAttribute(attribute, aClass, aPackage);
                    this.updateAcceptOperation(attribute, aClass, aPackage);
                }
                if (!attribute.isNavigable() && !this.templateHelper.hasUnidirectionalRelationOnAbstractType(attribute.getReverseAttribute(), (ObjectModel)this.model)) continue;
            }
            this.generatePropertyConstant(attribute);
            this.generatePropertyAttribute(attribute, aClass, aPackage);
            this.generatePropertyOperations(attribute, aClass, aPackage);
            this.updateAcceptOperation(attribute, aClass, aPackage);
        }
    }

    protected void generatePropertyConstant(ObjectModelAttribute attribute) {
        String attrName = this.getPropertyName(attribute);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generate constant for property : " + attrName));
        }
        this.addAttribute((ObjectModelClassifier)this.outputInterface, this.getConstantName(attrName), String.class, "\"" + attrName + "\"", new ObjectModelModifier[0]);
    }

    protected void generatePropertyAttribute(ObjectModelAttribute attribute, ObjectModelClassifier aClass, ObjectModelPackage aPackage) {
        String dbName;
        String attrName = this.getPropertyName(attribute);
        Object attrType = this.getPropertyType(attribute, aClass, aPackage);
        String collectionType = this.getCollectionType(attribute);
        if (collectionType != null) {
            attrType = collectionType + "<" + (String)attrType + ">";
        }
        ObjectModelAttribute property = this.addAttribute((ObjectModelClassifier)this.outputAbstract, attrName, (String)attrType, null, new ObjectModelModifier[]{ObjectModelJavaModifier.PROTECTED});
        StringBuilder buffer = new StringBuilder();
        if (GeneratorUtil.hasDocumentation((ObjectModelElement)attribute)) {
            String attrDocumentation = attribute.getDocumentation();
            buffer.append(attrDocumentation).append('\n');
        }
        if (!StringUtils.isEmpty((CharSequence)(dbName = this.templateHelper.getDbName((ObjectModelElement)attribute)))) {
            buffer.append("Nom de l'attribut en BD : ").append(dbName).append('\n');
        }
        this.setDocumentation((ObjectModelElement)property, buffer.toString());
        String annotation = new TopiaCoreTagValues().getAnnotationTagValue(attribute);
        if (!StringUtils.isEmpty((CharSequence)annotation)) {
            this.addAnnotation((ObjectModelClassifier)this.outputAbstract, (ObjectModelElement)property, annotation);
        }
    }

    protected void generatePropertyOperations(ObjectModelAttribute attribute, ObjectModelClassifier aClass, ObjectModelPackage aPackage) {
        if (attribute.getMaxMultiplicity() == 1 || this.associationClass) {
            this.addSingleSetOperation(attribute, aClass, aPackage);
            boolean booleanProperty = GeneratorUtil.isBooleanPrimitive((ObjectModelAttribute)attribute);
            String attrType = this.getPropertyType(attribute, aClass, aPackage);
            if (booleanProperty) {
                this.addSingleGetOperation(attribute, attrType, "is");
            }
            if (!booleanProperty || this.generateBooleanGetMethods) {
                this.addSingleGetOperation(attribute, attrType, "get");
            }
        } else {
            String collectionInterface = this.templateHelper.getCollectionType(attribute).getName();
            String collectionImpl = this.templateHelper.getCollectionInstanceType(attribute).getName();
            this.addImport((ObjectModelClassifier)this.outputInterface, collectionInterface);
            this.addImport((ObjectModelClassifier)this.outputAbstract, collectionInterface);
            this.addImport((ObjectModelClassifier)this.outputAbstract, collectionImpl);
            collectionInterface = GeneratorUtil.getSimpleName((String)collectionInterface);
            collectionImpl = GeneratorUtil.getSimpleName((String)collectionImpl);
            boolean ordered = JavaGeneratorUtil.isOrdered((ObjectModelAttribute)attribute);
            boolean unique = EugeneCoreTagValues.isUnique((ObjectModelAttribute)attribute);
            boolean entity = this.templateHelper.isEntity(attribute, (ObjectModel)this.model);
            this.addMultipleAddOperation(attribute, aClass, aPackage, collectionImpl);
            if (ordered && !unique) {
                this.addMultipleAddAtIndexOperation(attribute, aClass, aPackage, collectionImpl);
            }
            this.addMultipleAddAllOperation(attribute, aClass, aPackage);
            this.addMultipleSetOperation(attribute, aClass, aPackage, collectionInterface, collectionImpl);
            this.addMultipleRemoveOperation(attribute, aClass, aPackage);
            if (ordered && !unique) {
                this.addMultipleRemoveAtIndexOperation(attribute, aClass, aPackage);
            }
            this.addMultipleClearOperation(attribute, aClass, aPackage, collectionInterface, collectionImpl);
            this.addMultipleGetOperation(attribute, aClass, aPackage, collectionInterface);
            if (ordered) {
                this.addMultipleGetByIndexOperation(attribute, aClass, aPackage);
            }
            if (entity) {
                this.addMultipleGetByTopiaIdOperation(attribute, aClass, aPackage);
                this.addMultipleGetTopiaIdsOperation(attribute, aClass, aPackage, collectionInterface, collectionImpl);
            }
            this.addMultipleSizeOperation(attribute);
            this.addMultipleIsEmptyOperations(attribute);
            this.addMultipleContainsOperation(attribute, aClass, aPackage);
        }
    }

    protected void addSingleSetOperation(ObjectModelAttribute attribute, ObjectModelClassifier aClass, ObjectModelPackage aPackage) {
        String attrName = this.getPropertyName(attribute);
        String attrType = this.getPropertyType(attribute, aClass, aPackage);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generate single 'set' operation for property : " + attrName + " [" + attrType + "]"));
        }
        ObjectModelOperation interfaceOperation = this.createPropertySetterSignature((ObjectModelClassifier)this.outputInterface, attrType, attrName, "");
        ObjectModelOperation implOperation = this.createImplOperation(interfaceOperation);
        attrType = GeneratorUtil.getSimpleName((String)attrType);
        String constantName = this.getConstantName(attrName);
        StringBuilder body = new StringBuilder();
        if (this.generatePropertyChangeSupport) {
            body.append("\n        " + attrType + " oldValue = this." + attrName + ";\n        fireOnPreWrite(" + constantName + ", oldValue, " + attrName + ");");
        }
        body.append("\n        this." + attrName + " = " + attrName + ";\n    ");
        if (this.generatePropertyChangeSupport) {
            body.append("    fireOnPostWrite(" + constantName + ", oldValue, " + attrName + ");\n    ");
        }
        this.setOperationBody(implOperation, body.toString());
    }

    protected void addSingleGetOperation(ObjectModelAttribute attribute, String attrType, String operationPrefix) {
        String attrName = this.getPropertyName(attribute);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generate single '" + operationPrefix + "' operation for property : " + attrName + " [" + attrType + "]"));
        }
        String constantName = this.getConstantName(attrName);
        ObjectModelOperation interfaceOperation = this.addOperation((ObjectModelClassifier)this.outputInterface, this.getJavaBeanMethodName(operationPrefix, attrName), attrType, new ObjectModelModifier[]{ObjectModelJavaModifier.PACKAGE});
        ObjectModelOperation implOperation = this.createImplOperation(interfaceOperation);
        attrType = GeneratorUtil.getSimpleName((String)attrType);
        StringBuilder body = new StringBuilder();
        if (this.generatePropertyChangeSupport) {
            body.append("\n        fireOnPreRead(" + constantName + ", " + attrName + ");");
        }
        body.append("\n        " + attrType + " result = this." + attrName + ";\n");
        if (this.generatePropertyChangeSupport) {
            body.append("        fireOnPostRead(" + constantName + ", " + attrName + ");\n");
        }
        body.append("        return result;\n    ");
        this.setOperationBody(implOperation, body.toString());
    }

    protected void addMultipleAddOperation(ObjectModelAttribute attribute, ObjectModelClassifier aClass, ObjectModelPackage aPackage, String collectionImpl) {
        String attrName = this.getPropertyName(attribute);
        String attrType = this.getPropertyType(attribute, aClass, aPackage);
        ObjectModelAttribute reverse = attribute.getReverseAttribute();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generate multiple 'add' operation for property : " + attrName + " [" + attrType + "]"));
        }
        String constantName = this.getConstantName(attrName);
        ObjectModelOperation interfaceOperation = this.addOperation((ObjectModelClassifier)this.outputInterface, this.getJavaBeanMethodName("add", attrName), Void.TYPE, new ObjectModelModifier[]{ObjectModelJavaModifier.PACKAGE});
        ObjectModelParameter param = this.addParameter(interfaceOperation, attrType, attrName);
        ObjectModelOperation implOperation = this.createImplOperation(interfaceOperation);
        attrType = GeneratorUtil.getSimpleName((String)attrType);
        StringBuilder body = new StringBuilder();
        if (this.generatePropertyChangeSupport) {
            body.append("\n        fireOnPreWrite(" + constantName + ", null, " + attrName + ");");
        }
        body.append("\n        if (this." + attrName + " == null) {\n            this." + attrName + " = new " + collectionImpl + "<" + attrType + ">();\n        }\n");
        if (reverse != null && (reverse.isNavigable() || this.templateHelper.hasUnidirectionalRelationOnAbstractType(attribute, (ObjectModel)this.model))) {
            String getterName = this.getJavaBeanMethodName("get", reverse.getName());
            String setterName = this.getJavaBeanMethodName("set", reverse.getName());
            String reverseAttrType = JavaGeneratorUtil.getAttributeImplementationType((ObjectModelParameter)reverse, (boolean)true);
            if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)reverse)) {
                body.append("        " + attrName + "." + setterName + "(this);\n");
            } else if (!attribute.hasAssociationClass()) {
                body.append("        if (" + attrName + "." + getterName + "() == null) {\n            " + attrName + "." + setterName + "(new " + reverseAttrType + "());\n        }\n        " + attrName + "." + getterName + "().add(this);\n");
            }
        }
        body.append("        this." + attrName + ".add(" + attrName + ");\n    ");
        if (this.generatePropertyChangeSupport) {
            body.append("    fireOnPostWrite(" + constantName + ", this." + attrName + ".size(), null, " + attrName + ");\n    ");
        }
        this.setOperationBody(implOperation, body.toString());
    }

    protected void addMultipleAddAtIndexOperation(ObjectModelAttribute attribute, ObjectModelClassifier aClass, ObjectModelPackage aPackage, String collectionImpl) {
        String attrName = this.getPropertyName(attribute);
        String attrType = this.getPropertyType(attribute, aClass, aPackage);
        ObjectModelAttribute reverse = attribute.getReverseAttribute();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generate multiple 'add' operation for property : " + attrName + " [" + attrType + "]"));
        }
        String constantName = this.getConstantName(attrName);
        ObjectModelOperation interfaceOperation = this.addOperation((ObjectModelClassifier)this.outputInterface, this.getJavaBeanMethodName("add", attrName), Void.TYPE, new ObjectModelModifier[]{ObjectModelJavaModifier.PACKAGE});
        this.addParameter(interfaceOperation, Integer.TYPE, "index");
        ObjectModelParameter param = this.addParameter(interfaceOperation, attrType, attrName);
        ObjectModelOperation implOperation = this.createImplOperation(interfaceOperation);
        attrType = GeneratorUtil.getSimpleName((String)attrType);
        StringBuilder body = new StringBuilder();
        if (this.generatePropertyChangeSupport) {
            body.append("\n        fireOnPreWrite(" + constantName + ", null, " + attrName + ");");
        }
        body.append("\n        if (this." + attrName + " == null) {\n            this." + attrName + " = new " + collectionImpl + "<" + attrType + ">();\n        }\n");
        if (reverse != null && (reverse.isNavigable() || this.templateHelper.hasUnidirectionalRelationOnAbstractType(attribute, (ObjectModel)this.model))) {
            String getterName = this.getJavaBeanMethodName("get", reverse.getName());
            String setterName = this.getJavaBeanMethodName("set", reverse.getName());
            String reverseAttrType = JavaGeneratorUtil.getAttributeImplementationType((ObjectModelParameter)reverse, (boolean)true);
            if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)reverse)) {
                body.append("        " + attrName + "." + setterName + "(this);\n");
            } else if (!attribute.hasAssociationClass()) {
                body.append("        if (" + attrName + "." + getterName + "() == null) {\n            " + attrName + "." + setterName + "(new " + reverseAttrType + "());\n        }\n        " + attrName + "." + getterName + "().add(index, this);\n");
            }
        }
        body.append("        this." + attrName + ".add(index, " + attrName + ");\n    ");
        if (this.generatePropertyChangeSupport) {
            body.append("    fireOnPostWrite(" + constantName + ", index, null, " + attrName + ");\n    ");
        }
        this.setOperationBody(implOperation, body.toString());
    }

    protected void addMultipleAddAllOperation(ObjectModelAttribute attribute, ObjectModelClassifier aClass, ObjectModelPackage aPackage) {
        String attrName = this.getPropertyName(attribute);
        String attrType = this.getPropertyType(attribute, aClass, aPackage);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generate multiple 'addAll' operation for property : " + attrName + " [" + attrType + "]"));
        }
        ObjectModelOperation interfaceOperation = this.addOperation((ObjectModelClassifier)this.outputInterface, this.getJavaBeanMethodName("addAll", attrName), Void.TYPE, new ObjectModelModifier[]{ObjectModelJavaModifier.PACKAGE});
        ObjectModelParameter param = this.addParameter(interfaceOperation, "Iterable<" + attrType + ">", attrName);
        ObjectModelOperation implOperation = this.createImplOperation(interfaceOperation);
        attrType = GeneratorUtil.getSimpleName((String)attrType);
        String addMethodName = this.getJavaBeanMethodName("add", attrName);
        this.setOperationBody(implOperation, "\n        if (" + attrName + " == null) {\n            return;\n        }\n        for (" + attrType + " item : " + attrName + ") {\n            " + addMethodName + "(item);\n        }\n    ");
    }

    protected void addMultipleSetOperation(ObjectModelAttribute attribute, ObjectModelClassifier aClass, ObjectModelPackage aPackage, String collectionInterface, String collectionImpl) {
        String attrName = this.getPropertyName(attribute);
        String referenceType = this.getPropertyType(attribute, aClass, aPackage);
        Object attrType = collectionInterface + "<" + referenceType + ">";
        String constantName = this.getConstantName(attrName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generate multiple 'set' operation for property : " + attrName + " [" + (String)attrType + "]"));
        }
        ObjectModelOperation interfaceOperation = this.createPropertySetterSignature((ObjectModelClassifier)this.outputInterface, (String)attrType, attrName, "");
        ObjectModelOperation implOperation = this.createImplOperation(interfaceOperation);
        attrType = GeneratorUtil.getSimpleName((String)attrType);
        referenceType = GeneratorUtil.getSimpleName((String)referenceType);
        StringBuilder body = new StringBuilder();
        if (this.generatePropertyChangeSupport) {
            body.append("\n        // Copy elements to keep data for fire with new reference\n        " + (String)attrType + " oldValue = this." + attrName + " != null ? new " + collectionImpl + "<" + referenceType + ">(this." + attrName + ") : null;\n        fireOnPreWrite(" + constantName + ", oldValue, " + attrName + ");");
        }
        body.append("\n        this." + attrName + " = " + attrName + ";\n    ");
        if (this.generatePropertyChangeSupport) {
            body.append("    fireOnPostWrite(" + constantName + ", oldValue, " + attrName + ");\n    ");
        }
        this.setOperationBody(implOperation, body.toString());
    }

    protected void addMultipleRemoveOperation(ObjectModelAttribute attribute, ObjectModelClassifier aClass, ObjectModelPackage aPackage) {
        String attrName = this.getPropertyName(attribute);
        String attrType = this.getPropertyType(attribute, aClass, aPackage);
        ObjectModelAttribute reverse = attribute.getReverseAttribute();
        String constantName = this.getConstantName(attrName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generate 'remove' operation for property : " + attrName + " [" + attrType + "]"));
        }
        ObjectModelOperation interfaceOperation = this.addOperation((ObjectModelClassifier)this.outputInterface, this.getJavaBeanMethodName("remove", attrName), Void.TYPE, new ObjectModelModifier[]{ObjectModelJavaModifier.PACKAGE});
        ObjectModelParameter param = this.addParameter(interfaceOperation, attrType, attrName);
        ObjectModelOperation implOperation = this.createImplOperation(interfaceOperation);
        attrType = GeneratorUtil.getSimpleName((String)attrType);
        StringBuilder body = new StringBuilder();
        if (this.generatePropertyChangeSupport) {
            body.append("\n        fireOnPreWrite(" + constantName + ", " + attrName + ", null);");
        }
        body.append("\n        if (this." + attrName + " == null || !this." + attrName + ".remove(" + attrName + ")) {\n            throw new IllegalArgumentException(\"List does not contain given element\");\n        }\n    ");
        if (reverse != null && (reverse.isNavigable() || this.templateHelper.hasUnidirectionalRelationOnAbstractType(attribute, (ObjectModel)this.model))) {
            String getterName = this.getJavaBeanMethodName("get", reverse.getName());
            String setterName = this.getJavaBeanMethodName("set", reverse.getName());
            if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)reverse)) {
                body.append("    " + attrName + "." + setterName + "(null);\n    ");
            } else if (!attribute.hasAssociationClass()) {
                body.append("    " + attrName + "." + getterName + "().remove(this);\n    ");
            }
        }
        if (this.generatePropertyChangeSupport) {
            body.append("    fireOnPostWrite(" + constantName + ", this." + attrName + ".size() + 1, " + attrName + ", null);\n    ");
        }
        this.setOperationBody(implOperation, body.toString());
    }

    protected void addMultipleRemoveAtIndexOperation(ObjectModelAttribute attribute, ObjectModelClassifier aClass, ObjectModelPackage aPackage) {
        String attrName = this.getPropertyName(attribute);
        String attrType = this.getPropertyType(attribute, aClass, aPackage);
        ObjectModelAttribute reverse = attribute.getReverseAttribute();
        String constantName = this.getConstantName(attrName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generate 'remove' operation for property : " + attrName + " [" + attrType + "]"));
        }
        ObjectModelOperation interfaceOperation = this.addOperation((ObjectModelClassifier)this.outputInterface, this.getJavaBeanMethodName("remove", attrName), Void.TYPE, new ObjectModelModifier[]{ObjectModelJavaModifier.PACKAGE});
        this.addParameter(interfaceOperation, Integer.TYPE, "index");
        ObjectModelOperation implOperation = this.createImplOperation(interfaceOperation);
        attrType = GeneratorUtil.getSimpleName((String)attrType);
        StringBuilder body = new StringBuilder();
        if (this.generatePropertyChangeSupport) {
            body.append("\n        fireOnPreWrite(" + constantName + ", " + attrName + ", null);");
        }
        body.append("\n        if (this." + attrName + " == null) {\n            throw new IllegalArgumentException(\"List does not contain given element\");\n        }\n        " + attrType + " oldValue = this." + attrName + ".remove(index);\n        if (oldValue == null) {\n            throw new IllegalArgumentException(\"List does not contain given element\");\n        }\n    ");
        if (reverse != null && (reverse.isNavigable() || this.templateHelper.hasUnidirectionalRelationOnAbstractType(attribute, (ObjectModel)this.model))) {
            String getterName = this.getJavaBeanMethodName("get", reverse.getName());
            String setterName = this.getJavaBeanMethodName("set", reverse.getName());
            if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)reverse)) {
                body.append("    oldValue." + setterName + "(null);\n    ");
            } else if (!attribute.hasAssociationClass()) {
                body.append("    " + attrName + "." + getterName + "().remove(this);\n    ");
            }
        }
        if (this.generatePropertyChangeSupport) {
            body.append("    fireOnPostWrite(" + constantName + ", index, oldValue, null);\n    ");
        }
        this.setOperationBody(implOperation, body.toString());
    }

    protected void addMultipleClearOperation(ObjectModelAttribute attribute, ObjectModelClassifier aClass, ObjectModelPackage aPackage, String collectionInterface, String collectionImpl) {
        String attrName = this.getPropertyName(attribute);
        String attrType = this.getPropertyType(attribute, aClass, aPackage);
        ObjectModelAttribute reverse = attribute.getReverseAttribute();
        String constantName = this.getConstantName(attrName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generate multiple 'clear' operation for property : " + attrName + " [" + attrType + "]"));
        }
        ObjectModelOperation interfaceOperation = this.addOperation((ObjectModelClassifier)this.outputInterface, this.getJavaBeanMethodName("clear", attrName), Void.TYPE, new ObjectModelModifier[]{ObjectModelJavaModifier.PACKAGE});
        ObjectModelOperation implOperation = this.createImplOperation(interfaceOperation);
        attrType = GeneratorUtil.getSimpleName((String)attrType);
        StringBuilder body = new StringBuilder("\n        if (this." + attrName + " == null) {\n            return;\n        }\n");
        if (reverse != null && (reverse.isNavigable() || this.templateHelper.hasUnidirectionalRelationOnAbstractType(attribute, (ObjectModel)this.model))) {
            String getterName = this.getJavaBeanMethodName("get", reverse.getName());
            String setterName = this.getJavaBeanMethodName("set", reverse.getName());
            body.append("        for (" + attrType + " item : this." + attrName + ") {\n");
            if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)reverse)) {
                body.append("            item." + setterName + "(null);\n");
            } else if (!attribute.hasAssociationClass()) {
                body.append("            item." + getterName + "().remove(this);\n");
            }
            body.append("        }\n");
        }
        if (this.generatePropertyChangeSupport) {
            body.append("        " + collectionInterface + "<" + attrType + "> oldValue = new " + collectionImpl + "<" + attrType + ">(this." + attrName + ");\n        fireOnPreWrite(" + constantName + ", oldValue, this." + attrName + ");\n");
        }
        body.append("        this." + attrName + ".clear();\n    ");
        if (this.generatePropertyChangeSupport) {
            body.append("    fireOnPostWrite(" + constantName + ", oldValue, this." + attrName + ");\n    ");
        }
        this.setOperationBody(implOperation, body.toString());
    }

    protected void addMultipleGetOperation(ObjectModelAttribute attribute, ObjectModelClassifier aClass, ObjectModelPackage aPackage, String collectionInterface) {
        String attrName = this.getPropertyName(attribute);
        String attrType = collectionInterface + "<" + this.getPropertyType(attribute, aClass, aPackage) + ">";
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generate multiple 'get' operation for property : " + attrName + " [" + attrType + "]"));
        }
        ObjectModelOperation interfaceOperation = this.addOperation((ObjectModelClassifier)this.outputInterface, this.getJavaBeanMethodName("get", attrName), attrType, new ObjectModelModifier[]{ObjectModelJavaModifier.PACKAGE});
        ObjectModelOperation implOperation = this.createImplOperation(interfaceOperation);
        this.setOperationBody(implOperation, "\n        return " + attrName + ";\n    ");
    }

    protected void addMultipleGetByIndexOperation(ObjectModelAttribute attribute, ObjectModelClassifier aClass, ObjectModelPackage aPackage) {
        String attrName = this.getPropertyName(attribute);
        String attrType = this.getPropertyType(attribute, aClass, aPackage);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generate multiple 'getByTopiaId' operation for property : " + attrName + " [" + attrType + "]"));
        }
        ObjectModelOperation interfaceOperation = this.addOperation((ObjectModelClassifier)this.outputInterface, this.getJavaBeanMethodName("get", attrName), attrType, new ObjectModelModifier[]{ObjectModelJavaModifier.PACKAGE});
        ObjectModelParameter param = this.addParameter(interfaceOperation, Integer.TYPE, "index");
        ObjectModelOperation implOperation = this.createImplOperation(interfaceOperation);
        this.addImport((ObjectModelClassifier)this.outputAbstract, TopiaEntityHelper.class);
        this.setOperationBody(implOperation, "\n        return TopiaEntityHelper.getEntityByIndex(" + attrName + ", index);\n    ");
    }

    protected void addMultipleGetByTopiaIdOperation(ObjectModelAttribute attribute, ObjectModelClassifier aClass, ObjectModelPackage aPackage) {
        String attrName = this.getPropertyName(attribute);
        String attrType = this.getPropertyType(attribute, aClass, aPackage);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generate multiple 'getByTopiaId' operation for property : " + attrName + " [" + attrType + "]"));
        }
        ObjectModelOperation interfaceOperation = this.addOperation((ObjectModelClassifier)this.outputInterface, this.getJavaBeanMethodName("get", attrName) + "ByTopiaId", attrType, new ObjectModelModifier[]{ObjectModelJavaModifier.PACKAGE});
        ObjectModelParameter param = this.addParameter(interfaceOperation, String.class, "topiaId");
        ObjectModelOperation implOperation = this.createImplOperation(interfaceOperation);
        this.addImport((ObjectModelClassifier)this.outputAbstract, TopiaEntityHelper.class);
        this.setOperationBody(implOperation, "\n        return TopiaEntityHelper.getEntityByTopiaId(" + attrName + ", topiaId);\n    ");
    }

    protected void addMultipleGetTopiaIdsOperation(ObjectModelAttribute attribute, ObjectModelClassifier aClass, ObjectModelPackage aPackage, String collectionInterface, String collectionImpl) {
        String attrName = this.getPropertyName(attribute);
        String attrType = this.getPropertyType(attribute, aClass, aPackage);
        String getterName = this.getJavaBeanMethodName("get", attrName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generate multiple 'getTopiaIds' operation for property : " + attrName + " [" + attrType + "]"));
        }
        ObjectModelOperation interfaceOperation = this.addOperation((ObjectModelClassifier)this.outputInterface, this.getJavaBeanMethodName("get", attrName) + "TopiaIds", collectionInterface + "<String>", new ObjectModelModifier[]{ObjectModelJavaModifier.PACKAGE});
        this.addImport((ObjectModelClassifier)this.outputAbstract, TopiaEntity.class);
        ObjectModelOperation implOperation = this.createImplOperation(interfaceOperation);
        this.setOperationBody(implOperation, "\n        " + collectionInterface + "<String> topiaIds = new " + collectionImpl + "<String>();\n        " + collectionInterface + "<" + attrType + "> tmp = " + getterName + "();\n        if (tmp != null) {\n            for (TopiaEntity topiaEntity : tmp) {\n                topiaIds.add(topiaEntity.getTopiaId());\n            }\n        }\n        return topiaIds;\n    ");
    }

    protected void addMultipleGetOperationFromEntity(ObjectModelAttribute attribute, ObjectModelClassifier aClass, ObjectModelPackage aPackage) {
        String referenceName = attribute.getName();
        String referenceType = attribute.getType();
        String referenceGetterName = this.getJavaBeanMethodName("get", referenceName);
        String attrName = this.getPropertyName(attribute);
        String attrType = this.getPropertyType(attribute, aClass, aPackage);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generate multiple 'getFromEntity' operation for property : " + attrName + " [" + attrType + "]"));
        }
        ObjectModelOperation interfaceOperation = this.addOperation((ObjectModelClassifier)this.outputInterface, this.getJavaBeanMethodName("get", attrName), attrType, new ObjectModelModifier[0]);
        this.addParameter(interfaceOperation, referenceType, referenceName);
        ObjectModelOperation implOperation = this.createImplOperation(interfaceOperation);
        attrType = GeneratorUtil.getSimpleName((String)attrType);
        this.setOperationBody(implOperation, "\n        if (" + referenceName + " == null || this." + attrName + " == null) {\n            return null;\n        }\n        for (" + attrType + " item : this." + attrName + ") {\n            if (" + referenceName + ".equals(item." + referenceGetterName + "())) {\n                return item;\n            }\n        }\n        return null;\n    ");
    }

    protected void addMultipleSizeOperation(ObjectModelAttribute attribute) {
        String attrName = this.getPropertyName(attribute);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generate multiple 'size' operation for property : " + attrName));
        }
        ObjectModelOperation interfaceOperation = this.addOperation((ObjectModelClassifier)this.outputInterface, this.getJavaBeanMethodName("size", attrName), Integer.TYPE, new ObjectModelModifier[]{ObjectModelJavaModifier.PACKAGE});
        ObjectModelOperation implOperation = this.createImplOperation(interfaceOperation);
        this.setOperationBody(implOperation, "\n        if (" + attrName + " == null) {\n            return 0;\n        }\n        return " + attrName + ".size();\n    ");
    }

    protected void addMultipleIsEmptyOperations(ObjectModelAttribute attribute) {
        String attrName = this.getPropertyName(attribute);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generate multiple 'isEmpty' operation for property : " + attrName));
        }
        String sizeMethodName = this.getJavaBeanMethodName("size", attrName);
        String isEmptyMethodName = this.getJavaBeanMethodName("is", attrName) + "Empty";
        ObjectModelOperation isEmptyInterfaceOperation = this.addOperation((ObjectModelClassifier)this.outputInterface, isEmptyMethodName, Boolean.TYPE, new ObjectModelModifier[]{ObjectModelJavaModifier.PACKAGE});
        ObjectModelOperation isEmptyOperationImpl = this.createImplOperation(isEmptyInterfaceOperation);
        this.setOperationBody(isEmptyOperationImpl, "\n        int size = " + sizeMethodName + "();\n        return size == 0;\n    ");
        ObjectModelOperation isNotEmptyInterfaceOperation = this.addOperation((ObjectModelClassifier)this.outputInterface, this.getJavaBeanMethodName("is", attrName) + "NotEmpty", Boolean.TYPE, new ObjectModelModifier[]{ObjectModelJavaModifier.PACKAGE});
        ObjectModelOperation isNotEmptyOperationImpl = this.createImplOperation(isNotEmptyInterfaceOperation);
        this.setOperationBody(isNotEmptyOperationImpl, "\n        boolean empty = " + isEmptyMethodName + "();\n        return ! empty;\n    ");
    }

    protected void addMultipleContainsOperation(ObjectModelAttribute attribute, ObjectModelClassifier aClass, ObjectModelPackage aPackage) {
        String attrName = this.getPropertyName(attribute);
        String attrType = this.getPropertyType(attribute, aClass, aPackage);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generate multiple 'contains' operation for property : " + attrName));
        }
        String methodName = this.getJavaBeanMethodName("contains", attrName);
        ObjectModelOperation isEmptyInterfaceOperation = this.addOperation((ObjectModelClassifier)this.outputInterface, methodName, Boolean.TYPE, new ObjectModelModifier[]{ObjectModelJavaModifier.PACKAGE});
        this.addParameter(isEmptyInterfaceOperation, attrType, attrName);
        ObjectModelOperation isEmptyOperationImpl = this.createImplOperation(isEmptyInterfaceOperation);
        this.setOperationBody(isEmptyOperationImpl, "\n        boolean contains = this." + attrName + " !=null && this." + attrName + ".contains(" + attrName + ");\n        return contains;\n    ");
    }

    protected void createAcceptOperation() {
        ObjectModelOperation acceptOperation = this.addOperation((ObjectModelClassifier)this.outputAbstract, "accept", Void.TYPE, new ObjectModelModifier[0]);
        this.addAnnotation((ObjectModelClassifier)this.outputAbstract, (ObjectModelElement)acceptOperation, Override.class);
        this.addParameter(acceptOperation, TopiaEntityVisitor.class, "visitor");
        this.addException(acceptOperation, TopiaException.class);
        this.setOperationBody(acceptOperation, "\n        visitor.start(this);\n        accept0(visitor);\n        visitor.end(this);\n    ");
    }

    protected void createAcceptInternalOperation(ObjectModelClass input) {
        boolean withSuperEntity = false;
        for (ObjectModelClassifier parent : input.getSuperclasses()) {
            if (!this.templateHelper.isEntity(parent)) continue;
            withSuperEntity = true;
            break;
        }
        this.internalAcceptOperation = this.addOperation((ObjectModelClassifier)this.outputAbstract, "accept0", Void.TYPE, new ObjectModelModifier[]{ObjectModelJavaModifier.PROTECTED});
        this.addParameter(this.internalAcceptOperation, TopiaEntityVisitor.class, "visitor");
        this.addException(this.internalAcceptOperation, TopiaException.class);
        if (withSuperEntity) {
            this.addAnnotation((ObjectModelClassifier)this.outputAbstract, (ObjectModelElement)this.internalAcceptOperation, Override.class);
            this.internalAcceptOperationBody = new StringBuilder("\n        super.accept0(visitor);\n");
        } else {
            this.internalAcceptOperationBody = new StringBuilder("\n");
        }
    }

    protected void updateAcceptOperation(ObjectModelAttribute attribute, ObjectModelClassifier aClass, ObjectModelPackage aPackage) {
        String attrName = GeneratorUtil.getSimpleName((String)this.getPropertyName(attribute));
        String attrType = GeneratorUtil.getSimpleName((String)this.getPropertyType(attribute, aClass, aPackage));
        attrType = GeneratorUtil.removeAnyGenericDefinition((String)attrType);
        String collectionType = this.getCollectionType(attribute);
        String constantName = this.getConstantName(attrName);
        if (collectionType != null) {
            collectionType = GeneratorUtil.getSimpleName((String)collectionType);
            this.internalAcceptOperationBody.append("        visitor.visit(this, " + constantName + ", " + collectionType + ".class, " + attrType + ".class, " + attrName + ");\n");
        } else {
            this.internalAcceptOperationBody.append("        visitor.visit(this, " + constantName + ", " + attrType + ".class, " + attrName + ");\n");
        }
    }

    protected void closeAcceptInternalOperation() {
        this.setOperationBody(this.internalAcceptOperation, this.internalAcceptOperationBody.toString() + "    ");
    }

    protected void generateToStringOperation(ObjectModelClass input) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("generate toString method for entity " + this.outputInterface.getQualifiedName()));
        }
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)this.outputAbstract, "toString", String.class, new ObjectModelModifier[0]);
        this.addAnnotation((ObjectModelClassifier)this.outputAbstract, (ObjectModelElement)operation, Override.class);
        this.addImport((ObjectModelClassifier)this.outputAbstract, ToStringBuilder.class);
        StringBuilder body = new StringBuilder("\n        String result = new ToStringBuilder(this).\n");
        for (ObjectModelAttribute attr : input.getAttributes()) {
            ObjectModelClass attrEntity = null;
            if (((ObjectModel)this.model).hasClass(attr.getType())) {
                attrEntity = ((ObjectModel)this.model).getClass(attr.getType());
            }
            boolean isEntity = attrEntity != null && this.templateHelper.isEntity((ObjectModelClassifier)attrEntity);
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            if ((!isEntity || reverse != null && reverse.isNavigable() || attr.hasAssociationClass()) && isEntity) continue;
            String attrName = attr.getName();
            String constantName = this.getConstantName(attrName);
            body.append("            append(" + constantName + ", this." + attrName + ").\n");
        }
        body.append("         toString();\n        return result;\n    ");
        this.setOperationBody(operation, body.length() == 0 ? " " : body.toString());
    }

    protected boolean isAbstract(ObjectModelClass clazz) {
        if (clazz.isAbstract()) {
            return true;
        }
        Collection allInterfaceOperations = clazz.getAllInterfaceOperations(true);
        allInterfaceOperations.removeAll(clazz.getAllOtherOperations(true));
        for (ObjectModelOperation op : allInterfaceOperations) {
            boolean implementationFound = false;
            for (ObjectModelClass superClazz : clazz.getSuperclasses()) {
                ObjectModelOperation matchingOp;
                Iterator iterator = superClazz.getOperations(op.getName()).iterator();
                while (iterator.hasNext() && !(implementationFound = op.equals(matchingOp = (ObjectModelOperation)iterator.next()) && !matchingOp.isAbstract())) {
                }
                if (!implementationFound) continue;
                break;
            }
            if (implementationFound) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)(clazz.getName() + " : abstract operation " + op));
            }
            return true;
        }
        return false;
    }

    protected String getCollectionType(ObjectModelAttribute attribute) {
        String result = null;
        if (!this.associationClass && GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attribute)) {
            result = this.templateHelper.getCollectionType(attribute).getName();
        }
        return result;
    }

    protected String getPropertyName(ObjectModelAttribute attribute) {
        String propertyName = attribute.getName();
        if (!this.associationClass && attribute.hasAssociationClass()) {
            propertyName = GeneratorUtil.getAssocAttrName((ObjectModelAttribute)attribute);
        }
        return propertyName;
    }

    protected String getPropertyType(ObjectModelAttribute attribute, ObjectModelClassifier aClass, ObjectModelPackage aPackage) {
        String propertyType = this.topiaHibernateTagValues.getAttributeType(attribute, aClass, aPackage, (ObjectModel)this.model);
        if (propertyType == null) {
            propertyType = attribute.getType();
        }
        if (!this.associationClass && attribute.hasAssociationClass()) {
            propertyType = attribute.getAssociationClass().getQualifiedName();
        }
        return propertyType;
    }

    protected ObjectModelOperation createImplOperation(ObjectModelOperation interfaceOperation) {
        ObjectModelOperation implOperation = this.cloneOperationSignature(interfaceOperation, (ObjectModelClassifier)this.outputAbstract, false, new ObjectModelModifier[0]);
        this.addAnnotation((ObjectModelClassifier)this.outputAbstract, (ObjectModelElement)implOperation, Override.class);
        return implOperation;
    }

    protected ObjectModelOperation createPropertySetterSignature(ObjectModelClassifier classifier, String propertyType, String propertyName, String operationDocumentation) {
        ObjectModelOperation operation = this.addOperation(classifier, this.getJavaBeanMethodName("set", propertyName), Void.TYPE, new ObjectModelModifier[0]);
        ObjectModelParameter param = this.addParameter(operation, propertyType, propertyName);
        if (StringUtils.isNotEmpty((CharSequence)operationDocumentation)) {
            this.setDocumentation((ObjectModelElement)operation, operationDocumentation);
            this.setDocumentation((ObjectModelElement)param, "La valeur de l'attribut \u00e0 positionner.");
        }
        return operation;
    }

    protected void addInterface(List<String> interfaceAlreadyDone, ObjectModelClassifier output, ObjectModelClassifier interfaze) {
        String qualifiedName = interfaze.getQualifiedName();
        if (!interfaceAlreadyDone.contains(qualifiedName)) {
            interfaceAlreadyDone.add(qualifiedName);
            if (output != null) {
                this.addInterface(output, qualifiedName);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Add interface " + qualifiedName + " on " + output.getQualifiedName()));
                }
            } else if (log.isTraceEnabled()) {
                log.trace((Object)("Skip included interface " + qualifiedName));
            }
            for (ObjectModelClassifier parent : interfaze.getInterfaces()) {
                this.addInterface(interfaceAlreadyDone, null, parent);
            }
        }
    }

    protected void addInterface(List<String> interfaceAlreadyDone, ObjectModelClassifier output, Class<?> clazz) {
        String qualifiedName = clazz.getName();
        if (!interfaceAlreadyDone.contains(qualifiedName)) {
            this.addInterface(output, qualifiedName);
        }
    }
}

