package org.nuiton.topia.history.entities;

import java.util.List;


import java.util.Arrays;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;

/**
 * Implantation DAO pour l'entité History.
 * Cette classe contient une implantation de TopiaDAO a laquel elle peut
 * deleguer des traitements
 * 
 */
public abstract class HistoryDAOAbstract<E extends History> extends org.nuiton.topia.persistence.TopiaDAOImpl<E> implements org.nuiton.topia.persistence.TopiaDAO<E> {    

    public Class<E> getEntityClass() {
        return (Class<E>)History.class;
    }

    public void delete(E entity) throws TopiaException {
        
        super.delete(entity);
    }    
     
    /**
     * Recherche sur l'attribut actionDate
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * actionDate le paramètre
     * @param v la valeur que doit avoir actionDate
     * @return un element ou null
     */
    public E findByActionDate(java.util.Date v) throws TopiaException {
        E result = findByProperty("actionDate", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * actionDate le paramètre
     * @param v la valeur que doit avoir actionDate
     * @return une liste
     */
    public List<E> findAllByActionDate(java.util.Date v) throws TopiaException {
        List<E> result = findAllByProperty("actionDate", v);
        return result;
    }
    /**
     * Recherche sur l'attribut userId
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * userId le paramètre
     * @param v la valeur que doit avoir userId
     * @return un element ou null
     */
    public E findByUserId(java.lang.String v) throws TopiaException {
        E result = findByProperty("userId", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * userId le paramètre
     * @param v la valeur que doit avoir userId
     * @return une liste
     */
    public List<E> findAllByUserId(java.lang.String v) throws TopiaException {
        List<E> result = findAllByProperty("userId", v);
        return result;
    }
    /**
     * Recherche sur l'attribut action
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * action le paramètre
     * @param v la valeur que doit avoir action
     * @return un element ou null
     */
    public E findByAction(int v) throws TopiaException {
        E result = findByProperty("action", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * action le paramètre
     * @param v la valeur que doit avoir action
     * @return une liste
     */
    public List<E> findAllByAction(int v) throws TopiaException {
        List<E> result = findAllByProperty("action", v);
        return result;
    }
    /**
     * Recherche sur l'attribut type
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * type le paramètre
     * @param v la valeur que doit avoir type
     * @return un element ou null
     */
    public E findByType(java.lang.String v) throws TopiaException {
        E result = findByProperty("type", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * type le paramètre
     * @param v la valeur que doit avoir type
     * @return une liste
     */
    public List<E> findAllByType(java.lang.String v) throws TopiaException {
        List<E> result = findAllByProperty("type", v);
        return result;
    }
    /**
     * Recherche sur l'attribut target
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * target le paramètre
     * @param v la valeur que doit avoir target
     * @return un element ou null
     */
    public E findByTarget(java.lang.String v) throws TopiaException {
        E result = findByProperty("target", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * target le paramètre
     * @param v la valeur que doit avoir target
     * @return une liste
     */
    public List<E> findAllByTarget(java.lang.String v) throws TopiaException {
        List<E> result = findAllByProperty("target", v);
        return result;
    }

} // HistoryDAOAbstract
