/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.internal.support;

import com.google.common.base.Preconditions;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.VetoableChangeSupport;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaApplicationContext;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaPersistenceContext;
import org.nuiton.topia.persistence.TopiaVetoException;
import org.nuiton.topia.persistence.event.EntityState;
import org.nuiton.topia.persistence.event.TopiaContextEvent;
import org.nuiton.topia.persistence.event.TopiaEntitiesEvent;
import org.nuiton.topia.persistence.event.TopiaEntitiesVetoable;
import org.nuiton.topia.persistence.event.TopiaEntityEvent;
import org.nuiton.topia.persistence.event.TopiaEntityListener;
import org.nuiton.topia.persistence.event.TopiaEntityVetoable;
import org.nuiton.topia.persistence.event.TopiaSchemaListener;
import org.nuiton.topia.persistence.event.TopiaTransactionEvent;
import org.nuiton.topia.persistence.event.TopiaTransactionListener;
import org.nuiton.topia.persistence.event.TopiaTransactionVetoable;
import org.nuiton.topia.persistence.internal.support.AbstractTopiaListenableSupport;
import org.nuiton.topia.persistence.support.TopiaJpaSupport;
import org.nuiton.topia.persistence.support.TopiaListenableSupport;
import org.nuiton.util.CategorisedListenerSet;
import org.nuiton.util.ListenerSet;

public class TopiaFiresSupport
extends AbstractTopiaListenableSupport
implements TopiaListenableSupport {
    private static final Log log = LogFactory.getLog(TopiaFiresSupport.class);
    protected static final Object NO_CHANGE = new Object();
    protected TopiaFiresSupport parent;

    public TopiaFiresSupport() {
    }

    public TopiaFiresSupport(TopiaFiresSupport parent) {
        this.parent = parent;
    }

    protected EntityState getEntityState(TopiaEntity entity) {
        EntityState state = (EntityState)this.transactionEntities.get(entity);
        if (state == null) {
            state = new EntityState();
            this.transactionEntities.put(entity, state);
        }
        return state;
    }

    public void notifyEntityLoaded(TopiaEntity entity) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"notifyEntityLoaded");
        }
        EntityState state = this.getEntityState(entity);
        state.addLoaded();
    }

    public void notifyEntityCreated(TopiaEntity entity) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"notifyEntityCreated");
        }
        EntityState state = this.getEntityState(entity);
        state.addCreated();
    }

    public void notifyEntityRead(TopiaEntity entity) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"notifyEntityRead");
        }
        EntityState state = this.getEntityState(entity);
        state.addRead();
    }

    public void notifyEntityUpdated(TopiaEntity entity) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"notifyEntityUpdated");
        }
        EntityState state = this.getEntityState(entity);
        state.addUpdated();
    }

    public void notifyEntityWritten(TopiaEntity entity) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"notifyEntityWritten");
        }
        EntityState state = this.getEntityState(entity);
        state.addWritten();
    }

    public void notifyEntityDeleted(TopiaEntity entity) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"notifyEntityDeleted");
        }
        EntityState state = this.getEntityState(entity);
        state.addDeleted();
    }

    protected boolean isNotEmpty(ListenerSet<?> set) {
        return set.size() > 0;
    }

    protected boolean isNotEmpty(Set<?> set) {
        return set.size() > 0;
    }

    protected boolean isNotEmpty(CategorisedListenerSet<?> set, Class<?> category) {
        return set.iterator(category).hasNext();
    }

    public void fireOnBeginTransaction(TopiaPersistenceContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"fireOnBeginTransaction");
        }
        if (this.isNotEmpty(this.transactionVetoables)) {
            TopiaTransactionEvent e = new TopiaTransactionEvent(context);
            for (TopiaTransactionVetoable listener : this.transactionVetoables) {
                try {
                    listener.beginTransaction(e);
                }
                catch (Exception eee) {
                    throw new TopiaVetoException(eee);
                }
            }
        }
        if (this.parent != null) {
            this.parent.fireOnBeginTransaction(context);
        }
    }

    public void fireOnPostCommit(TopiaPersistenceContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"fireOnPostCommit");
        }
        if (this.isNotEmpty(this.transactionListeners)) {
            TopiaTransactionEvent e = new TopiaTransactionEvent(context, this.transactionEntities);
            for (TopiaTransactionListener listener : this.transactionListeners) {
                try {
                    listener.commit(e);
                }
                catch (Exception eee) {
                    if (!log.isErrorEnabled()) continue;
                    log.error((Object)"Can't fireOnPostCommit", (Throwable)eee);
                }
            }
        }
        this.transactionEntities.clear();
        if (this.parent != null) {
            this.parent.fireOnPostCommit(context);
        }
    }

    public void fireOnPostRollback(TopiaPersistenceContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"fireOnPostRollback");
        }
        if (this.isNotEmpty(this.transactionListeners)) {
            TopiaTransactionEvent e = new TopiaTransactionEvent(context, this.transactionEntities);
            for (TopiaTransactionListener listener : this.transactionListeners) {
                try {
                    listener.rollback(e);
                }
                catch (Exception eee) {
                    if (!log.isErrorEnabled()) continue;
                    log.error((Object)"Can't fireOnPostRollback", (Throwable)eee);
                }
            }
        }
        this.transactionEntities.clear();
        if (this.parent != null) {
            this.parent.fireOnPostRollback(context);
        }
    }

    public void fireOnPreLoad(TopiaPersistenceContext context, TopiaEntity entity, Object[] state) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"fireOnPreLoad");
        }
        if (this.isNotEmpty(this.entityVetoables, entity.getClass())) {
            TopiaEntityEvent event = new TopiaEntityEvent(context, entity, state);
            Iterator l = this.entityVetoables.iterator(entity.getClass());
            while (l.hasNext()) {
                try {
                    ((TopiaEntityVetoable)l.next()).load(event);
                }
                catch (Exception eee) {
                    throw new TopiaVetoException(eee);
                }
            }
        }
        if (this.parent != null) {
            this.parent.fireOnPreLoad(context, entity, state);
        }
    }

    public void fireOnPostLoad(TopiaPersistenceContext context, TopiaEntity entity, Object[] state) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"fireOnPostLoad");
        }
        this.notifyEntityLoaded(entity);
        if (this.isNotEmpty(this.entityListeners, entity.getClass())) {
            TopiaEntityEvent event = new TopiaEntityEvent(context, entity, state);
            Iterator l = this.entityListeners.iterator(entity.getClass());
            while (l.hasNext()) {
                try {
                    ((TopiaEntityListener)l.next()).load(event);
                }
                catch (Exception eee) {
                    if (!log.isErrorEnabled()) continue;
                    log.error((Object)("Can't fireOnPostLoad for entity: " + String.valueOf(entity)), (Throwable)eee);
                }
            }
        }
        if (this.parent != null) {
            this.parent.fireOnPostLoad(context, entity, state);
        }
    }

    public void fireOnPreCreate(TopiaPersistenceContext context, TopiaEntity entity, Object[] state) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"fireOnPreCreate");
        }
        if (this.isNotEmpty(this.entityVetoables, entity.getClass())) {
            TopiaEntityEvent event = new TopiaEntityEvent(context, entity, state);
            Iterator l = this.entityVetoables.iterator(entity.getClass());
            while (l.hasNext()) {
                try {
                    ((TopiaEntityVetoable)l.next()).create(event);
                }
                catch (Exception eee) {
                    throw new TopiaVetoException(eee);
                }
            }
        }
        if (this.parent != null) {
            this.parent.fireOnPreCreate(context, entity, state);
        }
    }

    public void fireOnPostCreate(TopiaPersistenceContext context, TopiaEntity entity, Object[] state) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"fireOnPostCreate");
        }
        this.notifyEntityCreated(entity);
        if (this.isNotEmpty(this.entityListeners, entity.getClass())) {
            TopiaEntityEvent event = new TopiaEntityEvent(context, entity, state);
            Iterator l = this.entityListeners.iterator(entity.getClass());
            while (l.hasNext()) {
                try {
                    ((TopiaEntityListener)l.next()).create(event);
                }
                catch (Exception eee) {
                    if (!log.isErrorEnabled()) continue;
                    log.error((Object)("Can't fireOnPostCreate for entity: " + String.valueOf(entity)), (Throwable)eee);
                }
            }
        }
        if (this.parent != null) {
            this.parent.fireOnPostCreate(context, entity, state);
        }
    }

    public void fireOnPreUpdate(TopiaPersistenceContext context, TopiaEntity entity, Object[] state) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"fireOnPreUpdate");
        }
        if (this.isNotEmpty(this.entityVetoables, entity.getClass())) {
            TopiaEntityEvent event = new TopiaEntityEvent(context, entity, state);
            Iterator l = this.entityVetoables.iterator(entity.getClass());
            while (l.hasNext()) {
                try {
                    ((TopiaEntityVetoable)l.next()).update(event);
                }
                catch (Exception eee) {
                    throw new TopiaVetoException(eee);
                }
            }
        }
        if (this.parent != null) {
            this.parent.fireOnPreUpdate(context, entity, state);
        }
    }

    public void fireOnPostUpdate(TopiaPersistenceContext context, TopiaEntity entity, Object[] state) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"fireOnPostUpdate");
        }
        this.notifyEntityUpdated(entity);
        if (this.isNotEmpty(this.entityListeners, entity.getClass())) {
            TopiaEntityEvent event = new TopiaEntityEvent(context, entity, state);
            Iterator l = this.entityListeners.iterator(entity.getClass());
            while (l.hasNext()) {
                try {
                    ((TopiaEntityListener)l.next()).update(event);
                }
                catch (Exception eee) {
                    if (!log.isErrorEnabled()) continue;
                    log.error((Object)("Can't fireOnPostUpdate for entity: " + String.valueOf(entity)), (Throwable)eee);
                }
            }
        }
        if (this.parent != null) {
            this.parent.fireOnPostUpdate(context, entity, state);
        }
    }

    public void fireOnPreDelete(TopiaPersistenceContext context, TopiaEntity entity, Object[] state) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"fireOnPreDelete");
        }
        if (this.isNotEmpty(this.entityVetoables, entity.getClass())) {
            TopiaEntityEvent event = new TopiaEntityEvent(context, entity, state);
            Iterator l = this.entityVetoables.iterator(entity.getClass());
            while (l.hasNext()) {
                try {
                    ((TopiaEntityVetoable)l.next()).delete(event);
                }
                catch (Exception eee) {
                    throw new TopiaVetoException(eee);
                }
            }
        }
        if (this.parent != null) {
            this.parent.fireOnPreDelete(context, entity, state);
        }
    }

    public void fireOnPostDelete(TopiaPersistenceContext context, TopiaEntity entity, Object[] state) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"fireOnPostDelete");
        }
        this.notifyEntityDeleted(entity);
        if (this.isNotEmpty(this.entityListeners, entity.getClass())) {
            TopiaEntityEvent event = new TopiaEntityEvent(context, entity, state);
            Iterator l = this.entityListeners.iterator(entity.getClass());
            while (l.hasNext()) {
                try {
                    ((TopiaEntityListener)l.next()).delete(event);
                }
                catch (Exception eee) {
                    if (!log.isErrorEnabled()) continue;
                    log.error((Object)("Can't fireOnPostDelete for entity: " + String.valueOf(entity)), (Throwable)eee);
                }
            }
        }
        if (this.parent != null) {
            this.parent.fireOnPostDelete(context, entity, state);
        }
    }

    public void fireOnPreRead(VetoableChangeSupport vetoables, TopiaEntity entity, String propertyName, Object value) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"fireOnPreRead");
        }
        try {
            vetoables.fireVetoableChange(propertyName, value, NO_CHANGE);
        }
        catch (Exception eee) {
            throw new TopiaVetoException(eee);
        }
    }

    public void fireOnPostRead(PropertyChangeSupport listeners, TopiaEntity entity, String propertyName, Object value) {
        block3: {
            if (log.isDebugEnabled()) {
                log.debug((Object)"fireOnPostRead");
            }
            this.notifyEntityRead(entity);
            try {
                listeners.firePropertyChange(propertyName, value, NO_CHANGE);
            }
            catch (Exception eee) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"Can't fireOnPostRead", (Throwable)eee);
            }
        }
    }

    public void fireOnPostRead(PropertyChangeSupport listeners, TopiaEntity entity, String propertyName, int index, Object value) {
        block3: {
            if (log.isDebugEnabled()) {
                log.debug((Object)"fireOnPostRead");
            }
            this.notifyEntityRead(entity);
            try {
                listeners.fireIndexedPropertyChange(propertyName, index, value, NO_CHANGE);
            }
            catch (Exception eee) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"Can't fireOnPostRead", (Throwable)eee);
            }
        }
    }

    public void fireOnPreWrite(VetoableChangeSupport vetoables, TopiaEntity entity, String propertyName, Object oldValue, Object newValue) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"fireOnPreWrite");
        }
        try {
            vetoables.fireVetoableChange(propertyName, oldValue, newValue);
        }
        catch (Exception eee) {
            throw new TopiaVetoException(eee);
        }
    }

    public void fireOnPostWrite(PropertyChangeSupport listeners, TopiaEntity entity, String propertyName, Object oldValue, Object newValue) {
        block7: {
            if (log.isDebugEnabled()) {
                log.debug((Object)"fireOnPostWrite");
            }
            this.notifyEntityWritten(entity);
            if (this.isNotEmpty(this.propertyChangeListeners)) {
                PropertyChangeEvent e = new PropertyChangeEvent(entity, propertyName, oldValue, newValue);
                for (PropertyChangeListener l : this.propertyChangeListeners) {
                    try {
                        l.propertyChange(e);
                    }
                    catch (Exception eee) {
                        if (!log.isErrorEnabled()) continue;
                        log.error((Object)("Can't fire property change for: " + propertyName), (Throwable)eee);
                    }
                }
            }
            try {
                listeners.firePropertyChange(propertyName, oldValue, newValue);
            }
            catch (Exception eee) {
                if (!log.isErrorEnabled()) break block7;
                log.error((Object)("Can't fireOnPostWrite: " + propertyName), (Throwable)eee);
            }
        }
    }

    public void fireOnPostWrite(PropertyChangeSupport listeners, TopiaEntity entity, String propertyName, int index, Object oldValue, Object newValue) {
        block3: {
            if (log.isDebugEnabled()) {
                log.debug((Object)"fireOnPostWrite");
            }
            this.notifyEntityWritten(entity);
            try {
                listeners.fireIndexedPropertyChange(propertyName, index, oldValue, newValue);
            }
            catch (Exception eee) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"Can't fireOnPostWrite", (Throwable)eee);
            }
        }
    }

    public void firePreCreateSchema(TopiaApplicationContext context) {
        Preconditions.checkState((this.parent == null ? 1 : 0) != 0, (Object)"This method is designed to be used only on parent TopiaFiresSupport");
        if (log.isDebugEnabled()) {
            log.debug((Object)"firePreCreateSchema");
        }
        if (this.isNotEmpty(this.topiaSchemaListeners)) {
            TopiaContextEvent event = new TopiaContextEvent(context);
            for (TopiaSchemaListener topiaSchemaListener : this.topiaSchemaListeners) {
                try {
                    topiaSchemaListener.preCreateSchema(event);
                }
                catch (Exception eee) {
                    throw new TopiaVetoException(eee);
                }
            }
        }
    }

    public void firePostCreateSchema(TopiaApplicationContext context) {
        Preconditions.checkState((this.parent == null ? 1 : 0) != 0, (Object)"This method is designed to be used only on parent TopiaFiresSupport");
        if (log.isDebugEnabled()) {
            log.debug((Object)"firePostCreateSchema");
        }
        if (this.isNotEmpty(this.topiaSchemaListeners)) {
            TopiaContextEvent event = new TopiaContextEvent(context);
            for (TopiaSchemaListener topiaSchemaListener : this.topiaSchemaListeners) {
                try {
                    topiaSchemaListener.postCreateSchema(event);
                }
                catch (Exception eee) {
                    throw new TopiaVetoException(eee);
                }
            }
        }
    }

    public void firePreUpdateSchema(TopiaApplicationContext context) {
        Preconditions.checkState((this.parent == null ? 1 : 0) != 0, (Object)"This method is designed to be used only on parent TopiaFiresSupport");
        if (log.isDebugEnabled()) {
            log.debug((Object)"firePostCreateSchema");
        }
        if (this.isNotEmpty(this.topiaSchemaListeners)) {
            TopiaContextEvent event = new TopiaContextEvent(context);
            for (TopiaSchemaListener topiaSchemaListener : this.topiaSchemaListeners) {
                try {
                    topiaSchemaListener.preUpdateSchema(event);
                }
                catch (Exception eee) {
                    throw new TopiaVetoException(eee);
                }
            }
        }
    }

    public void firePostUpdateSchema(TopiaApplicationContext context) {
        Preconditions.checkState((this.parent == null ? 1 : 0) != 0, (Object)"This method is designed to be used only on parent TopiaFiresSupport");
        if (log.isDebugEnabled()) {
            log.debug((Object)"firePostCreateSchema");
        }
        if (this.isNotEmpty(this.topiaSchemaListeners)) {
            TopiaContextEvent event = new TopiaContextEvent(context);
            for (TopiaSchemaListener topiaSchemaListener : this.topiaSchemaListeners) {
                try {
                    topiaSchemaListener.postUpdateSchema(event);
                }
                catch (Exception eee) {
                    throw new TopiaVetoException(eee);
                }
            }
        }
    }

    public void firePreDropSchema(TopiaApplicationContext context) {
        Preconditions.checkState((this.parent == null ? 1 : 0) != 0, (Object)"This method is designed to be used only on parent TopiaFiresSupport");
        if (log.isDebugEnabled()) {
            log.debug((Object)"firePreDropSchema");
        }
        if (this.isNotEmpty(this.topiaSchemaListeners)) {
            TopiaContextEvent event = new TopiaContextEvent(context);
            for (TopiaSchemaListener topiaSchemaListener : this.topiaSchemaListeners) {
                try {
                    topiaSchemaListener.preDropSchema(event);
                }
                catch (Exception eee) {
                    throw new TopiaVetoException(eee);
                }
            }
        }
    }

    public void firePostDropSchema(TopiaApplicationContext context) {
        Preconditions.checkState((this.parent == null ? 1 : 0) != 0, (Object)"This method is designed to be used only on parent TopiaFiresSupport");
        if (log.isDebugEnabled()) {
            log.debug((Object)"firePostDropSchema");
        }
        if (this.isNotEmpty(this.topiaSchemaListeners)) {
            TopiaContextEvent event = new TopiaContextEvent(context);
            for (TopiaSchemaListener topiaSchemaListener : this.topiaSchemaListeners) {
                try {
                    topiaSchemaListener.postDropSchema(event);
                }
                catch (Exception eee) {
                    throw new TopiaVetoException(eee);
                }
            }
        }
    }

    public <E extends TopiaEntity> List<E> fireEntitiesLoad(TopiaJpaSupport context, List<E> entities) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"fireEntitiesLoad");
        }
        List<E> result = entities;
        for (TopiaEntitiesVetoable entitiesVetoable : this.entitiesVetoables) {
            try {
                TopiaEntitiesEvent<E> event = new TopiaEntitiesEvent<E>(context, result);
                result = entitiesVetoable.load(event);
            }
            catch (Exception eee) {
                throw new TopiaVetoException(eee);
            }
        }
        return result;
    }
}

