/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.BaseEncoding;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaIdFactory;

public class ShortTopiaIdFactory
implements TopiaIdFactory {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ShortTopiaIdFactory.class);
    protected static final Map<String, Class<? extends TopiaEntity>> ENTITY_CLASSES = Maps.newConcurrentMap();

    @Override
    public <E extends TopiaEntity> String newTopiaId(Class<E> entityClass, TopiaEntity topiaEntity) {
        String uuid = UUID.randomUUID().toString();
        String escapedUuid = uuid.replace("-", "").toUpperCase();
        byte[] bytes = BaseEncoding.base16().decode((CharSequence)escapedUuid);
        String randomPart = BaseEncoding.base64Url().encode(bytes);
        randomPart = randomPart.replace("=", "");
        String result = this.newTopiaId(entityClass, randomPart);
        return result;
    }

    @Override
    public <E extends TopiaEntity> String newTopiaId(Class<E> entityClass, String randomPart) {
        if (!entityClass.isInterface()) {
            throw new IllegalArgumentException("Only interface is permit to create id: " + String.valueOf(entityClass));
        }
        String simpleName = entityClass.getSimpleName();
        Preconditions.checkArgument((!simpleName.contains(this.getSeparator()) ? 1 : 0) != 0, (Object)"Your entity class name must not contains the separator");
        String result = simpleName + this.getSeparator() + randomPart;
        return result;
    }

    @Override
    public <E extends TopiaEntity> Class<E> getClassName(String topiaId) {
        String simpleClassName = StringUtils.substringBefore((String)topiaId, (String)this.getSeparator());
        try {
            Class<E> entityClass = this.findClassName(simpleClassName);
            return entityClass;
        }
        catch (ClassNotFoundException cnfe) {
            throw new TopiaException("Can't find class for topiaId = '" + topiaId + "'", cnfe);
        }
    }

    protected <E extends TopiaEntity> Class<E> findClassName(String simpleClassName) throws ClassNotFoundException {
        Class result;
        if (ENTITY_CLASSES.containsKey(simpleClassName)) {
            result = ENTITY_CLASSES.get(simpleClassName);
        } else {
            HashSet candidates = Sets.newHashSet();
            for (Package aPackage : Package.getPackages()) {
                String fqn = aPackage.getName() + "." + simpleClassName;
                try {
                    Class<?> aClass = Class.forName(fqn);
                    candidates.add(aClass);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Iterables.removeIf((Iterable)candidates, (Predicate)new Predicate<Class<?>>(){

                public boolean apply(Class<?> aClass) {
                    return !TopiaEntity.class.isAssignableFrom(aClass);
                }
            });
            if (candidates.size() == 1) {
                result = (Class)candidates.iterator().next();
                ENTITY_CLASSES.put(simpleClassName, result);
            } else {
                String message = String.format("Unable to find class with simple name=%s. Candidates are: %s", simpleClassName, candidates);
                throw new ClassNotFoundException(message);
            }
        }
        return result;
    }

    @Override
    public String getSeparator() {
        return "_";
    }

    @Override
    public String getRandomPart(String topiaId) {
        return StringUtils.substringAfter((String)topiaId, (String)this.getSeparator());
    }

    @Override
    public boolean isTopiaId(String str) {
        boolean isTopiaId;
        block3: {
            isTopiaId = false;
            if (str != null) {
                String simpleClassName = StringUtils.substringBefore((String)str, (String)this.getSeparator());
                try {
                    this.findClassName(simpleClassName);
                    isTopiaId = StringUtils.isNotBlank((CharSequence)StringUtils.substringAfter((String)str, (String)this.getSeparator()));
                }
                catch (ClassNotFoundException eee) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug((Object)eee);
                }
            }
        }
        return isTopiaId;
    }
}

