/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataBuilder;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.model.naming.ImplicitNamingStrategyLegacyHbmImpl;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.DerbyDialect;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.dialect.HSQLDialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.dialect.SQLServer2012Dialect;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.PostDeleteEventListener;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PostLoadEventListener;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.event.spi.PreDeleteEventListener;
import org.hibernate.event.spi.PreInsertEventListener;
import org.hibernate.event.spi.PreLoadEventListener;
import org.hibernate.event.spi.PreUpdateEventListener;
import org.hibernate.event.spi.SaveOrUpdateEventListener;
import org.hibernate.service.Service;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;
import org.hibernate.service.spi.Stoppable;
import org.nuiton.topia.persistence.TopiaConfiguration;
import org.nuiton.topia.persistence.TopiaMisconfigurationException;
import org.nuiton.topia.persistence.internal.TopiaHibernateSessionRegistry;
import org.nuiton.topia.persistence.internal.support.TopiaHibernateEventListener;
import org.nuiton.topia.persistence.jdbc.JdbcConfigurationBuilder;
import org.nuiton.topia.persistence.support.TopiaServiceSupport;
import org.nuiton.topia.persistence.util.TopiaUtil;

public class HibernateProvider {
    private static final Log log = LogFactory.getLog(HibernateProvider.class);
    static final String HIKARI_CP_HIBERNATE_CONNECTION_PROVIDER_CLASS_NAME = "org.hibernate.hikaricp.internal.HikariCPConnectionProvider";
    static final String C3P0_HIBERNATE_CONNECTION_PROVIDER_CLASS_NAME = "org.hibernate.c3p0.internal.C3P0ConnectionProvider";
    protected SessionFactory hibernateSessionFactory;
    protected Configuration hibernateConfiguration;
    protected TopiaConfiguration topiaConfiguration;
    protected TopiaServiceSupport topiaServiceSupport;
    protected TopiaHibernateSessionRegistry sessionRegistry;
    protected Set<Class<?>> persistenceClasses;
    protected Metadata metaData;

    public HibernateProvider(TopiaConfiguration topiaConfiguration, TopiaServiceSupport topiaServiceSupport, TopiaHibernateSessionRegistry sessionRegistry, Iterable<Class<?>> persistenceClasses) {
        this.topiaConfiguration = topiaConfiguration;
        this.topiaServiceSupport = topiaServiceSupport;
        this.sessionRegistry = sessionRegistry;
        this.persistenceClasses = ImmutableSet.copyOf(persistenceClasses);
    }

    public Configuration getHibernateConfiguration() {
        if (this.hibernateConfiguration == null) {
            this.hibernateConfiguration = this.newHibernateConfiguration();
            TopiaUtil.warnOnAutomaticSchemaOperationRisk(this.hibernateConfiguration);
        }
        return this.hibernateConfiguration;
    }

    public Configuration newHibernateConfiguration() {
        Configuration newHibernateConfiguration = new Configuration();
        for (Class<?> entityClass : this.persistenceClasses) {
            newHibernateConfiguration.addClass(entityClass);
        }
        Properties properties = new Properties();
        properties.put("jakarta.persistence.jdbc.url", this.topiaConfiguration.getJdbcConnectionUrl());
        properties.put("jakarta.persistence.jdbc.driver", this.topiaConfiguration.getJdbcDriverClass().getName());
        properties.put("jakarta.persistence.jdbc.user", this.topiaConfiguration.getJdbcConnectionUser());
        properties.put("jakarta.persistence.jdbc.password", this.topiaConfiguration.getJdbcConnectionPassword());
        properties.put("hibernate.dialect", HibernateProvider.getHibernateDialect(this.topiaConfiguration));
        if (this.topiaConfiguration.isUseHikariForJdbcConnectionPooling()) {
            properties.put("hibernate.connection.provider_class", HIKARI_CP_HIBERNATE_CONNECTION_PROVIDER_CLASS_NAME);
        } else {
            properties.put("hibernate.connection.provider_class", C3P0_HIBERNATE_CONNECTION_PROVIDER_CLASS_NAME);
            properties.put("hibernate.c3p0.min_size", (Object)5);
            properties.put("hibernate.c3p0.max_size", (Object)20);
            properties.put("hibernate.c3p0.timeout", (Object)1800);
            properties.put("hibernate.c3p0.max_statements", (Object)50);
        }
        if (this.topiaConfiguration.isValidateSchema()) {
            properties.put("hibernate.hbm2ddl.auto", "validate");
        }
        properties.put("hibernate.implicit_naming_strategy", ImplicitNamingStrategyLegacyHbmImpl.class.getName());
        properties.put("hibernate.format_sql", (Object)true);
        properties.put("hibernate.use_sql_comments", (Object)true);
        properties.putAll(this.topiaConfiguration.getHibernateExtraConfiguration());
        if (log.isInfoEnabled()) {
            log.info((Object)("will start hibernate with configuration " + properties));
        }
        newHibernateConfiguration.setProperties(properties);
        return newHibernateConfiguration;
    }

    public static String getHibernateDialect(TopiaConfiguration topiaConfiguration) {
        String dialect;
        String jdbcConnectionUrl = topiaConfiguration.getJdbcConnectionUrl();
        String guessedDialect = HibernateProvider.guessHibernateDialect(jdbcConnectionUrl);
        String userDefinedDialect = topiaConfiguration.getHibernateExtraConfiguration().get("hibernate.dialect");
        if (guessedDialect == null) {
            if (userDefinedDialect == null) {
                String message = String.format("unable to guess Hibernate dialect to use for JDBC URL %s please patch ToPIA or configure Hibernate manually using %s", jdbcConnectionUrl, "hibernate.dialect");
                throw new TopiaMisconfigurationException(message, topiaConfiguration);
            }
            dialect = userDefinedDialect;
        } else if (userDefinedDialect == null) {
            dialect = guessedDialect;
        } else {
            dialect = userDefinedDialect;
            if (guessedDialect.equals(userDefinedDialect)) {
                log.info((Object)("configuration defined hibernate dialect " + userDefinedDialect + " but ToPIA could have guessed it (you can remove the configuration directive safely)"));
            } else {
                log.warn((Object)("not sure if " + dialect + " is suitable for " + jdbcConnectionUrl));
            }
        }
        return dialect;
    }

    @Deprecated
    public static String guessHibernateDialect(String jdbcConnectionUrl) {
        JdbcConfigurationBuilder jdbcConfigurationBuilder = new JdbcConfigurationBuilder();
        String guessedHibernateDialect = null;
        if (jdbcConfigurationBuilder.isDb2Url(jdbcConnectionUrl) || jdbcConfigurationBuilder.isH2Url(jdbcConnectionUrl) && jdbcConnectionUrl.contains("MODE=DB2")) {
            guessedHibernateDialect = DB2Dialect.class.getName();
        } else if (jdbcConfigurationBuilder.isDerbyUrl(jdbcConnectionUrl) || jdbcConfigurationBuilder.isH2Url(jdbcConnectionUrl) && jdbcConnectionUrl.contains("MODE=Derby")) {
            guessedHibernateDialect = DerbyDialect.class.getName();
        } else if (jdbcConfigurationBuilder.isHsqlDbUrl(jdbcConnectionUrl) || jdbcConfigurationBuilder.isH2Url(jdbcConnectionUrl) && jdbcConnectionUrl.contains("MODE=HSQLDB")) {
            guessedHibernateDialect = HSQLDialect.class.getName();
        } else if (jdbcConfigurationBuilder.isMysqlUrl(jdbcConnectionUrl) || jdbcConfigurationBuilder.isMariaDbUrl(jdbcConnectionUrl) || jdbcConfigurationBuilder.isGoogleAppEngineUrl(jdbcConnectionUrl) || jdbcConfigurationBuilder.isH2Url(jdbcConnectionUrl) && jdbcConnectionUrl.contains("MODE=MySQL")) {
            guessedHibernateDialect = MySQLDialect.class.getName();
        } else if (jdbcConfigurationBuilder.isOracleUrl(jdbcConnectionUrl) || jdbcConfigurationBuilder.isH2Url(jdbcConnectionUrl) && jdbcConnectionUrl.contains("MODE=Oracle")) {
            guessedHibernateDialect = OracleDialect.class.getName();
        } else if (jdbcConfigurationBuilder.isPostgreSqlUrl(jdbcConnectionUrl) || jdbcConfigurationBuilder.isH2Url(jdbcConnectionUrl) && jdbcConnectionUrl.contains("MODE=PostgreSQL")) {
            guessedHibernateDialect = PostgreSQLDialect.class.getName();
        } else if (jdbcConfigurationBuilder.isJtdsUrl(jdbcConnectionUrl) || jdbcConfigurationBuilder.isSqlServerUrl(jdbcConnectionUrl) || jdbcConfigurationBuilder.isH2Url(jdbcConnectionUrl) && jdbcConnectionUrl.contains("MODE=MSSQLServer")) {
            guessedHibernateDialect = SQLServer2012Dialect.class.getName();
        } else if (jdbcConfigurationBuilder.isSqliteUrl(jdbcConnectionUrl) || jdbcConfigurationBuilder.isSqlDroidUrl(jdbcConnectionUrl)) {
            guessedHibernateDialect = null;
        } else if (jdbcConfigurationBuilder.isH2Url(jdbcConnectionUrl)) {
            guessedHibernateDialect = H2Dialect.class.getName();
        } else if (log.isWarnEnabled()) {
            log.warn((Object)("unable to guess Hibernate dialect for JDBC URL " + jdbcConnectionUrl + ". Please, submit a patch!"));
        }
        return guessedHibernateDialect;
    }

    public static StandardServiceRegistry getStandardServiceRegistry(SessionFactory sessionFactory) {
        SessionFactoryOptions sessionFactoryOptions = sessionFactory.getSessionFactoryOptions();
        StandardServiceRegistry result = sessionFactoryOptions.getServiceRegistry();
        return result;
    }

    protected static SessionFactoryServiceRegistry getSessionFactoryServiceRegistry(SessionFactory sessionFactory) {
        SessionFactoryImplementor sessionFactoryImplementor = (SessionFactoryImplementor)sessionFactory;
        SessionFactoryServiceRegistry result = (SessionFactoryServiceRegistry)sessionFactoryImplementor.getServiceRegistry();
        return result;
    }

    public static <S extends Service> S getHibernateService(SessionFactory sessionFactory, Class<S> serviceClass) {
        SessionFactoryServiceRegistry serviceRegistry = HibernateProvider.getSessionFactoryServiceRegistry(sessionFactory);
        Service result = serviceRegistry.getService(serviceClass);
        return (S)result;
    }

    public void close() {
        this.metaData = null;
        if (this.hibernateSessionFactory != null) {
            Preconditions.checkState((!this.hibernateSessionFactory.isClosed() ? 1 : 0) != 0);
            ConnectionProvider service = HibernateProvider.getHibernateService(this.hibernateSessionFactory, ConnectionProvider.class);
            if (service instanceof Stoppable) {
                Stoppable stoppable = (Stoppable)service;
                stoppable.stop();
            }
            this.hibernateSessionFactory.close();
        }
    }

    public SessionFactory getSessionFactory() {
        if (this.hibernateSessionFactory == null) {
            Configuration effectiveHibernateConfiguration = this.getHibernateConfiguration();
            this.hibernateSessionFactory = TopiaUtil.newSessionFactory(effectiveHibernateConfiguration);
            EventListenerRegistry eventListenerRegistry = HibernateProvider.getHibernateService(this.hibernateSessionFactory, EventListenerRegistry.class);
            TopiaHibernateEventListener listener = new TopiaHibernateEventListener(this.sessionRegistry);
            eventListenerRegistry.appendListeners(EventType.PRE_INSERT, (Object[])new PreInsertEventListener[]{listener});
            eventListenerRegistry.appendListeners(EventType.PRE_LOAD, (Object[])new PreLoadEventListener[]{listener});
            eventListenerRegistry.appendListeners(EventType.PRE_UPDATE, (Object[])new PreUpdateEventListener[]{listener});
            eventListenerRegistry.appendListeners(EventType.PRE_DELETE, (Object[])new PreDeleteEventListener[]{listener});
            eventListenerRegistry.appendListeners(EventType.POST_INSERT, (Object[])new PostInsertEventListener[]{listener});
            eventListenerRegistry.appendListeners(EventType.POST_LOAD, (Object[])new PostLoadEventListener[]{listener});
            eventListenerRegistry.appendListeners(EventType.POST_UPDATE, (Object[])new PostUpdateEventListener[]{listener});
            eventListenerRegistry.appendListeners(EventType.POST_DELETE, (Object[])new PostDeleteEventListener[]{listener});
            eventListenerRegistry.prependListeners(EventType.SAVE_UPDATE, (Object[])new SaveOrUpdateEventListener[]{listener});
        }
        return this.hibernateSessionFactory;
    }

    public SessionFactory newSessionFactory(Configuration effectiveHibernateConfiguration) {
        SessionFactory hibernateSessionFactory = TopiaUtil.newSessionFactory(effectiveHibernateConfiguration);
        EventListenerRegistry eventListenerRegistry = HibernateProvider.getHibernateService(hibernateSessionFactory, EventListenerRegistry.class);
        TopiaHibernateEventListener listener = new TopiaHibernateEventListener(this.sessionRegistry);
        eventListenerRegistry.appendListeners(EventType.PRE_INSERT, (Object[])new PreInsertEventListener[]{listener});
        eventListenerRegistry.appendListeners(EventType.PRE_LOAD, (Object[])new PreLoadEventListener[]{listener});
        eventListenerRegistry.appendListeners(EventType.PRE_UPDATE, (Object[])new PreUpdateEventListener[]{listener});
        eventListenerRegistry.appendListeners(EventType.PRE_DELETE, (Object[])new PreDeleteEventListener[]{listener});
        eventListenerRegistry.appendListeners(EventType.POST_INSERT, (Object[])new PostInsertEventListener[]{listener});
        eventListenerRegistry.appendListeners(EventType.POST_LOAD, (Object[])new PostLoadEventListener[]{listener});
        eventListenerRegistry.appendListeners(EventType.POST_UPDATE, (Object[])new PostUpdateEventListener[]{listener});
        eventListenerRegistry.appendListeners(EventType.POST_DELETE, (Object[])new PostDeleteEventListener[]{listener});
        eventListenerRegistry.prependListeners(EventType.SAVE_UPDATE, (Object[])new SaveOrUpdateEventListener[]{listener});
        return hibernateSessionFactory;
    }

    public Metadata getMetaData() {
        if (this.metaData == null) {
            this.metaData = this.newMetaData(this.getHibernateConfiguration(), this.getSessionFactory());
        }
        return this.metaData;
    }

    public Metadata newMetaData(Configuration configuration, SessionFactory sessionFactory) {
        return this.newMetaData(configuration, sessionFactory, this.persistenceClasses);
    }

    public Metadata newMetaData(Configuration configuration, SessionFactory sessionFactory, Collection<Class<?>> persistenceClasses) {
        StandardServiceRegistry standardServiceRegistry = HibernateProvider.getStandardServiceRegistry(sessionFactory);
        MetadataSources sources = new MetadataSources((ServiceRegistry)standardServiceRegistry);
        for (Class<?> persistanceClass : persistenceClasses) {
            String hbmXmlFile = persistanceClass.getName().replace('.', '/') + ".hbm.xml";
            sources.addResource(hbmXmlFile);
            configuration.addClass(persistanceClass);
        }
        MetadataBuilder metadataBuilder = sources.getMetadataBuilder();
        return metadataBuilder.build();
    }
}

