package org.nuiton.topia;

/*
 * #%L
 * ToPIA :: Persistence
 * $Id: TopiaPersistenceContext.java 2849 2013-10-25 22:18:09Z athimel $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-3.0-alpha-5/topia-persistence/src/main/java/org/nuiton/topia/TopiaPersistenceContext.java $
 * %%
 * Copyright (C) 2004 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaIdFactory;

/**
 * This API provides all methods related to persistence :
 * <ul>
 * <li>Generic entity find</li>
 * <li>DAO factory</li>
 * <li>Schema management</li>
 * </ul>
 *
 * @author Arnaud Thimel <thimel@codelutin.com>
 * @since 3.0
 */
public interface TopiaPersistenceContext extends TopiaReplicationSupport, TopiaReplicationDestination,
        TopiaDaoSupplier, TopiaTransaction {

    /**
     * Retrieve {@link org.nuiton.topia.persistence.TopiaEntity} using its unique {@code topiaId}.
     *
     * @param topiaId unique identifier of the entity in all the application.
     * @return the entity found or null
     */
    <E extends TopiaEntity> E findByTopiaId(String topiaId);

    /**
     * Add into this TopiaContext an entity created by another TopiaContext
     *
     * @param entity the entity to add
     */
    void update(TopiaEntity entity);

    /**
     * Get the currently configured {@link TopiaIdFactory}.
     *
     * @return the {@link TopiaIdFactory} in use
     * @see {@link TopiaIdFactory}
     * @since 3.0
     */
    TopiaIdFactory getTopiaIdFactory();

    /**
     * Closes the context. All the children contexts will be closed in the same
     * time.
     */
    void closeContext();

    /**
     * Tells if the context is closed
     *
     * @return {@code true} if the context is closed, {@code false} otherwise
     */
    boolean isClosed();

}
