package org.nuiton.topia;

/*
 * #%L
 * ToPIA :: Persistence
 * $Id: QueryMissingOrderException.java 2878 2013-11-22 16:17:05Z athimel $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-3.0-alpha-5/topia-persistence/src/main/java/org/nuiton/topia/QueryMissingOrderException.java $
 * %%
 * Copyright (C) 2004 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.util.Map;

/**
 * If you get this exception, it means that you asked topia
 * to make an operation that need a deterministic way to sort the
 * result but you didn't defined such query.
 *
 * To fix you issue, you may use another API call (maybe user findAny instead
 * of findFirst) or change your query by adding an order by clause. A quick and
 * easy fix would be to just use "order by topiaId".
 *
 * @since 3.0
 */
public class QueryMissingOrderException extends TopiaQueryException {

    protected static final String MESSAGE = "given query needs an order by clause since the API call you use need the results sorting to be deterministic";

    public QueryMissingOrderException(String hql, Map<String, Object> hqlParameters) {
        super(MESSAGE, hql, hqlParameters);
    }

}
