/*
 * #%L
 * ToPIA :: Persistence
 * 
 * $Id: TopiaContext.java 2790 2013-08-05 08:49:05Z athimel $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-3.0-alpha-3.1/topia-persistence/src/main/java/org/nuiton/topia/TopiaContext.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.topia;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;

import org.nuiton.topia.event.TopiaContextListener;
import org.nuiton.topia.event.TopiaEntitiesVetoable;
import org.nuiton.topia.event.TopiaEntityListener;
import org.nuiton.topia.event.TopiaEntityVetoable;
import org.nuiton.topia.event.TopiaTransactionListener;
import org.nuiton.topia.event.TopiaTransactionVetoable;
import org.nuiton.topia.framework.TopiaService;
import org.nuiton.topia.persistence.TopiaEntity;

/**
 * The TopiaContext is the most important class of ToPIA. It contains all the
 * methods to manipulate data : transaction management, entities querying, event
 * firing, schema management, services management, ...
 * <p/>
 * To get an instance of TopiaContext, see {@link TopiaContextFactory#getContext(java.util.Properties)}
 * <p/>
 * <p/>
 * Created: 3 janv. 2006 21:18:34
 *
 * @author poussin <poussin@codelutin.com>
 * @author tchemit <tchemit@codelutin.com>
 * @author athimel <thimel@codelutin.com>
 * @version $Id: TopiaContext.java 2790 2013-08-05 08:49:05Z athimel $
 */
public interface TopiaContext extends TopiaTransaction, TopiaListenableSupport, TopiaSqlSupport, TopiaJpaSupport,
        TopiaPersistenceContext, TopiaServiceSupport, TopiaReplicationSupport, TopiaHibernateSupport {

    /* -------------------- TRANSACTION MANAGEMENT --------------------------*/

    /**
     * Returns a new context containing its own transaction.
     *
     * @return new context with transaction
     * @throws TopiaException if any exception
     * @deprecated we need another method that returns a {@link TopiaTransaction} only. This method doesn't exist yet
     */
    @Deprecated
    TopiaContext beginTransaction() throws TopiaException;

    // TODO AThimel 03/08/13 We need another API to obtain a TopiaTransaction
    // TODO AThimel 03/08/13 This new method has to be located somewhere else (TopiaTransactionSupplier ? TopiaTransactionSupport ? or just TopiaPersistenceContext ?)

    /**
     * Applies all the modifications made to this context on the persistence
     * device. Once commit is done, a new transaction is started.
     *
     * @throws TopiaException if any exception
     * @deprecated use method from {@link TopiaTransaction}
     */
    @Deprecated
    void commitTransaction() throws TopiaException;

    /**
     * Cancels all the modifications made to this context, coming back to the
     * state on the last beginTransaction. Once rollback is done, a new
     * transaction is started.
     *
     * @throws TopiaException if any exception
     * @deprecated use method from {@link TopiaTransaction}
     */
    @Deprecated
    void rollbackTransaction() throws TopiaException;

    /**
     * Closes the context. All the children contexts will be closed in the same
     * time.
     *
     * @throws TopiaException if any exception
     * @deprecated use method from {@link TopiaTransaction}
     */
    @Deprecated
    void closeContext() throws TopiaException;

    /**
     * Tells if the context is closed
     *
     * @return {@code true} if the context is closed, {@code false} otherwise
     * @deprecated use method from {@link TopiaTransaction}
     */
    @Deprecated
    boolean isClosed();

    /* ------------------------ EVENT FIRING --------------------------*/

    /* TopiaEntityListener */

    /**
     * Register to the context a TopiaEntityListener about any TopiaEntity.
     * <code>listener</code> instance will be notified AFTER any operation on
     * the entity.
     *
     * @param listener the listener instance to register
     * @deprecated use method from {@link TopiaListenableSupport}
     */
    @Deprecated
    void addTopiaEntityListener(TopiaEntityListener listener);

    /**
     * Register to the context a TopiaEntityListener about the given entity
     * class. <code>listener</code> instance will be notified AFTER any
     * operation on the entity.
     *
     * @param entityClass the TopiaEntity's class to listen
     * @param listener    the listener instance to register
     * @deprecated use method from {@link TopiaListenableSupport}
     */
    @Deprecated
    void addTopiaEntityListener(Class<? extends TopiaEntity> entityClass,
                                TopiaEntityListener listener);

    /**
     * Unregister the given TopiaEntityListener about any TopiaEntity from the
     * context
     *
     * @param listener the listener instance to unregister
     * @deprecated use method from {@link TopiaListenableSupport}
     */
    @Deprecated
    void removeTopiaEntityListener(TopiaEntityListener listener);

    /**
     * Unregister the given TopiaEntityListener about the given entity class
     * from the context
     *
     * @param entityClass the listened TopiaEntity's class
     * @param listener    the listener instance to unregister
     * @deprecated use method from {@link TopiaListenableSupport}
     */
    @Deprecated
    void removeTopiaEntityListener(Class<? extends TopiaEntity> entityClass,
                                   TopiaEntityListener listener);


    /* TopiaEntityVetoable */

    /**
     * Register to the context a TopiaEntityVetoable about any TopiaEntity.
     * <code>vetoable</code> instance will be notified BEFORE any operation on
     * the entity.
     *
     * @param vetoable the vetoable instance to register
     * @deprecated use method from {@link TopiaListenableSupport}
     */
    @Deprecated
    void addTopiaEntityVetoable(TopiaEntityVetoable vetoable);

    /**
     * Register to the context a TopiaEntityVetoable about the given entity
     * class. <code>vetoable</code> instance will be notified BEFORE any
     * operation on the entity.
     *
     * @param entityClass the TopiaEntity's class to listen
     * @param vetoable    the vetoable instance to register
     * @deprecated use method from {@link TopiaListenableSupport}
     */
    @Deprecated
    void addTopiaEntityVetoable(Class<? extends TopiaEntity> entityClass,
                                TopiaEntityVetoable vetoable);

    /**
     * Unregister the given TopiaEntityVetoable about any TopiaEntity from the
     * context
     *
     * @param vetoable the vetoable instance to unregister
     * @deprecated use method from {@link TopiaListenableSupport}
     */
    @Deprecated
    void removeTopiaEntityVetoable(TopiaEntityVetoable vetoable);

    /**
     * Unregister the given TopiaEntityVetoable about the given entity class
     * from the context
     *
     * @param entityClass the listened TopiaEntity's class
     * @param vetoable    the vetoable instance to unregister
     * @deprecated use method from {@link TopiaListenableSupport}
     */
    @Deprecated
    void removeTopiaEntityVetoable(Class<? extends TopiaEntity> entityClass,
                                   TopiaEntityVetoable vetoable);


    /* TopiaEntitiesVetoable */

    /**
     * Register to the context a TopiaEntitiesVetoable about any TopiaEntity.
     * <code>vetoable</code> instance will be notified BEFORE any entity load
     *
     * @param vetoable the vetoable instance to register
     * @deprecated use method from {@link TopiaListenableSupport}
     */
    @Deprecated
    void addTopiaEntitiesVetoable(TopiaEntitiesVetoable vetoable);

    /**
     * Unregister the given TopiaEntitiesVetoable about any TopiaEntity from the
     * context
     *
     * @param vetoable the vetoable instance to unregister
     * @deprecated use method from {@link TopiaListenableSupport}
     */
    @Deprecated
    void removeTopiaEntitiesVetoable(TopiaEntitiesVetoable vetoable);


    /* TopiaTransactionListener */

    /**
     * Register to the context a TopiaTransactionListener about the transaction.
     * <code>listener</code> instance will be notified AFTER any operation on
     * the transaction.
     *
     * @param listener the listener instance to register
     * @deprecated use method from {@link TopiaListenableSupport}
     */
    @Deprecated
    void addTopiaTransactionListener(TopiaTransactionListener listener);

    /**
     * Unregister the given TopiaTransactionListener about the transaction from
     * the context
     *
     * @param listener the listener instance to unregister
     * @deprecated use method from {@link TopiaListenableSupport}
     */
    @Deprecated
    void removeTopiaTransactionListener(TopiaTransactionListener listener);


    /* TopiaTransactionVetoable */

    /**
     * Register to the context a TopiaTransactionVetoable about the transaction.
     * <code>vetoable</code> instance will be notified BEFORE any operation on
     * the transaction.
     *
     * @param vetoable the vetoable instance to register
     * @deprecated use method from {@link TopiaListenableSupport}
     */
    @Deprecated
    void addTopiaTransactionVetoable(TopiaTransactionVetoable vetoable);

    /**
     * Unregister the given TopiaTransactionVetoable about the transaction from
     * the context
     *
     * @param vetoable the vetoable instance to unregister
     * @deprecated use method from {@link TopiaListenableSupport}
     */
    @Deprecated
    void removeTopiaTransactionVetoable(TopiaTransactionVetoable vetoable);


    /* PropertyChangeListener */

    /**
     * Register to the context a PropertyChangeListener about some entity's
     * property change. <code>listener</code> instance will be notified AFTER
     * any change on the entity's property
     *
     * @param listener the listener instance to register
     * @deprecated use method from {@link TopiaListenableSupport}
     */
    @Deprecated
    void addPropertyChangeListener(PropertyChangeListener listener);

    /**
     * Unregister the given PropertyChangeListener about some entity's
     * property change from the context
     *
     * @param listener the listener instance to unregister
     * @deprecated use method from {@link TopiaListenableSupport}
     */
    @Deprecated
    void removePropertyChangeListener(PropertyChangeListener listener);


    /* TopiaContextListener */

    /**
     * Register to the context a TopiaContextListener about any schema
     * modification. <code>listener</code> instance will be notified BEFORE and
     * AFTER any change on the schema
     *
     * @param listener the listener instance to register
     * @deprecated Use addTopiaSchemaListener
     */
    @Deprecated
    void addTopiaContextListener(TopiaContextListener listener);

    /**
     * Unregister the given TopiaContextListener about any schema modification
     * from the context
     *
     * @param listener the listener instance to unregister
     * @deprecated Use removeTopiaSchemaListener
     */
    @Deprecated
    void removeTopiaContextListener(TopiaContextListener listener);

    /* -------------------- GLOBAL OPERATIONS ON ENTITIES --------------------*/

    /**
     * Retrieve {@link TopiaEntity} using its unique {@code id}.
     *
     * @param topiaId unique identifier of the entity in all the application.
     * @return the entity found or null
     * @throws TopiaException for errors on retrieving the entity
     * @deprecated use {@link TopiaPersistenceContext#findByTopiaId(String)}
     */
    @Deprecated
    <E extends TopiaEntity> E findByTopiaId(String topiaId) throws TopiaException;

    /**
     * Add into this TopiaContext an entity created by another TopiaContext
     *
     * @param e the entity to add
     * @throws TopiaException if any exception
     * @deprecated use {@link TopiaPersistenceContext#update(org.nuiton.topia.persistence.TopiaEntity)}
     */
    @Deprecated
    void add(TopiaEntity e) throws TopiaException;

    /**
     * Clear persistence implementation cache.
     *
     * @since 2.6.13
     * @deprecated use {@link TopiaHibernateSupport#getHibernateSession().clear()}
     */
    @Deprecated
    void clearCache() throws TopiaException;

    /**
     * Allow to do some HQL query
     * <p/>
     * WARNING : Depending on the registered service, this method may not
     * support something else than queries on TopiaEntity
     *
     * @param hql                    the HQL query
     * @param propertyNamesAndValues the query parameters. Arguments are key-value paired :
     *                               [propertyName;value;propertyName;value;...]
     * @return The result list
     * @throws TopiaException for any error during querying
     * @deprecated use method from {@link TopiaJpaSupport}
     */
    @Deprecated
    <E> List<E> findAll(String hql,
                        Object... propertyNamesAndValues) throws TopiaException;

    /**
     * Allow to do some JPA-QL query using the given bounds.
     * <p/>
     * No lower bound : <code>startIndex</code> = 0.<br/>
     * No upper bound : <code>endIndex</code> = -1.
     * <p/>
     * WARNING : Depending on the registered service, this method may not
     * support something else than queries on TopiaEntity
     *
     * @param hql                    the HQL query
     * @param startIndex             first index of entity to return
     * @param endIndex               last index of entity to return
     * @param propertyNamesAndValues the query parameters. Arguments are key-value paired :
     *                               [propertyName;value;propertyName;value;...]
     * @return The result list
     * @throws TopiaException for any error during querying
     * @deprecated use method from {@link TopiaJpaSupport}
     */
    @Deprecated
    <E> List<E> find(String hql,
                     int startIndex,
                     int endIndex,
                     Object... propertyNamesAndValues) throws TopiaException;

    /**
     * Allow to do some HQL query and return an unique result. If nothing if
     * found by the query, will return null. If more than one result is found,
     * will throw an exception.
     * <p/>
     * WARNING : Depending on the registered service, this method may not
     * support something else than queries on TopiaEntity
     *
     * @param hql                    the HQL query
     * @param propertyNamesAndValues the query parameters. Arguments are key-value paired :
     *                               [propertyName;value;propertyName;value;...]
     * @return The result instance or null
     * @throws TopiaException for any error during querying or if the the query
     *                        returns more than one result.
     * @deprecated use method from {@link TopiaJpaSupport}
     */
    @Deprecated
    <E> E findUnique(String hql,
                     Object... propertyNamesAndValues) throws TopiaException;

    /**
     * Execute HQL operation on data (Update, Delete).
     *
     * @param hql                    the HQL query
     * @param propertyNamesAndValues the query parameters. Arguments are key-value paired :
     *                               [propertyName;value;propertyName;value;...]
     * @return The number of entities updated or deleted.
     * @throws TopiaException if any exception
     * @deprecated use method from {@link TopiaJpaSupport}
     */
    @Deprecated
    int execute(String hql,
                Object... propertyNamesAndValues) throws TopiaException;

    /**
     * Execute a given sql code inside this transaction.
     *
     * @param sqlScript the sql script to execute
     * @throws TopiaException if any problem occurred while executing the sql script.
     * @deprecated use method from {@link TopiaSqlSupport}
     */
    @Deprecated
    void executeSQL(String sqlScript) throws TopiaException;

    /* -------------------- SCHEMA MANAGMENT  -----------------------------*/

    /**
     * Triggers database schema creation
     *
     * @throws TopiaException if any exception
     * @deprecated use methods from {@link TopiaPersistenceContext}
     */
    @Deprecated
    void createSchema() throws TopiaException;

    /**
     * Displays the SQL queries that would be used for a schema creation
     *
     * @throws TopiaException if any exception
     * @deprecated use methods from {@link TopiaPersistenceContext}
     */
    @Deprecated
    void showCreateSchema() throws TopiaException;

    /**
     * Triggers database schema update
     *
     * @throws TopiaException if any exception
     * @deprecated use methods from {@link TopiaPersistenceContext}
     */
    @Deprecated
    void updateSchema() throws TopiaException;

    /* -------------------- SERVICES MANAGMENT -------------------------------*/

    /**
     * Return true if specific service is available.
     *
     * @param <E>              type of service
     * @param interfaceService fqn of the service
     * @return the service
     * @deprecated use methods from {@link TopiaServiceSupport}
     */
    @Deprecated
    <E extends TopiaService> boolean serviceEnabled(Class<E> interfaceService);

    /**
     * Return the service. This service must be valid with public static final
     * SERVICE_NAME property.
     *
     * @param <E>              type of service
     * @param interfaceService class of the service
     * @return the service
     * @throws TopiaNotFoundException if service can't be retrieved
     * @deprecated use methods from {@link TopiaServiceSupport}
     */
    @Deprecated
    <E extends TopiaService> E getService(Class<E> interfaceService) throws TopiaNotFoundException;

    /* ------------------ IMPORT / EXPORT / REPLICATION ---------------------*/

    /**
     * Makes a replication of some entities from this context to the given
     * context without any entity modification.
     * <p/>
     * <b>Note:</b> If the <code>entityAndCondition</code> parameter is empty,
     * all the database will be replicated
     * <p/>
     * <b>Note 2:</b> The simple replication may not be sufficent. You may want
     * to replicate only a part of some entities : use the method {@link
     * #replicateEntities(TopiaContext, List)}.
     *
     * @param destinationContext the destination context
     * @param entityAndCondition [key;value;...] parameter which key is the
     *                           entity class to replicate, and value the
     *                           "where" condition to use when querying entities
     * @throws TopiaException           if any problem occurred during replicate
     * @throws IllegalArgumentException if one of the context is closed or if
     *                                  trying to replicate within the same
     *                                  database
     * @deprecated use methods from {@link TopiaReplicationSupport}
     */
    @Deprecated
    void replicate(TopiaContext destinationContext,
                   Object... entityAndCondition) throws TopiaException, IllegalArgumentException;

    /**
     * Replicate a given entity from this context to the given context.
     *
     * @param destinationContext the destination context
     * @param entity             the entity instance to replicate
     * @param <T>                type of the entity to replicate
     * @throws TopiaException           if any problem occurred during replicate
     * @throws IllegalArgumentException if one of the context is closed or if
     *                                  trying to replicate within the same
     *                                  database
     * @deprecated use methods from {@link TopiaReplicationSupport}
     */
    @Deprecated
    <T extends TopiaEntity> void replicateEntity(TopiaContext destinationContext,
                                                 T entity) throws TopiaException, IllegalArgumentException;

    /**
     * Makes a replication of some entities from this context to the given
     * context without any entity modification.
     *
     * @param destinationContext the destination context
     * @param entities           the list of entities instance to replicate
     * @param <T>                type of the entities to replicate
     * @throws TopiaException           if any problem occurred during replicate
     * @throws IllegalArgumentException if one of the context is closed or if
     *                                  trying to replicate within the same
     *                                  database
     * @deprecated use methods from {@link TopiaReplicationSupport}
     */
    @Deprecated
    <T extends TopiaEntity> void replicateEntities(TopiaContext destinationContext,
                                                   List<T> entities) throws TopiaException, IllegalArgumentException;

    /* ------------------ H2 specific methods ---------------------*/

    /**
     * Sauve la base de données dans un format natif a la base, la
     * representation n'est pas portable d'une base a l'autre. Cette methode ne
     * doit être utilisé que pour un stockage temporaire utile à une
     * application.
     *
     * @param file     le nom du fichier ou stocker les informations
     * @param compress si vrai compress le fichier avec gzip
     * @throws TopiaException if any exception
     * @deprecated Only H2 compatible : remove it, or move to another class
     */
    @Deprecated
    void backup(File file,
                boolean compress) throws TopiaException;

    /**
     * l'inverse de la methode {@link #backup(File, boolean)}.
     *
     * @param file le fichier ou prendre les informations, il peut-etre
     *             compressé avec gzip ou non.
     * @throws TopiaException if any exception
     * @deprecated Only H2 compatible : remove it, or move to another class
     */
    @Deprecated
    void restore(File file) throws TopiaException;


    /**
     * Supprime toutes les tables et autres elements de la database.
     *
     * @param dropDatabase si vrai alors supprime aussi la base de données si la
     *                     base utilise des fichiers les fichiers seront
     *                     supprimé (ex: h2) ou sera fait sur la base
     *                     (postgresql)
     * @throws TopiaException if any exception
     * @deprecated Only H2 compatible : remove it, or move to another class
     */
    @Deprecated
    void clear(boolean dropDatabase) throws TopiaException;

} //TopiaContext
