/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;
import org.nuiton.topia.TestHelper;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaTestDAOHelper;
import org.nuiton.topia.framework.TopiaUtilTest;
import org.nuiton.topia.test.entities.Person;
import org.nuiton.topia.test.entities.PersonDAO;

public class TopiaDAOTest {
    private static final Log log = LogFactory.getLog(TopiaUtilTest.class);
    protected static File testBasedir;

    @BeforeClass
    public static void setUpClass() throws Exception {
        testBasedir = TestHelper.getTestBasedir(TopiaDAOTest.class);
    }

    @Test
    public void testCreateAndFindInTransaction() throws TopiaException, IOException {
        TopiaContext rootContext = TestHelper.initTopiaContext(testBasedir, "/TopiaContextImpl.properties", "testCreateAndFindInTransaction");
        TopiaContext context = rootContext.beginTransaction();
        PersonDAO personDAO = TopiaTestDAOHelper.getPersonDAO(context);
        Person person = (Person)personDAO.create(new Object[0]);
        person.setName("toto");
        List allPerson = personDAO.findAll();
        Assert.assertEquals((long)1L, (long)allPerson.size());
        context.commitTransaction();
        Person person2 = (Person)personDAO.create(new Object[0]);
        person2.setName("titi");
        allPerson = personDAO.findAll();
        Assert.assertEquals((long)2L, (long)allPerson.size());
        Assert.assertThat((Object)allPerson, (Matcher)JUnitMatchers.hasItem((Object)person2));
        context.rollbackTransaction();
        Person person3 = (Person)personDAO.create(new Object[0]);
        person3.setName("tata");
        allPerson = personDAO.findAll();
        Assert.assertEquals((long)2L, (long)allPerson.size());
        Assert.assertThat((Object)allPerson, (Matcher)JUnitMatchers.hasItem((Object)person3));
        context.commitTransaction();
        rootContext.closeContext();
    }
}

