/*
 * #%L
 * ToPIA :: Persistence
 * 
 * $Id: NaturalIdTest.java 2245 2011-04-14 12:47:09Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-2.6.7/topia-persistence/src/test/java/org/nuiton/topia/persistence/NaturalIdTest.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.topia.persistence;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.PropertyValueException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.nuiton.topia.TestHelper;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaNotFoundException;
import org.nuiton.topia.TopiaTestDAOHelper;
import org.nuiton.topiatest.NaturalizedEntity;
import org.nuiton.topiatest.NaturalizedEntityDAO;

import java.io.File;
import java.io.IOException;

/**
 * NaturalIdTest
 * <p/>
 * Created: 18 févr. 2010
 *
 * @author fdesbois
 * @version $Revision: 2245 $
 *          <p/>
 *          Mise a jour: $Date: 2011-04-14 14:47:09 +0200 (Thu, 14 Apr 2011) $
 *          par : $Author: tchemit $
 */
public class NaturalIdTest {

    private static final Log log = LogFactory.getLog(NaturalIdTest.class);

    protected static File testBasedir;

    @BeforeClass
    public static void setUpClass() throws Exception {

        testBasedir = TestHelper.getTestBasedir(NaturalIdTest.class);
    }

    protected TopiaContext initTopiaContext(String testName) throws IOException, TopiaNotFoundException {
        TopiaContext root = TestHelper.initTopiaContext(testBasedir,
                                                        "/TopiaContextImpl.properties",
                                                        testName);
        return root;
    }

    @Test
    public void testCreateSucessfull() throws Exception {
        log.debug("Test naturalId : create succesfull");
        TopiaContext root = initTopiaContext("createSucessfull");
        TopiaContext transaction = root.beginTransaction();

        NaturalizedEntityDAO dao =
                TopiaTestDAOHelper.getNaturalizedEntityDAO(transaction);

        // No exception will be thrown with the two properties
        dao.create(NaturalizedEntity.PROPERTY_NATURAL_ID_NOT_NULL, 5,
                   NaturalizedEntity.PROPERTY_NATURAL_ID_NULL, "str");
        transaction.commitTransaction();

        // No exception will only the need property
        dao.create(NaturalizedEntity.PROPERTY_NATURAL_ID_NOT_NULL, 3);
        transaction.commitTransaction();

        transaction.closeContext();
        root.closeContext();
    }

    @Test
    public void testCreateFailed() throws Exception {
        log.debug("Test naturalId : create failed");
        TopiaContext root = initTopiaContext("createFailed");
        TopiaContext transaction = root.beginTransaction();

        NaturalizedEntityDAO dao =
                TopiaTestDAOHelper.getNaturalizedEntityDAO(transaction);

        // Exception will be throw
        try {
            dao.create();
            transaction.commitTransaction();

            // Note : this is possible to create an empty entity if the type
            // is primitive like 'int' which have a default value of '0'
        } catch (PropertyValueException eee) {
            Assert.assertEquals("naturalIdNotNull", eee.getPropertyName());
        }

        transaction.closeContext();
        root.closeContext();
    }

    @Test
    public void testUpdateFailed() throws Exception {
        log.debug("Test naturalId : update failed");
        TopiaContext root = initTopiaContext("updateFailed");

        TopiaContext transaction = root.beginTransaction();

        NaturalizedEntityDAO dao =
                TopiaTestDAOHelper.getNaturalizedEntityDAO(transaction);

        NaturalizedEntity entity =
                dao.create(NaturalizedEntity.PROPERTY_NATURAL_ID_NOT_NULL, 5,
                           NaturalizedEntity.PROPERTY_NATURAL_ID_NULL, "str");
        transaction.commitTransaction();

        // Exception will be throw : not allowed to modify a naturalId property
        try {
            entity.setNaturalIdNotNull(8);
            transaction.commitTransaction();
        } catch (TopiaException eee) {
            Assert.assertEquals("org.hibernate.HibernateException",
                                eee.getCause().getClass().getName());
        } finally {
            transaction.closeContext();
            root.closeContext();
        }
    }

    @Test
    public void testFindByNaturalId() throws Exception {
        log.debug("Test naturalId : findByNaturalId");
        TopiaContext root = initTopiaContext("findByNaturalId");
        TopiaContext transaction = root.beginTransaction();

        NaturalizedEntityDAO dao =
                TopiaTestDAOHelper.getNaturalizedEntityDAO(transaction);

        NaturalizedEntity entity =
                dao.create(NaturalizedEntity.PROPERTY_NATURAL_ID_NOT_NULL, 5,
                           NaturalizedEntity.PROPERTY_NATURAL_ID_NULL, "str");
        transaction.commitTransaction();

        NaturalizedEntity result = dao.findByNaturalId(5, "str");

        Assert.assertEquals(entity, result);

        transaction.closeContext();
        root.closeContext();
    }

    @Test
    public void testExistNaturalId() throws Exception {
        log.debug("Test naturalId : existNaturalId");
        TopiaContext root = initTopiaContext("existNaturalId");
        TopiaContext transaction = root.beginTransaction();

        NaturalizedEntityDAO dao =
                TopiaTestDAOHelper.getNaturalizedEntityDAO(transaction);

        dao.create(NaturalizedEntity.PROPERTY_NATURAL_ID_NOT_NULL, 5,
                   NaturalizedEntity.PROPERTY_NATURAL_ID_NULL, "str");
        transaction.commitTransaction();

        boolean result = dao.existByNaturalId(5, "str");

        Assert.assertTrue(result);

        // not find with only one correct property
        result = dao.existByNaturalId(8, "str");

        Assert.assertFalse(result);

        transaction.closeContext();
        root.closeContext();
    }
}
