package org.nuiton.topiatest;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import org.apache.commons.lang.builder.ToStringBuilder;

public class EmployeDTO extends PersonneDTO implements Serializable {

    public int salary;

    protected final PropertyChangeSupport p = new PropertyChangeSupport(this);

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        p.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        p.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        p.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        p.removePropertyChangeListener(propertyName, listener);
    }

    public void setSalary(int value) {
        int oldValue = this.salary;
        this.salary = value;
        p.firePropertyChange("salary", oldValue, value);
    }

    public int getSalary() {
        return salary;
    }

    public String toString() {
        String result = new ToStringBuilder(this).
            append("salary", this.salary).
         toString();
        return result;
}

} //EmployeDTO
