package org.nuiton.topiatest;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;

public  abstract class EmployeAbstract extends PersonneImpl implements Employe {

    /**
     * Nom de l'attribut en BD : salary

     */
    protected int salary;
    private static final long serialVersionUID = 7363497963508294753L;

static {
    
        I18n.n_("topia.test.common.employe");
        I18n.n_("topia.test.common.salary");
    }
     /**
      * accept :
      * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
      * @param visitor le visiteur de l'entite.
      * @throws TopiaException
      */
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_SALARY, int.class, salary);
        visitor.end(this);
}

     /**
      * setSalary :
      * @param salary 
      */

    @Override    public void setSalary(int salary) {
        int oldValue = this.salary;
        fireOnPreWrite(PROPERTY_SALARY, oldValue, salary);
        this.salary = salary;
        fireOnPostWrite(PROPERTY_SALARY, oldValue, salary);
}

     /**
      * getSalary :
      * @return int 
      */

    @Override    public int getSalary() {
        fireOnPreRead(PROPERTY_SALARY, salary);
        int result = this.salary;
        fireOnPostRead(PROPERTY_SALARY, salary);
        return result;
}

     /**
      * getAggregate :
      * @return List<TopiaEntity> 
      * @throws TopiaException
      */

    @Override    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

     /**
      * getComposite :
      * @return List<TopiaEntity> 
      * @throws TopiaException
      */

    @Override    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
    }

     /**
      * toString :
      * @return String 
      */

    @Override    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_SALARY, this.salary).
         toString();
        return result;
}


} //EmployeAbstract
