package org.nuiton.topiatest;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public  abstract class BillAbstract extends TopiaEntityAbstract implements Bill {

    /**
     * Nom de l'attribut en BD : cost

     */
    protected int cost;
    /**
     * Nom de l'attribut en BD : date

     */
    protected Date date;
    /**
     * Nom de l'attribut en BD : paid

     */
    protected Boolean paid;
    /**
     * Nom de l'attribut en BD : store

     */
    protected Store store;
    /**
     * Nom de l'attribut en BD : company

     */
    protected Company company;
static {
    
        I18n.n_("topia.test.common.bill");
        I18n.n_("topia.test.common.cost");
        I18n.n_("topia.test.common.date");
        I18n.n_("topia.test.common.paid");
    }
    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_COST, int.class, cost);
        visitor.visit(this, PROPERTY_DATE, Date.class, date);
        visitor.visit(this, PROPERTY_PAID, Boolean.class, paid);
        visitor.visit(this, PROPERTY_STORE, Store.class, store);
        visitor.visit(this, PROPERTY_COMPANY, Company.class, company);
        visitor.end(this);
}

    /**
     * setCost :
     * @param cost 
     */

    @Override
    public void setCost(int cost) {
        int oldValue = this.cost;
        fireOnPreWrite(PROPERTY_COST, oldValue, cost);
        this.cost = cost;
        fireOnPostWrite(PROPERTY_COST, oldValue, cost);
}

    /**
     * getCost :
     * @return int 
     */

    @Override
    public int getCost() {
        fireOnPreRead(PROPERTY_COST, cost);
        int result = this.cost;
        fireOnPostRead(PROPERTY_COST, cost);
        return result;
}

    /**
     * setDate :
     * @param date 
     */

    @Override
    public void setDate(Date date) {
        Date oldValue = this.date;
        fireOnPreWrite(PROPERTY_DATE, oldValue, date);
        this.date = date;
        fireOnPostWrite(PROPERTY_DATE, oldValue, date);
}

    /**
     * getDate :
     * @return Date 
     */

    @Override
    public Date getDate() {
        fireOnPreRead(PROPERTY_DATE, date);
        Date result = this.date;
        fireOnPostRead(PROPERTY_DATE, date);
        return result;
}

    /**
     * setPaid :
     * @param paid 
     */

    @Override
    public void setPaid(Boolean paid) {
        Boolean oldValue = this.paid;
        fireOnPreWrite(PROPERTY_PAID, oldValue, paid);
        this.paid = paid;
        fireOnPostWrite(PROPERTY_PAID, oldValue, paid);
}

    /**
     * getPaid :
     * @return Boolean 
     */

    @Override
    public Boolean getPaid() {
        fireOnPreRead(PROPERTY_PAID, paid);
        Boolean result = this.paid;
        fireOnPostRead(PROPERTY_PAID, paid);
        return result;
}

    /**
     * isPaid :
     * @return Boolean 
     */

    @Override
    public Boolean isPaid() {
        fireOnPreRead(PROPERTY_PAID, paid);
        Boolean result = this.paid;
        fireOnPostRead(PROPERTY_PAID, paid);
        return result;
}

    /**
     * setStore :
     * @param store 
     */

    @Override
    public void setStore(Store store) {
        Store oldValue = this.store;
        fireOnPreWrite(PROPERTY_STORE, oldValue, store);
        this.store = store;
        fireOnPostWrite(PROPERTY_STORE, oldValue, store);
}

    /**
     * getStore :
     * @return Store 
     */

    @Override
    public Store getStore() {
        fireOnPreRead(PROPERTY_STORE, store);
        Store result = this.store;
        fireOnPostRead(PROPERTY_STORE, store);
        return result;
}

    /**
     * setCompany :
     * @param company 
     */

    @Override
    public void setCompany(Company company) {
        Company oldValue = this.company;
        fireOnPreWrite(PROPERTY_COMPANY, oldValue, company);
        this.company = company;
        fireOnPostWrite(PROPERTY_COMPANY, oldValue, company);
}

    /**
     * getCompany :
     * @return Company 
     */

    @Override
    public Company getCompany() {
        fireOnPreRead(PROPERTY_COMPANY, company);
        Company result = this.company;
        fireOnPostRead(PROPERTY_COMPANY, company);
        return result;
}

    /**
     * getAggregate :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
    }

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_COST, this.cost).
            append(PROPERTY_DATE, this.date).
            append(PROPERTY_PAID, this.paid).
         toString();
        return result;
}


} //BillAbstract
