/*
 * #%L
 * 
 * 
 * $Id: TopiaEntityContextable.java 2245 2011-04-14 12:47:09Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-2.5.3/topia-persistence/src/main/java/org/nuiton/topia/persistence/TopiaEntityContextable.java $
 * %%
 * Copyright (C) 2011 Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.topia.persistence;

import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

/**
 * {@link TopiaEntity} with {@link TopiaContext} support (injected by
 * {@link TopiaContext} into entities).
 * 
 * @author chatellier
 * @version $Revision: 2245 $
 * 
 * Last update : $Date: 2011-04-14 14:47:09 +0200 (Thu, 14 Apr 2011) $
 * By : $Author: tchemit $
 */
public interface TopiaEntityContextable extends TopiaEntity {

    /**
     * Set topia context.
     * 
     * @param topiaContext topia context
     * @throws TopiaException if current topia entity context is not null
     */
    public void setTopiaContext(TopiaContext topiaContext) throws TopiaException;

    /**
     * Get topia context.
     * 
     * @return topia context
     */
    public TopiaContext getTopiaContext();
    
    /**
     * Update entity in persistence context.
     * 
     * @throws TopiaException 
     */
    public void update() throws TopiaException;
    
    /**
     * Delete entity in persistence context.
     * 
     * @throws TopiaException 
     */
    public void delete() throws TopiaException;
}
