package org.nuiton.topiatest;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import org.apache.commons.lang.builder.ToStringBuilder;


public  class AddressDTO implements Serializable {

    public String city;
    public String adress;
    protected final PropertyChangeSupport p = new PropertyChangeSupport(this);
    /**
     * addPropertyChangeListener :
     * @param listener 
     */

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        p.addPropertyChangeListener(listener);
    }

    /**
     * addPropertyChangeListener :
     * @param propertyName 
     * @param listener 
     */

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        p.addPropertyChangeListener(propertyName, listener);
    }

    /**
     * removePropertyChangeListener :
     * @param listener 
     */

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        p.removePropertyChangeListener(listener);
    }

    /**
     * removePropertyChangeListener :
     * @param propertyName 
     * @param listener 
     */

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        p.removePropertyChangeListener(propertyName, listener);
    }

    /**
     * setCity :
     * @param value 
     */

    public void setCity(String value) {
        java.lang.String oldValue = this.city;
        this.city = value;
        p.firePropertyChange("city", oldValue, value);
    }

    /**
     * getCity :
     * @return String 
     */

    public String getCity() {
        return city;
    }

    /**
     * setAdress :
     * @param value 
     */

    public void setAdress(String value) {
        java.lang.String oldValue = this.adress;
        this.adress = value;
        p.firePropertyChange("adress", oldValue, value);
    }

    /**
     * getAdress :
     * @return String 
     */

    public String getAdress() {
        return adress;
    }

    /**
     * toString :
     * @return String 
     */

    public String toString() {
        String result = new ToStringBuilder(this).
            append("city", this.city).
            append("adress", this.adress).
         toString();
        return result;
}


} //AddressDTO
