/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.generator;

import java.beans.Introspector;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.Model;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAssociationClass;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelParameter;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.generator.TopiaGeneratorUtil;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

@Deprecated
public class EntityAbstractTransformer
extends ObjectModelTransformerToJava {
    private static final Log log = LogFactory.getLog(EntityAbstractTransformer.class);

    public void transformFromClass(ObjectModelClass clazz) {
        String i18nPrefix;
        String attrName;
        String svUID;
        if (!clazz.hasStereotype("entity")) {
            return;
        }
        String clazzName = clazz.getName();
        String clazzFQN = TopiaGeneratorUtil.getSimpleName((String)clazz.getQualifiedName());
        if (log.isDebugEnabled()) {
            log.debug((Object)("for entity : " + clazz.getQualifiedName()));
        }
        ObjectModelClass result = this.createAbstractClass(clazzName + "Abstract", clazz.getPackageName());
        this.addInterface((ObjectModelClassifier)result, clazzName);
        this.addImport((ObjectModelClassifier)result, ArrayList.class);
        this.addImport((ObjectModelClassifier)result, List.class);
        this.addImport((ObjectModelClassifier)result, ToStringBuilder.class);
        this.addImport((ObjectModelClassifier)result, TopiaEntity.class);
        this.addImport((ObjectModelClassifier)result, TopiaContextImplementor.class);
        String prefix = this.getConstantPrefix((ObjectModelClassifier)clazz, "");
        if (StringUtils.isEmpty((String)prefix) && log.isWarnEnabled()) {
            log.warn((Object)("[" + clazz.getName() + "] Will generate constants with NO prefix, not a good idea..."));
        }
        this.setConstantPrefix(prefix);
        StringBuilder doc = new StringBuilder();
        doc.append("Implantation POJO pour l'entit\u00e9 {@link ");
        doc.append(StringUtils.capitalize((String)clazzFQN));
        doc.append("}\n");
        String dbName = clazz.getTagValue("dbName");
        if (dbName != null) {
            doc.append("<p>Nom de l'entit\u00e9 en BD : ");
            doc.append(dbName);
            doc.append(".</p>");
        }
        this.setDocumentation((ObjectModelElement)result, doc.toString());
        for (ObjectModelClass parent : clazz.getSuperclasses()) {
            String extendClass = parent.getQualifiedName();
            boolean abstractParent = TopiaGeneratorUtil.shouldBeAbstract(parent);
            if (parent.hasStereotype("entity")) {
                extendClass = abstractParent ? extendClass + "Abstract" : extendClass + "Impl";
            }
            this.setSuperClass(result, extendClass);
        }
        if (result.getSuperclasses().isEmpty()) {
            this.setSuperClass(result, TopiaEntityAbstract.class);
        }
        if ((svUID = TopiaGeneratorUtil.findTagValue((String)"serialVersionUID", (ObjectModelElement)clazz, (Model)this.model)) != null) {
            this.addAttribute((ObjectModelClassifier)result, "serialVersionUID", Long.TYPE, svUID, new ObjectModelModifier[]{ObjectModelModifier.PRIVATE, ObjectModelModifier.STATIC, ObjectModelModifier.FINAL});
        }
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            String type;
            String name;
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            if (!attr.isNavigable() && !TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType(reverse, (ObjectModel)this.model) && !attr.hasAssociationClass()) continue;
            if (!attr.hasAssociationClass()) {
                name = attrName = attr.getName();
                type = attr.getType();
            } else {
                String assocAttrName = GeneratorUtil.getAssocAttrName((ObjectModelAttribute)attr);
                name = GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName);
                type = attr.getAssociationClass().getQualifiedName();
            }
            if (GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
                String collectionType = TopiaGeneratorUtil.getNMultiplicityInterfaceType(attr);
                type = collectionType + '<' + type + '>';
            }
            String attrVisibility = attr.getVisibility();
            ObjectModelAttribute attr2 = this.addAttribute((ObjectModelClassifier)result, name, type, null, new ObjectModelModifier[]{ObjectModelModifier.toValue((String)attrVisibility), ObjectModelModifier.PROTECTED});
            doc = new StringBuilder();
            if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attr) || attr.hasTagValue("dbName")) {
                if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attr)) {
                    String attrDocumentation = attr.getDocumentation();
                    doc.append(attrDocumentation).append('\n');
                }
                if (attr.hasTagValue("dbName")) {
                    String dbName2 = attr.getTagValue("dbName");
                    doc.append("Nom de l'attribut en BD : ");
                    doc.append(dbName2);
                    doc.append('\n');
                }
            }
            this.setDocumentation((ObjectModelElement)attr2, doc.toString());
            if (!attr.hasTagValue("annotation")) continue;
            String annotation = attr.getTagValue("annotation");
            this.addAnnotation((ObjectModelClassifier)result, (ObjectModelElement)attr2, annotation);
        }
        if (clazz instanceof ObjectModelAssociationClass) {
            ObjectModelAssociationClass assoc = (ObjectModelAssociationClass)clazz;
            for (ObjectModelAttribute attr : assoc.getParticipantsAttributes()) {
                if (attr == null) continue;
                String attrVisibility = attr.getVisibility();
                String attrType = attr.getType();
                attrName = attr.getName();
                this.addAttribute((ObjectModelClassifier)result, GeneratorUtil.toLowerCaseFirstLetter((String)attrName), attrType, null, new ObjectModelModifier[]{ObjectModelModifier.toValue((String)attrVisibility)});
            }
        }
        ObjectModelOperation op = this.addOperation((ObjectModelClassifier)result, "update", "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.addException(op, TopiaException.class);
        this.setOperationBody(op, "\n        ((TopiaContextImplementor)getTopiaContext()).getDAO(" + clazzName + ".class).update(this);\n" + "");
        op = this.addOperation((ObjectModelClassifier)result, "delete", "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.addException(op, TopiaException.class);
        this.setOperationBody(op, "\n        ((TopiaContextImplementor)getTopiaContext()).getDAO(" + clazzName + ".class).delete(this);\n" + "");
        this.generateAcceptMethod(result, clazz);
        this.generateAggregateMethod(result, clazz);
        this.generateCompositeMethod(result, clazz);
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            if (!attr.isNavigable() && !TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType(reverse, (ObjectModel)this.model)) continue;
            this.transformAttribute(result, attr, reverse);
        }
        if (clazz instanceof ObjectModelAssociationClass) {
            this.generateAssociationAccessors(result, (ObjectModelAssociationClass)clazz);
        }
        this.generateAbstractMethods(result, clazz);
        boolean doGenerateToString = TopiaGeneratorUtil.generateToString(clazz, (ObjectModel)this.model);
        if (doGenerateToString) {
            this.generateToStringMethod(result, clazz);
        }
        if (!StringUtils.isEmpty((String)(i18nPrefix = TopiaGeneratorUtil.getI18nPrefix((ObjectModelElement)clazz, (ObjectModel)this.model)))) {
            this.generateI18n(result, i18nPrefix, clazz);
        }
    }

    protected void transformAttribute(ObjectModelClass result, ObjectModelAttribute attr, ObjectModelAttribute reverse) {
        String attrName = attr.getName();
        String attrType = TopiaGeneratorUtil.getSimpleName((String)attr.getType());
        this.addImport((ObjectModelClassifier)result, attrType);
        attrType = TopiaGeneratorUtil.getSimpleName((String)attrType);
        if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
            if (attr.hasAssociationClass()) {
                String assocAttrName = GeneratorUtil.getAssocAttrName((ObjectModelAttribute)attr);
                String assocClassFQN = attr.getAssociationClass().getQualifiedName();
                this.addImport((ObjectModelClassifier)result, assocClassFQN);
                assocClassFQN = TopiaGeneratorUtil.getSimpleName((String)assocClassFQN);
                String name = GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName);
                ObjectModelOperation op = this.addOperation((ObjectModelClassifier)result, "set" + StringUtils.capitalize((String)assocAttrName), "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                this.addParameter(op, assocClassFQN, "association");
                this.setOperationBody(op, "\n        " + assocClassFQN + " _oldValue = this." + name + ";\n" + "        fireOnPreWrite(" + this.getConstantName(name) + ", _oldValue, association);\n" + "        this." + name + " = association;\n" + "        fireOnPostWrite(" + this.getConstantName(name) + ", _oldValue, association);\n" + "");
                op = this.addOperation((ObjectModelClassifier)result, "get" + StringUtils.capitalize((String)assocAttrName), assocClassFQN, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                this.setOperationBody(op, "\n        return " + name + ";\n" + "");
            } else {
                ObjectModelOperation op = this.addOperation((ObjectModelClassifier)result, "set" + StringUtils.capitalize((String)attrName), "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                this.addParameter(op, attrType, "value");
                this.setOperationBody(op, "\n        " + attrType + " _oldValue = this." + attrName + ";\n" + "        fireOnPreWrite(" + this.getConstantName(attrName) + ", _oldValue, value);\n" + "        this." + attrName + " = value;\n" + "        fireOnPostWrite(" + this.getConstantName(attrName) + ", _oldValue, value);\n" + "");
                op = this.addOperation((ObjectModelClassifier)result, "get" + StringUtils.capitalize((String)attrName), attrType, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                this.setOperationBody(op, "\n        fireOnPreRead(" + this.getConstantName(attrName) + ", " + attrName + ");\n" + "        " + attrType + " result = this." + attrName + ";\n" + "        fireOnPostRead(" + this.getConstantName(attrName) + ", " + attrName + ");\n" + "        return result;\n" + "");
            }
        } else {
            String assocClassFQN;
            String assocAttrName;
            ObjectModelOperation op;
            String collectionInterface = TopiaGeneratorUtil.getNMultiplicityInterfaceType(attr);
            String collectionObject = TopiaGeneratorUtil.getNMultiplicityObjectType(attr);
            this.addImport((ObjectModelClassifier)result, collectionInterface);
            this.addImport((ObjectModelClassifier)result, collectionObject);
            collectionInterface = TopiaGeneratorUtil.getSimpleName((String)collectionInterface);
            collectionObject = TopiaGeneratorUtil.getSimpleName((String)collectionObject);
            if (!attr.hasAssociationClass()) {
                String reverseAttrName;
                op = this.addOperation((ObjectModelClassifier)result, "add" + StringUtils.capitalize((String)attrName), "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                this.addParameter(op, attrType, attrName);
                StringBuilder body = new StringBuilder();
                body.append("    \n        fireOnPreWrite(" + this.getConstantName(attrName) + ", null, " + attrName + ");\n" + "        if (this." + attrName + " == null) {\n" + "            this." + attrName + " = new " + collectionObject + "<" + attrType + ">();\n" + "        }\n" + "");
                if (reverse != null && (reverse.isNavigable() || TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType(attr, (ObjectModel)this.model))) {
                    reverseAttrName = reverse.getName();
                    String reverseAttrType = TopiaGeneratorUtil.getSimpleName((String)reverse.getType());
                    if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)reverse)) {
                        body.append("        " + attrName + ".set" + StringUtils.capitalize((String)reverseAttrName) + "(this);\n" + "");
                    } else {
                        body.append("        if (" + attrName + ".get" + StringUtils.capitalize((String)reverseAttrName) + "() == null) {\n" + "            " + attrName + ".set" + StringUtils.capitalize((String)reverseAttrName) + "(new " + collectionObject + "<" + reverseAttrType + ">());\n" + "        }\n" + "        " + attrName + ".get" + StringUtils.capitalize((String)reverseAttrName) + "().add(this);\n" + "");
                    }
                }
                body.append("        this." + attrName + ".add(" + attrName + ");\n" + "        fireOnPostWrite(" + this.getConstantName(attrName) + ", this." + attrName + ".size(), null, " + attrName + ");\n" + "");
                this.setOperationBody(op, body.toString());
                op = this.addOperation((ObjectModelClassifier)result, "addAll" + StringUtils.capitalize((String)attrName), "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                this.addParameter(op, collectionInterface + '<' + attrType + '>', "values");
                this.setOperationBody(op, "\n        if (values == null) {\n            return;\n        }\n        for (" + attrType + " item : values) {\n" + "            add" + StringUtils.capitalize((String)attrName) + "(item);\n" + "        }\n" + "");
                if (!TopiaGeneratorUtil.isPrimitiveType(attr) && !TopiaGeneratorUtil.isDateType(attr)) {
                    op = this.addOperation((ObjectModelClassifier)result, "get" + StringUtils.capitalize((String)attrName) + "ByTopiaId", attrType, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                    this.addParameter(op, String.class, "topiaId");
                    this.setOperationBody(op, "\n        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(" + attrName + ", topiaId);\n" + " ");
                }
                op = this.addOperation((ObjectModelClassifier)result, "set" + StringUtils.capitalize((String)attrName), "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                this.addParameter(op, collectionInterface + '<' + attrType + '>', "values");
                this.setOperationBody(op, "\n        " + collectionInterface + "<" + attrType + "> _oldValue = " + attrName + ";\n" + "        fireOnPreWrite(" + this.getConstantName(attrName) + ", _oldValue, values);\n" + "        " + attrName + " = values;\n" + "        fireOnPostWrite(" + this.getConstantName(attrName) + ", _oldValue, values);\n" + "");
                op = this.addOperation((ObjectModelClassifier)result, "remove" + StringUtils.capitalize((String)attrName), "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                this.addParameter(op, attrType, "value");
                body = new StringBuilder();
                body.append("\n        fireOnPreWrite(" + this.getConstantName(attrName) + ", value, null);\n" + "        if ((this." + attrName + " == null) || (!this." + attrName + ".remove(value))) {\n" + "            throw new IllegalArgumentException(\"List does not contain given element\");\n" + "        }\n" + "");
                if (reverse != null && (reverse.isNavigable() || TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType(attr, (ObjectModel)this.model))) {
                    reverseAttrName = reverse.getName();
                    if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)reverse)) {
                        body.append("        value.set" + StringUtils.capitalize((String)reverseAttrName) + "(null);\n" + "");
                    } else {
                        body.append("        value.get" + StringUtils.capitalize((String)reverseAttrName) + "().remove(this);\n" + "");
                    }
                }
                body.append("        fireOnPostWrite(" + this.getConstantName(attrName) + ", this." + attrName + ".size()+1, value, null);\n" + "");
                this.setOperationBody(op, body.toString());
                op = this.addOperation((ObjectModelClassifier)result, "clear" + StringUtils.capitalize((String)attrName), "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                body = new StringBuilder();
                body.append("\n        if (this." + attrName + " == null) {\n" + "            return;\n" + "        }\n" + "");
                if (reverse != null && (reverse.isNavigable() || TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType(attr, (ObjectModel)this.model))) {
                    reverseAttrName = reverse.getName();
                    body.append("        for (" + attrType + " item : this." + attrName + ") {\n" + "");
                    if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)reverse)) {
                        body.append("            item.set" + StringUtils.capitalize((String)reverseAttrName) + "(null);\n" + "");
                    } else {
                        body.append("            item.get" + StringUtils.capitalize((String)reverseAttrName) + "().remove(this);\n" + "");
                    }
                    body.append("        }\n");
                }
                body.append("        " + collectionInterface + "<" + attrType + "> _oldValue = new " + collectionObject + "<" + attrType + ">(this." + attrName + ");\n" + "        fireOnPreWrite(" + this.getConstantName(attrName) + ", _oldValue, this." + attrName + ");\n" + "        this." + attrName + ".clear();\n" + "        fireOnPostWrite(" + this.getConstantName(attrName) + ", _oldValue, this." + attrName + ");\n" + "");
                this.setOperationBody(op, body.toString());
            } else {
                String reverseAttrName;
                assocAttrName = GeneratorUtil.getAssocAttrName((ObjectModelAttribute)attr);
                assocClassFQN = attr.getAssociationClass().getQualifiedName();
                op = this.addOperation((ObjectModelClassifier)result, "add" + StringUtils.capitalize((String)assocAttrName), "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                this.addParameter(op, assocClassFQN, "value");
                StringBuilder body = new StringBuilder();
                body.append("\n        fireOnPreWrite(" + this.getConstantName(GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName)) + ", null, value);\n" + "        if (this." + GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName) + " == null) {\n" + "            this." + GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName) + " = new " + collectionObject + "<" + assocClassFQN + ">();\n" + "        }\n" + "");
                if (reverse != null && (reverse.isNavigable() || TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType(attr, (ObjectModel)this.model))) {
                    reverseAttrName = reverse.getName();
                    body.append("        value.set" + StringUtils.capitalize((String)reverseAttrName) + "(this);\n" + "");
                }
                body.append("        this." + GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName) + ".add(value);\n" + "        fireOnPostWrite(" + this.getConstantName(GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName)) + ", this." + GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName) + ".size(), null, value);\n" + "");
                this.setOperationBody(op, body.toString());
                if (!TopiaGeneratorUtil.isPrimitiveType(attr) && !TopiaGeneratorUtil.isDateType(attr)) {
                    op = this.addOperation((ObjectModelClassifier)result, "get" + StringUtils.capitalize((String)assocAttrName) + "ByTopiaId", assocClassFQN, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                    this.addParameter(op, String.class, "topiaId");
                    this.setOperationBody(op, "\n        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(" + assocAttrName + ", topiaId);\n" + "");
                }
                op = this.addOperation((ObjectModelClassifier)result, "addAll" + StringUtils.capitalize((String)assocAttrName), "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                this.addParameter(op, collectionInterface + '<' + assocClassFQN + '>', "values");
                this.setOperationBody(op, "\n        if (values == null) {\n            return;\n        }\n        for (" + assocClassFQN + " item : values) {\n" + "            add" + StringUtils.capitalize((String)assocAttrName) + "(item);\n" + "        }\n" + "");
                op = this.addOperation((ObjectModelClassifier)result, "set" + StringUtils.capitalize((String)assocAttrName), "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                this.addParameter(op, collectionInterface + '<' + assocClassFQN + '>', "values");
                this.setOperationBody(op, "\n//        clear" + StringUtils.capitalize((String)assocAttrName) + "();\n" + "//        addAll" + StringUtils.capitalize((String)assocAttrName) + "(values);\n" + "// FIXME\n" + "        " + collectionInterface + "<" + assocClassFQN + "> _oldValue = " + GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName) + ";\n" + "        fireOnPreWrite(" + this.getConstantName(GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName)) + ", _oldValue, values);\n" + "        " + GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName) + " = values;\n" + "        fireOnPostWrite(" + this.getConstantName(GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName)) + ", _oldValue, values);\n" + "");
                op = this.addOperation((ObjectModelClassifier)result, "remove" + StringUtils.capitalize((String)assocAttrName), "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                this.addParameter(op, assocClassFQN, "value");
                body = new StringBuilder();
                body.append("\n        fireOnPreWrite(" + this.getConstantName(GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName)) + ", value, null);\n" + "        if ((this." + GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName) + " == null) || (!this." + GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName) + ".remove(value))) {\n" + "            throw new IllegalArgumentException(\"List does not contain given element\");\n" + "        }\n" + "");
                if (reverse != null && (reverse.isNavigable() || TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType(attr, (ObjectModel)this.model))) {
                    reverseAttrName = reverse.getName();
                    body.append("        value.set" + StringUtils.capitalize((String)reverseAttrName) + "(null);\n" + "");
                }
                body.append("        fireOnPostWrite(" + this.getConstantName(GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName)) + ", this." + GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName) + ".size()+1, value, null);\n" + "");
                this.setOperationBody(op, body.toString());
                op = this.addOperation((ObjectModelClassifier)result, "clear" + StringUtils.capitalize((String)assocAttrName), "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                body = new StringBuilder();
                body.append("\n        if (this." + GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName) + " == null) {\n" + "            return;\n" + "        }\n" + "");
                if (reverse != null && (reverse.isNavigable() || TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType(attr, (ObjectModel)this.model))) {
                    reverseAttrName = reverse.getName();
                    body.append("        for (" + assocClassFQN + " item : this." + GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName) + ") {\n" + "            item.set" + StringUtils.capitalize((String)reverseAttrName) + "(null);\n" + "        }\n" + "");
                }
                body.append("        " + collectionInterface + "<" + assocClassFQN + "> _oldValue = new " + collectionObject + "<" + assocClassFQN + ">(this." + GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName) + ");\n" + "        fireOnPreWrite(" + this.getConstantName(GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName)) + ", _oldValue, null);\n" + "        this." + GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName) + ".clear();\n" + "        fireOnPostWrite(" + this.getConstantName(GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName)) + ", _oldValue, null);\n" + "");
                this.setOperationBody(op, body.toString());
            }
            if (!attr.hasAssociationClass()) {
                op = this.addOperation((ObjectModelClassifier)result, "get" + StringUtils.capitalize((String)attrName), collectionInterface + '<' + attrType + '>', new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                this.setOperationBody(op, "\n        return " + attrName + ";\n" + "");
                op = this.addOperation((ObjectModelClassifier)result, "size" + StringUtils.capitalize((String)attrName), Integer.TYPE, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                this.setOperationBody(op, "\n        if (" + attrName + " == null) {\n" + "            return 0;\n" + "        }\n" + "        return " + attrName + ".size();\n" + "");
                op = this.addOperation((ObjectModelClassifier)result, "is" + StringUtils.capitalize((String)attrName) + "Empty", Boolean.TYPE, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                this.setOperationBody(op, "\n        int size = size" + StringUtils.capitalize((String)attrName) + "();\n" + "        return size == 0;\n" + "");
            } else {
                assocAttrName = GeneratorUtil.getAssocAttrName((ObjectModelAttribute)attr);
                assocClassFQN = attr.getAssociationClass().getQualifiedName();
                op = this.addOperation((ObjectModelClassifier)result, "get" + StringUtils.capitalize((String)assocAttrName), collectionInterface + '<' + assocClassFQN + '>', new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                this.setOperationBody(op, "\n        return " + GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName) + ";\n" + "");
                op = this.addOperation((ObjectModelClassifier)result, "get" + StringUtils.capitalize((String)assocAttrName), assocClassFQN, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                this.addParameter(op, attrType, "value");
                this.setOperationBody(op, "\n        if (value == null || " + GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName) + " == null) {\n" + "            return null;\n" + "        }\n" + "        for (" + assocClassFQN + " item : " + GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName) + ") {\n" + "            if (value.equals(item.get" + StringUtils.capitalize((String)attrName) + "())) {\n" + "                return item;\n" + "            }\n" + "        }\n" + "        return null;\n" + "");
                op = this.addOperation((ObjectModelClassifier)result, "size" + StringUtils.capitalize((String)assocAttrName), Integer.TYPE, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                this.setOperationBody(op, "\n        if (" + GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName) + " == null) {\n" + "            return 0;\n" + "        }\n" + "        return " + GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName) + ".size();\n" + "");
                op = this.addOperation((ObjectModelClassifier)result, "is" + StringUtils.capitalize((String)assocAttrName) + "Empty", Boolean.TYPE, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                this.setOperationBody(op, "\n        int size = size" + StringUtils.capitalize((String)assocAttrName) + "();\n" + "        return size == 0;\n" + "");
            }
        }
    }

    protected void generateAssociationAccessors(ObjectModelClass result, ObjectModelAssociationClass assoc) {
        for (ObjectModelAttribute attr : assoc.getParticipantsAttributes()) {
            if (attr == null) continue;
            String attrType = TopiaGeneratorUtil.getSimpleName((String)attr.getType());
            String attrName = attr.getName();
            this.generateAssociationAccessors(result, attrName, attrType);
        }
    }

    protected void generateToStringMethod(ObjectModelClass result, ObjectModelClass clazz) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("generate toString method for clazz " + clazz.getQualifiedName()));
        }
        ObjectModelOperation op = this.addOperation((ObjectModelClassifier)result, "toString", String.class, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)result, (ObjectModelElement)op, Override.class.getSimpleName());
        StringBuilder body = new StringBuilder();
        body.append("\n        String result = new ToStringBuilder(this).\n");
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            ObjectModelClass attrEntity = null;
            if (((ObjectModel)this.model).hasClass(attr.getType())) {
                attrEntity = ((ObjectModel)this.model).getClass(attr.getType());
            }
            boolean isEntity = attrEntity != null && attrEntity.hasStereotype("entity");
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            if ((!isEntity || reverse != null && reverse.isNavigable() || attr.hasAssociationClass()) && isEntity) continue;
            String attrName = attr.getName();
            body.append("            append(" + this.getConstantName(attrName) + ", this." + attrName + ").\n" + "");
        }
        body.append("         toString();\n        return result;\n");
        this.setOperationBody(op, body.length() == 0 ? " " : body.toString());
    }

    protected void generateCompositeMethod(ObjectModelClass result, ObjectModelClass clazz) {
        ObjectModelOperation op = this.addOperation((ObjectModelClassifier)result, "getComposite", List.class.getName() + '<' + TopiaEntity.class.getName() + '>', new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.addException(op, TopiaException.class);
        StringBuilder body = new StringBuilder();
        body.append("\n        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();\n\n        // pour tous les attributs rechecher les composites et les class d'asso\n        // on les ajoute dans tmp\n");
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (!attr.referenceClassifier() || !attr.getClassifier().hasStereotype("entity")) continue;
            if (attr.isComposite()) {
                String attrName = attr.getName();
                String getterName = "get" + StringUtils.capitalize((String)attrName);
                if (GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
                    body.append("        if (" + getterName + "() != null) {\n" + "              tmp.addAll(" + getterName + "());\n" + "           }\n" + "");
                    continue;
                }
                body.append("        tmp.add(" + getterName + "());\n" + "");
                continue;
            }
            if (!attr.hasAssociationClass()) continue;
            String assocAttrName = GeneratorUtil.getAssocAttrName((ObjectModelAttribute)attr);
            String assocClassFQN = TopiaGeneratorUtil.getSimpleName((String)attr.getAssociationClass().getQualifiedName());
            String ref = "this." + GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName);
            if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
                body.append("\n        if (" + ref + " != null) {\n" + "            tmp.add(" + ref + ");\n" + "        }\n" + "");
                continue;
            }
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            String reverseAttrName = reverse.getName();
            body.append("\n        {\n            org.nuiton.topia.persistence.TopiaDAO<" + assocClassFQN + "> dao = ((TopiaContextImplementor) getTopiaContext()).getDAO(" + assocClassFQN + ".class);\n" + "            List<" + assocClassFQN + "> findAllByProperties = dao.findAllByProperties(\"" + reverseAttrName + "\", this);\n" + "            if (findAllByProperties != null) {\n" + "                tmp.addAll(findAllByProperties);\n" + "            }\n" + "        }\n" + "");
        }
        body.append("\n        // on refait un tour sur chaque entity de tmp pour recuperer leur\n        // composite\n        List<TopiaEntity> result = new ArrayList<TopiaEntity>();\n        for (TopiaEntity entity : tmp) {\n            if (entity != null) {\n                result.add(entity);\n                result.addAll(entity.getComposite());\n            }\n        }\n\n        return result;\n");
        this.setOperationBody(op, body.length() == 0 ? " " : body.toString());
    }

    protected void generateAggregateMethod(ObjectModelClass result, ObjectModelClass clazz) {
        ObjectModelOperation op = this.addOperation((ObjectModelClassifier)result, "accept", List.class.getName() + '<' + TopiaEntity.class.getName() + '>', new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.addException(op, TopiaException.class);
        StringBuilder body = new StringBuilder();
        body.append("\n        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();\n\n        // pour tous les attributs rechecher les composites et les class d'asso\n        // on les ajoute dans tmp\n");
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (!attr.referenceClassifier() || !attr.getClassifier().hasStereotype("entity") || !attr.isAggregate()) continue;
            String attrName = attr.getName();
            String getterName = "get" + StringUtils.capitalize((String)attrName);
            if (GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
                body.append("        tmp.addAll(" + getterName + "());\n" + "");
                continue;
            }
            body.append("        tmp.add(" + getterName + "());\n" + "");
        }
        body.append("\n        // on refait un tour sur chaque entity de tmp pour recuperer leur\n        // composite\n        List<TopiaEntity> result = new ArrayList<TopiaEntity>();\n        for (TopiaEntity entity : tmp) {\n            result.add(entity);\n            result.addAll(entity.getAggregate());\n        }\n\n        return result;\n");
        this.setOperationBody(op, body.length() == 0 ? " " : body.toString());
    }

    protected void generateAcceptMethod(ObjectModelClass result, ObjectModelClass clazz) {
        String attrName;
        String attrType;
        ObjectModelOperation op = this.addOperation((ObjectModelClassifier)result, "accept", "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.addException(op, TopiaException.class);
        this.setDocumentation((ObjectModelElement)op, "Envoi via les methodes du visitor l'ensemble des champs de l'entity\navec leur nom, type et valeur.");
        ObjectModelParameter attr = this.addParameter(op, EntityVisitor.class, "visitor");
        this.setDocumentation((ObjectModelElement)attr, "le visiteur de l'entite.");
        StringBuilder body = new StringBuilder();
        body.append("\n        visitor.start(this);\n");
        for (ObjectModelAttribute attr2 : clazz.getAttributes()) {
            String collectionType;
            ObjectModelAttribute reverse = attr2.getReverseAttribute();
            if (!attr2.isNavigable() && !TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType(reverse, (ObjectModel)this.model) && !attr2.hasAssociationClass()) continue;
            if (!attr2.hasAssociationClass()) {
                attrType = TopiaGeneratorUtil.getSimpleName((String)attr2.getType());
                attrName = attr2.getName();
                if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr2)) {
                    body.append("        visitor.visit(this, " + this.getConstantName(attrName) + ", " + attrType + ".class, " + attrName + ");\n" + "");
                    continue;
                }
                collectionType = TopiaGeneratorUtil.getSimpleName((String)TopiaGeneratorUtil.getNMultiplicityInterfaceType(attr2));
                body.append("        visitor.visit(this, " + this.getConstantName(attrName) + ", " + collectionType + ".class, " + attrType + ".class, " + attrName + ");\n" + "");
                continue;
            }
            String assocAttrName = GeneratorUtil.getAssocAttrName((ObjectModelAttribute)attr2);
            assocAttrName = GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName);
            String assocClassFQN = TopiaGeneratorUtil.getSimpleName((String)attr2.getAssociationClass().getQualifiedName());
            if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr2)) {
                body.append("        visitor.visit(this, " + this.getConstantName(assocAttrName) + ", " + assocClassFQN + ".class, " + assocAttrName + ");\n" + "");
                continue;
            }
            collectionType = TopiaGeneratorUtil.getNMultiplicityInterfaceType(attr2);
            body.append("        visitor.visit(this, " + this.getConstantName(assocAttrName) + ", " + collectionType + ".class, " + assocClassFQN + ".class, " + assocAttrName + ");\n" + "");
        }
        if (clazz instanceof ObjectModelAssociationClass) {
            ObjectModelAssociationClass assoc = (ObjectModelAssociationClass)clazz;
            for (ObjectModelAttribute attr3 : assoc.getParticipantsAttributes()) {
                if (attr3 == null) continue;
                attrType = TopiaGeneratorUtil.getSimpleName((String)attr3.getType());
                attrName = attr3.getName();
                attrName = GeneratorUtil.toLowerCaseFirstLetter((String)attrName);
                body.append("        visitor.visit(this, " + this.getConstantName(attrName) + ", " + attrType + ".class, " + attrName + ");\n" + "");
            }
        }
        body.append("        visitor.end(this);\n");
        this.setOperationBody(op, body.length() == 0 ? " " : body.toString());
    }

    private void generateAssociationAccessors(ObjectModelClass result, String name, String type) {
        ObjectModelOperation op = this.addOperation((ObjectModelClassifier)result, "set" + StringUtils.capitalize((String)name), "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        ObjectModelParameter param = this.addParameter(op, type, "value");
        this.setDocumentation((ObjectModelElement)param, "La valeur de l'attribut " + name + " \u00e0 positionner.");
        this.setOperationBody(op, "\n        " + type + " _oldValue = this." + GeneratorUtil.toLowerCaseFirstLetter((String)name) + ";\n" + "        fireOnPreWrite(\"" + name + "\", _oldValue, value);\n" + "        this." + GeneratorUtil.toLowerCaseFirstLetter((String)name) + " = value;\n" + "        fireOnPostWrite(\"" + name + "\", _oldValue, value);\n" + "");
        op = this.addOperation((ObjectModelClassifier)result, "get" + StringUtils.capitalize((String)name), type, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.setOperationBody(op, "    \n        return " + GeneratorUtil.toLowerCaseFirstLetter((String)name) + ";\n" + "");
    }

    private void generateAbstractMethods(ObjectModelClass result, ObjectModelClass clazz) {
        for (ObjectModelOperation op : clazz.getOperations()) {
            String visibility;
            ObjectModelModifier visibilityModifier;
            if (log.isDebugEnabled()) {
                log.debug((Object)("clazz : " + clazz.getQualifiedName() + " - method : " + op.getName() + " - visibility : " + op.getVisibility()));
            }
            if ((visibilityModifier = ObjectModelModifier.toValue((String)(visibility = op.getVisibility()))).equals((Object)ObjectModelModifier.PUBLIC)) continue;
            this.addOperation((ObjectModelClassifier)result, op.getName(), op.getReturnType(), new ObjectModelModifier[]{visibilityModifier, ObjectModelModifier.ABSTRACT});
        }
    }

    private void generateI18n(ObjectModelClass result, String i18nPrefix, ObjectModelClass clazz) {
        StringBuilder buffer = new StringBuilder(300);
        this.addI18n(buffer, i18nPrefix, Introspector.decapitalize(clazz.getName()));
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (!attr.isNavigable()) continue;
            this.addI18n(buffer, i18nPrefix, Introspector.decapitalize(attr.getName()));
        }
        ObjectModelOperation op = this.addBlock((ObjectModelClassifier)result, new ObjectModelModifier[]{ObjectModelModifier.STATIC});
        this.setOperationBody(op, buffer.toString());
    }

    private void addI18n(StringBuilder buffer, String i18nPrefix, String suffix) {
        buffer.append("\n    org.nuiton.i18n.I18n.n_(\"");
        buffer.append(i18nPrefix);
        buffer.append(suffix);
        buffer.append("\");");
    }
}

