package org.nuiton.topiatest;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public  abstract class AddressAbstract extends TopiaEntityAbstract implements Address {

    protected String city;
    protected String adress;
static {
    
    org.nuiton.i18n.I18n.n_("topia.test.common.address");
    org.nuiton.i18n.I18n.n_("topia.test.common.city");
    org.nuiton.i18n.I18n.n_("topia.test.common.adress");
    }
    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_CITY, String.class, city);
        visitor.visit(this, PROPERTY_ADRESS, String.class, adress);
        visitor.end(this);
}

    /**
     * setCity :
     * @param city 
     */

    @Override
    public void setCity(String city) {
        String oldValue = this.city;
        fireOnPreWrite(PROPERTY_CITY, oldValue, city);
        this.city = city;
        fireOnPostWrite(PROPERTY_CITY, oldValue, city);
}

    /**
     * getCity :
     * @return String 
     */

    @Override
    public String getCity() {
        fireOnPreRead(PROPERTY_CITY, city);
        String result = this.city;
        fireOnPostRead(PROPERTY_CITY, city);
        return result;
}

    /**
     * setAdress :
     * @param adress 
     */

    @Override
    public void setAdress(String adress) {
        String oldValue = this.adress;
        fireOnPreWrite(PROPERTY_ADRESS, oldValue, adress);
        this.adress = adress;
        fireOnPostWrite(PROPERTY_ADRESS, oldValue, adress);
}

    /**
     * getAdress :
     * @return String 
     */

    @Override
    public String getAdress() {
        fireOnPreRead(PROPERTY_ADRESS, adress);
        String result = this.adress;
        fireOnPostRead(PROPERTY_ADRESS, adress);
        return result;
}

    /**
     * getAggregate :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
    }

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_CITY, this.city).
            append(PROPERTY_ADRESS, this.adress).
         toString();
        return result;
}


} //AddressAbstract
