package org.nuiton.topiatest.beangen;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topiatest.Product;


public abstract class Roue {

    protected final PropertyChangeSupport pcs;
    public Voiture voiture;
    /**
     * Roue :
     */

    public Roue() {
                    pcs = new PropertyChangeSupport(this);
                }

    /**
     * addPropertyChangeListener :
     * @param listener 
     */

    public void addPropertyChangeListener(PropertyChangeListener listener) {
                    pcs.addPropertyChangeListener(listener);
                }

    /**
     * addPropertyChangeListener :
     * @param propertyName 
     * @param listener 
     */

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
                    pcs.addPropertyChangeListener(propertyName, listener);
                }

    /**
     * removePropertyChangeListener :
     * @param listener 
     */

    public void removePropertyChangeListener(PropertyChangeListener listener) {
                    pcs.removePropertyChangeListener(listener);
                }

    /**
     * removePropertyChangeListener :
     * @param propertyName 
     * @param listener 
     */

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
                    pcs.removePropertyChangeListener(propertyName, listener);
                }

    /**
     * firePropertyChange :
     * @param propertyName 
     * @param oldValue 
     * @param newValue 
     */

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
                    pcs.firePropertyChange(propertyName, oldValue, newValue);
                }

    /**
     * getVoiture :
     * @return Voiture 
     */

    public Voiture getVoiture() {
                            return this.voiture;
                        }

    /**
     * setVoiture :
     * @param newValue 
     */

    public void setVoiture(Voiture newValue) {
                            Voiture oldValue = getVoiture();
                            this.voiture = newValue;
                            firePropertyChange("voiture", oldValue, newValue);
                        }

    /**
     * mount :
     */

    public abstract void mount();

    /**
     * getModel :
     * @param id 
     * @return Product 
     */

    public abstract Product getModel(String id);

    /**
     * toString :
     * @return String 
     */

    public String toString() {
                    String result = new ToStringBuilder(this)
		.append("voiture", this.voiture).
                            toString();
                    return result;
                }


} //Roue
