package org.nuiton.topiatest;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang.builder.ToStringBuilder;


public class BillDTO implements Serializable {

    public int cost;
    public Date date;
    public Boolean paid;
    public StoreDTO store;
    public CompanyDTO company;
    protected final PropertyChangeSupport p = new PropertyChangeSupport(this);
    /**
     * addPropertyChangeListener :
     * @param listener 
     */

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        p.addPropertyChangeListener(listener);
    }

    /**
     * addPropertyChangeListener :
     * @param propertyName 
     * @param listener 
     */

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        p.addPropertyChangeListener(propertyName, listener);
    }

    /**
     * removePropertyChangeListener :
     * @param listener 
     */

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        p.removePropertyChangeListener(listener);
    }

    /**
     * removePropertyChangeListener :
     * @param propertyName 
     * @param listener 
     */

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        p.removePropertyChangeListener(propertyName, listener);
    }

    /**
     * setCost :
     * @param value 
     */

    public void setCost(int value) {
        int oldValue = this.cost;
        this.cost = value;
        p.firePropertyChange("cost", oldValue, value);
    }

    /**
     * getCost :
     * @return int 
     */

    public int getCost() {
        return cost;
    }

    /**
     * setDate :
     * @param value 
     */

    public void setDate(Date value) {
        java.util.Date oldValue = this.date;
        this.date = value;
        p.firePropertyChange("date", oldValue, value);
    }

    /**
     * getDate :
     * @return Date 
     */

    public Date getDate() {
        return date;
    }

    /**
     * setPaid :
     * @param value 
     */

    public void setPaid(Boolean value) {
        java.lang.Boolean oldValue = this.paid;
        this.paid = value;
        p.firePropertyChange("paid", oldValue, value);
    }

    /**
     * getPaid :
     * @return Boolean 
     */

    public Boolean getPaid() {
        return paid;
    }

    /**
     * toString :
     * @return String 
     */

    public String toString() {
        String result = new ToStringBuilder(this).
            append("cost", this.cost).
            append("date", this.date).
            append("paid", this.paid).
         toString();
        return result;
}


} //BillDTO
