package org.nuiton.topia.test.entities;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class PetAbstract extends TopiaEntityAbstract implements Pet {

    protected String name;
    protected String type;
    protected Person person;
    protected Race race;
    /**
     * getName :
     * @return String 
     */

    public String getName() {
        fireOnPreRead(NAME, name);
        java.lang.String result = this.name;
        fireOnPostRead(NAME, name);
        return result;
}

    /**
     * getType :
     * @return String 
     */

    public String getType() {
        fireOnPreRead(TYPE, type);
        java.lang.String result = this.type;
        fireOnPostRead(TYPE, type);
        return result;
}

    /**
     * getPerson :
     * @return Person 
     */

    public Person getPerson() {
        fireOnPreRead(PERSON, person);
        org.nuiton.topia.test.entities.Person result = this.person;
        fireOnPostRead(PERSON, person);
        return result;
}

    /**
     * getRace :
     * @return Race 
     */

    public Race getRace() {
        fireOnPreRead(RACE, race);
        org.nuiton.topia.test.entities.Race result = this.race;
        fireOnPostRead(RACE, race);
        return result;
}

    /**
     * update :
     * @deprecated since 2.3.4, use the DAO api instead.
     * @throws TopiaException
     */

    @Deprecated
    @Override
    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Pet.class).update(this);
}

    /**
     * delete :
     * @deprecated since 2.3.4, use the DAO api instead.
     * @throws TopiaException
     */

    @Deprecated
    @Override
    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Pet.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, NAME, String.class, name);
        visitor.visit(this, TYPE, String.class, type);
        visitor.visit(this, PERSON, Person.class, person);
        visitor.visit(this, RACE, Race.class, race);
        visitor.end(this);
}

    /**
     * getAggregate :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp
        tmp.add(getRace());

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
    }

    /**
     * setName :
     * @param value 
     */

    public void setName(String value) {
        String _oldValue = this.name;
        fireOnPreWrite(NAME, _oldValue, value);
        this.name = value;
        fireOnPostWrite(NAME, _oldValue, value);
}

    /**
     * setType :
     * @param value 
     */

    public void setType(String value) {
        String _oldValue = this.type;
        fireOnPreWrite(TYPE, _oldValue, value);
        this.type = value;
        fireOnPostWrite(TYPE, _oldValue, value);
}

    /**
     * setPerson :
     * @param value 
     */

    public void setPerson(Person value) {
        Person _oldValue = this.person;
        fireOnPreWrite(PERSON, _oldValue, value);
        this.person = value;
        fireOnPostWrite(PERSON, _oldValue, value);
}

    /**
     * setRace :
     * @param value 
     */

    public void setRace(Race value) {
        Race _oldValue = this.race;
        fireOnPreWrite(RACE, _oldValue, value);
        this.race = value;
        fireOnPostWrite(RACE, _oldValue, value);
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(NAME, this.name).
            append(TYPE, this.type).
            append(RACE, this.race).
         toString();
        return result;
}

static {
    
    org.nuiton.i18n.I18n.n_("topia.test.common.pet");
    org.nuiton.i18n.I18n.n_("topia.test.common.name");
    org.nuiton.i18n.I18n.n_("topia.test.common.type");
    org.nuiton.i18n.I18n.n_("topia.test.common.person");
    org.nuiton.i18n.I18n.n_("topia.test.common.race");
    }

} //PetAbstract
