package org.nuiton.topia.test.entities;

import java.util.Collection;
import org.nuiton.topia.persistence.TopiaEntity;


public interface Person extends TopiaEntity {     String NAME = "name";
     String FIRSTNAME = "firstname";
     String PET = "pet";
    /**
     * setName :
     * @param name La valeur de l'attribut name à positionner.
     */

     void setName(String name);

    /**
     * getName :
     * @return String 
     */

     String getName();

    /**
     * setFirstname :
     * @param firstname La valeur de l'attribut firstname à positionner.
     */

     void setFirstname(String firstname);

    /**
     * getFirstname :
     * @return String 
     */

     String getFirstname();

    /**
     * addPet :
     * @param pet L'instance de pet à ajouter
     */

     void addPet(Pet pet);

    /**
     * addAllPet :
     * @param pet Les instances de pet à ajouter
     */

     void addAllPet(Collection<Pet> pet);

    /**
     * setPet :
     * @param pet La Collection de pet à ajouter
     */

     void setPet(Collection<Pet> pet);

    /**
     * removePet :
     * @param pet Vide la Collection de pet
     */

     void removePet(Pet pet);

    /**
     * clearPet :
     */

     void clearPet();

    /**
     * getPet :
     * @return Collection<Pet> 
     */

     Collection<Pet> getPet();

    /**
     * getPetByTopiaId :
     * Recupère l'attribut pet à partir de son topiaId
     * @param topiaId le topia id de l'entité recherchée
     * @return Pet 
     */

     Pet getPetByTopiaId(String topiaId);

    /**
     * sizePet :
     * Retourne le nombre d'éléments de la collection pet
     * @return int 
     */

     int sizePet();

    /**
     * isPetEmpty :
     * Retourne {@code true} si la collection pet est vide.
     * @return boolean 
     */

     boolean isPetEmpty();


} //Person
