/*
 * #%L
 * ToPIA :: Persistence
 * 
 * $Id: TopiaQueryTest.java 1894 2010-04-15 15:44:51Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-2.3.3/topia-persistence/src/test/java/org/nuiton/topia/framework/TopiaQueryTest.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.topia.framework;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.nuiton.topiatest.QueriedEntity;

/**
 *
 * @author fdesbois
 */
public class TopiaQueryTest {

    public TopiaQueryTest() {
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testAdd() {

        // Test with one paramValue
        String value = "topia";
        TopiaQuery query = new TopiaQuery(QueriedEntity.class);
        query.add(QueriedEntity.TEST_ADD, value);
        Assert.assertEquals(
                "FROM org.nuiton.topiatest.QueriedEntity " +
                "WHERE testAdd = :testAdd",
                query.fullQuery());

        // Test with null paramValue
        String nullValue = null;
        query = new TopiaQuery(QueriedEntity.class);
        query.add(QueriedEntity.TEST_ADD, nullValue);
        Assert.assertEquals(
                "FROM org.nuiton.topiatest.QueriedEntity " +
                "WHERE testAdd IS NULL",
                query.fullQuery());

        // Test with two paramValues
        String value2 = "eugene";
        query = new TopiaQuery(QueriedEntity.class);
        query.add(QueriedEntity.TEST_ADD, value, value2);
        Assert.assertEquals(
                "FROM org.nuiton.topiatest.QueriedEntity " +
                "WHERE testAdd IN(:testAdd1, :testAdd2)",
                query.fullQuery());

        // Test with two paramValues + null
        query = new TopiaQuery(QueriedEntity.class);
        query.add(QueriedEntity.TEST_ADD, value, value2, null);
        Assert.assertEquals(
                "FROM org.nuiton.topiatest.QueriedEntity " +
                "WHERE (testAdd IN(:testAdd1, :testAdd2) OR testAdd IS NULL)",
                query.fullQuery());
    }

}
