/*
 * #%L
 * ToPIA :: Persistence
 * 
 * $Id: TopiaContextFactory.java 1894 2010-04-15 15:44:51Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-2.3.3/topia-persistence/src/main/java/org/nuiton/topia/TopiaContextFactory.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

/* *
 * TopiaContextFactory.java
 *
 * Created: 3 janv. 2006 21:19:37
 *
 * @author poussin
 * @version $Revision: 1894 $
 *
 * Last update: $Date: 2010-04-15 17:44:51 +0200 (jeu., 15 avril 2010) $
 * by : $Author: tchemit $
 */

package org.nuiton.topia;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Map.Entry;

import org.apache.commons.collections.map.AbstractReferenceMap;
import org.apache.commons.collections.map.ReferenceMap;
import org.nuiton.topia.framework.TopiaContextImpl;
import org.nuiton.topia.framework.TopiaUtil;

/**
 * @author poussin
 *
 */

public class TopiaContextFactory {

    static final private String DEFAULT_CONFIG_PROPERTIES = "TopiaContextImpl.properties";

    /**
     * Cache contenant tous les contexts deja créé.
     */
    @SuppressWarnings("unchecked")
    static protected Map<Properties, TopiaContextImpl> contextCache = new ReferenceMap(
            AbstractReferenceMap.HARD, AbstractReferenceMap.SOFT);

    /**
     * Permet de connaitre la liste des contexts encore en memoire, utile
     * pour du debuggage
     * @return la liste des urls de connexion
     */
    static public List<String> getContextOpened() {
        List<String> result = new ArrayList<String>();
        for (Entry<Properties, TopiaContextImpl> e : contextCache.entrySet()) {
            if (e.getValue() != null) {
                result.add(e.getKey().getProperty("hibernate.connection.url"));
            }
        }
        return result;
    }

    /**
     * Used when TopiaContext root is closed
     * @param context closed
     */
    static public void removeContext(TopiaContext context) {
        Properties key = null;
        for (Entry<Properties, TopiaContextImpl> e : contextCache.entrySet()) {
            if (e.getValue() == context) {
                key = e.getKey();
                break;
            }
        }
        if (key != null) {
            contextCache.remove(key);
        }
    }

    /**
     * Utilise par defaut le fichier de propriete TopiaContextImpl.properties
     * 
     * @return the context using the default configuration file
     * @throws TopiaNotFoundException Si le fichier de configuration par defaut
     *         n'est pas retrouvé.
     */
    static public TopiaContext getContext() throws TopiaNotFoundException {
        Properties config = TopiaUtil.getProperties(DEFAULT_CONFIG_PROPERTIES);
        TopiaContext result = getContext(config);
        return result;
    }

    /**
     * Methode static permettant de recuperer un context. Si on donne plusieurs
     * fois le meme objet config, on obtient la meme instance de TopiaContextImpl.
     * Si le context qui devrait etre retourné est ferme, alors un nouveau est
     * creer et retourné
     * 
     * @param config the configuration of the context
     * @return Un TopiaContext ouvert
     * @throws TopiaNotFoundException if any pb
     */
    static public TopiaContext getContext(Properties config)
            throws TopiaNotFoundException {
        // Put all properties from a hierarchy in the current properties object.
        // Resolve problem with hibernate which used iterator to get properties and so only 
        // values from the current properties object and not all hierarchy
        for (String key : config.stringPropertyNames()) {
            config.setProperty(key, config.getProperty(key));
        }
        TopiaContextImpl result = contextCache.get(config);
        if (result == null || result.isClosed()) {
            result = new TopiaContextImpl(config);
            contextCache.put((Properties) config.clone(), result);
        }
        return result;
    }

}
