package org.nuiton.topiatest;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class BillAbstract extends TopiaEntityAbstract implements Bill {

    protected int cost;
    protected Date date;
    public Store store;
    public Company company;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Bill.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Bill.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, COST, int.class, cost);
        visitor.visit(this, DATE, Date.class, date);
        visitor.visit(this, STORE, Store.class, store);
        visitor.visit(this, COMPANY, Company.class, company);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setCost :
     * @param value 
     */

    public void setCost(int value) {
        int _oldValue = this.cost;
        fireOnPreWrite(COST, _oldValue, value);
        this.cost = value;
        fireOnPostWrite(COST, _oldValue, value);
}

    /**
     * getCost :
     * @return int 
     */

    public int getCost() {
        fireOnPreRead(COST, cost);
        int result = this.cost;
        fireOnPostRead(COST, cost);
        return result;
}

    /**
     * setDate :
     * @param value 
     */

    public void setDate(Date value) {
        Date _oldValue = this.date;
        fireOnPreWrite(DATE, _oldValue, value);
        this.date = value;
        fireOnPostWrite(DATE, _oldValue, value);
}

    /**
     * getDate :
     * @return Date 
     */

    public Date getDate() {
        fireOnPreRead(DATE, date);
        Date result = this.date;
        fireOnPostRead(DATE, date);
        return result;
}

    /**
     * setStore :
     * @param value La valeur de l'attribut store à positionner.
     */

    public void setStore(Store value) {
        Store _oldValue = this.store;
        fireOnPreWrite("store", _oldValue, value);
        this.store = value;
        fireOnPostWrite("store", _oldValue, value);
}

    /**
     * getStore :
     * @return Store 
     */

    public Store getStore() {    
        return store;
}

    /**
     * setCompany :
     * @param value La valeur de l'attribut company à positionner.
     */

    public void setCompany(Company value) {
        Company _oldValue = this.company;
        fireOnPreWrite("company", _oldValue, value);
        this.company = value;
        fireOnPostWrite("company", _oldValue, value);
}

    /**
     * getCompany :
     * @return Company 
     */

    public Company getCompany() {    
        return company;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(COST, this.cost).
            append(DATE, this.date).
         toString();
        return result;
}

static {
    
    org.nuiton.i18n.I18n.n_("topia.test.common.bill");
    org.nuiton.i18n.I18n.n_("topia.test.common.cost");
    org.nuiton.i18n.I18n.n_("topia.test.common.date");
    }

} //BillAbstract
