/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.metadata.ClassMetadata;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.event.TopiaEntityListener;
import org.nuiton.topia.event.TopiaEntityVetoable;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.framework.TopiaQuery;
import org.nuiton.topia.persistence.SearchFields;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.TopiaId;

public class TopiaDAOImpl<E extends TopiaEntity>
implements TopiaDAO<E> {
    private static Log log = LogFactory.getLog(TopiaDAOImpl.class);
    protected Class<E> entityClass = null;
    protected TopiaContextImplementor context = null;

    @Override
    public Class<E> getEntityClass() {
        throw new UnsupportedOperationException("This method must be overided in generated DAO");
    }

    protected Serializable getId(E e) throws TopiaException {
        ClassMetadata meta = this.getClassMetadata();
        String idPropName = meta.getIdentifierPropertyName();
        try {
            Serializable result = (Serializable)PropertyUtils.getSimpleProperty(e, (String)idPropName);
            return result;
        }
        catch (Exception eee) {
            throw new TopiaException("Impossible de r\u00e9cuperer l'identifiant " + idPropName + " de l'entite: " + e);
        }
    }

    protected Serializable getId(Map map) throws TopiaException {
        try {
            ClassMetadata meta = this.getClassMetadata();
            String idPropName = meta.getIdentifierPropertyName();
            Serializable id = (Serializable)map.get(idPropName);
            return id;
        }
        catch (HibernateException eee) {
            throw new TopiaException(eee);
        }
    }

    @Override
    public void init(TopiaContextImplementor context, Class<E> entityClass) throws TopiaException {
        log.debug((Object)("init dao for " + entityClass.getName()));
        this.context = context;
        this.entityClass = entityClass;
    }

    @Override
    public TopiaContextImplementor getContext() {
        return this.context;
    }

    @Override
    public E newInstance() throws TopiaException {
        String classname;
        TopiaEntity result;
        block15: {
            block14: {
                result = null;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("entityClass = " + this.entityClass));
                }
                classname = this.entityClass.getName();
                try {
                    result = (TopiaEntity)Class.forName(classname + "Impl").newInstance();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Utilisation de la classe " + classname + "Impl" + " pour " + classname));
                    }
                }
                catch (ClassNotFoundException eee) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("Impossible de trouver la classe " + classname + "Impl"));
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"StackTrace", (Throwable)eee);
                    }
                }
                catch (Exception eee) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("Impossible d'instancier " + classname + "Impl"));
                    }
                    if (!log.isDebugEnabled()) break block14;
                    log.debug((Object)"StackTrace", (Throwable)eee);
                }
            }
            if (result == null) {
                try {
                    result = (TopiaEntity)this.entityClass.newInstance();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Utilisation de la classe " + classname + " pour " + classname));
                    }
                }
                catch (Exception eee) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("Impossible d'instancier " + classname));
                    }
                    if (!log.isDebugEnabled()) break block15;
                    log.debug((Object)"StackTrace", (Throwable)eee);
                }
            }
        }
        if (result == null) {
            throw new TopiaException("Impossible de trouver ou d'instancier la classe " + classname);
        }
        return (E)result;
    }

    @Override
    public void commitTransaction() throws TopiaException {
    }

    @Override
    public void rollbackTransaction() throws TopiaException {
    }

    @Override
    public E create(Object ... properties) throws TopiaException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Object propertyName = null;
        Object value = null;
        try {
            int i = 0;
            while (i < properties.length) {
                propertyName = properties[i++];
                value = properties[i++];
                map.put((String)propertyName, value);
            }
        }
        catch (ArrayIndexOutOfBoundsException eee) {
            throw new IllegalArgumentException("Wrong number of argument " + properties.length + ", you must have even number. Last property name read: " + propertyName);
        }
        catch (ClassCastException eee) {
            throw new IllegalArgumentException("Wrong argument type, wait property name as String and have " + propertyName.getClass().getName());
        }
        E result = this.create((Map<String, Object>)map);
        return result;
    }

    @Override
    public E findByPrimaryKey(Map<String, Object> keys) throws TopiaException {
        try {
            ClassMetadata meta = this.getClassMetadata();
            if (meta.hasNaturalIdentifier()) {
                E result = this.findByProperties(keys);
                return result;
            }
        }
        catch (HibernateException eee) {
            throw new TopiaException(eee);
        }
        throw new TopiaException("La classe " + this.entityClass.getName() + " n'a pas de cle primaire naturelle");
    }

    private ClassMetadata getClassMetadata() throws TopiaException {
        ClassMetadata meta = this.getContext().getHibernateFactory().getClassMetadata(this.entityClass);
        if (meta == null) {
            meta = this.getContext().getHibernateFactory().getClassMetadata(this.entityClass.getName() + "Impl");
        }
        return meta;
    }

    @Override
    public E findByPrimaryKey(Object ... k) throws TopiaException {
        try {
            ClassMetadata meta = this.getClassMetadata();
            if (meta.hasNaturalIdentifier()) {
                int[] ikeys = meta.getNaturalIdentifierProperties();
                String[] pnames = meta.getPropertyNames();
                HashMap<String, Object> keys = new HashMap<String, Object>();
                for (int ikey : ikeys) {
                    keys.put(pnames[ikey], k[ikey]);
                }
                E result = this.findByProperties(keys);
                return result;
            }
        }
        catch (HibernateException eee) {
            throw new TopiaException(eee);
        }
        throw new TopiaException("La classe " + this.entityClass.getName() + " n'a pas de cle primaire naturelle");
    }

    @Override
    public E findByProperties(String propertyName, Object value, Object ... others) throws TopiaException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(propertyName, value);
        Object name = null;
        int i = 0;
        while (i < others.length) {
            try {
                name = others[i++];
                value = others[i++];
                properties.put((String)name, value);
            }
            catch (ClassCastException eee) {
                throw new IllegalArgumentException("Les noms des propri\u00e9t\u00e9s doivent \u00eatre des chaines et non pas " + propertyName.getClass().getName(), eee);
            }
            catch (ArrayIndexOutOfBoundsException eee) {
                throw new IllegalArgumentException("Le nombre d'argument n'est pas un nombre pair: " + (others.length + 2) + " La derni\u00e8re propri\u00e9t\u00e9 \u00e9tait: " + name, eee);
            }
        }
        E result = this.findByProperties(properties);
        return result;
    }

    @Override
    public List<E> findAllByProperties(String propertyName, Object value, Object ... others) throws TopiaException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(propertyName, value);
        Object name = null;
        int i = 0;
        while (i < others.length) {
            try {
                name = others[i++];
                value = others[i++];
                properties.put((String)name, value);
            }
            catch (ClassCastException eee) {
                throw new IllegalArgumentException("Les noms des propri\u00e9t\u00e9s doivent \u00eatre des chaines et non pas " + propertyName.getClass().getName(), eee);
            }
            catch (ArrayIndexOutOfBoundsException eee) {
                throw new IllegalArgumentException("Le nombre d'argument n'est pas un nombre pair: " + (others.length + 2) + " La derni\u00e8re propri\u00e9t\u00e9 \u00e9tait: " + name, eee);
            }
        }
        List<E> result = this.findAllByProperties(properties);
        return result;
    }

    @Override
    public E findContainsProperties(Map<String, Collection> properties) throws TopiaException {
        List<E> results = this.findAllContainsProperties(properties);
        TopiaEntity result = null;
        if (!results.isEmpty()) {
            result = (TopiaEntity)results.get(0);
        }
        return (E)result;
    }

    @Override
    public E findContainsProperties(String propertyName, Collection values, Object ... others) throws TopiaException {
        HashMap<String, Collection> properties = new HashMap<String, Collection>();
        properties.put(propertyName, values);
        Object name = null;
        int i = 0;
        while (i < others.length) {
            try {
                name = others[i++];
                values = (Collection)others[i++];
                properties.put((String)name, values);
            }
            catch (ClassCastException eee) {
                throw new IllegalArgumentException("Les noms des propri\u00e9t\u00e9s doivent \u00eatre des chaines et non pas " + propertyName.getClass().getName(), eee);
            }
            catch (ArrayIndexOutOfBoundsException eee) {
                throw new IllegalArgumentException("Le nombre d'argument n'est pas un nombre pair: " + (others.length + 2) + " La derni\u00e8re propri\u00e9t\u00e9 \u00e9tait: " + name, eee);
            }
        }
        E result = this.findContainsProperties(properties);
        return result;
    }

    @Override
    public List<E> findAllContainsProperties(Map<String, Collection> properties) throws TopiaException {
        List<E> all = this.findAll();
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : all) {
            boolean ok;
            block4: {
                ok = true;
                try {
                    for (Map.Entry<String, Collection> kv : properties.entrySet()) {
                        Collection values;
                        Collection entityValues = (Collection)PropertyUtils.getProperty((Object)e, (String)kv.getKey());
                        if (entityValues.containsAll(values = kv.getValue())) continue;
                        ok = false;
                        break;
                    }
                }
                catch (Exception eee) {
                    ok = false;
                    if (!log.isWarnEnabled()) break block4;
                    log.warn((Object)("Impossible d'acceder a la methode demand\u00e9 pour l'obbjet " + e), (Throwable)eee);
                }
            }
            if (!ok) continue;
            result.add(e);
        }
        return result;
    }

    @Override
    public List<E> findAllContainsProperties(String propertyName, Collection values, Object ... others) throws TopiaException {
        HashMap<String, Collection> properties = new HashMap<String, Collection>();
        properties.put(propertyName, values);
        Object name = null;
        int i = 0;
        while (i < others.length) {
            try {
                name = others[i++];
                values = (Collection)others[i++];
                properties.put((String)name, values);
            }
            catch (ClassCastException eee) {
                throw new IllegalArgumentException("Les noms des propri\u00e9t\u00e9s doivent \u00eatre des chaines et non pas " + propertyName.getClass().getName(), eee);
            }
            catch (ArrayIndexOutOfBoundsException eee) {
                throw new IllegalArgumentException("Le nombre d'argument n'est pas un nombre pair: " + (others.length + 2) + " La derni\u00e8re propri\u00e9t\u00e9 \u00e9tait: " + name, eee);
            }
        }
        List<E> result = this.findAllContainsProperties(properties);
        return result;
    }

    @Override
    public List<E> findAllByProperty(String propertyName, Object value) throws TopiaException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(propertyName, value);
        List<E> result = this.findAllByProperties(properties);
        return result;
    }

    @Override
    public E findByProperty(String propertyName, Object value) throws TopiaException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(propertyName, value);
        E result = this.findByProperties(properties);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E e) throws TopiaException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E e) throws TopiaException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    private Criterion computeCriterions(Object ... values) {
        if (values == null) {
            return null;
        }
        Criterion criterion = null;
        for (Object value : values) {
            criterion = this.or(criterion, this.computeCriterion(value));
        }
        return criterion;
    }

    @Deprecated
    private Criterion computeCriterion(Object value) {
        String[] timeFields;
        String[] textFields;
        Criterion criterion = null;
        SearchFields fields = this.entityClass.getAnnotation(SearchFields.class);
        String textValue = "%" + value + '%';
        for (String propName : textFields = fields.txtFields()) {
            criterion = this.or(criterion, (Criterion)Restrictions.like((String)propName, (Object)textValue));
        }
        boolean isNumber = value instanceof Number;
        if (value instanceof String) {
            try {
                Double.parseDouble((String)value);
                isNumber = true;
            }
            catch (NumberFormatException nfe) {
                isNumber = false;
            }
        }
        if (isNumber) {
            String[] numFields;
            for (String propName : numFields = fields.numFields()) {
                criterion = this.or(criterion, Restrictions.sqlRestriction((String)(propName + " like '" + textValue + '\'')));
            }
        }
        boolean isBoolean = value instanceof Boolean;
        if (value instanceof String) {
            isBoolean |= "true".equalsIgnoreCase((String)value) || "false".equalsIgnoreCase((String)value);
        }
        if (isBoolean) {
            String[] boolFields;
            Boolean booleanValue = value instanceof String ? Boolean.valueOf((String)value) : (Boolean)value;
            for (String propName : boolFields = fields.numFields()) {
                criterion = this.or(criterion, (Criterion)Restrictions.eq((String)propName, (Object)booleanValue));
            }
        }
        for (String propName : timeFields = fields.dateFields()) {
            criterion = this.or(criterion, Restrictions.sqlRestriction((String)(propName + " like '" + textValue + '\'')));
        }
        return criterion;
    }

    @Deprecated
    private Criterion or(Criterion crit1, Criterion crit2) {
        if (crit1 == null) {
            return crit2;
        }
        if (crit2 == null) {
            return crit1;
        }
        return Restrictions.or((Criterion)crit1, (Criterion)crit2);
    }

    @Override
    public void addTopiaEntityListener(TopiaEntityListener listener) {
        this.getContext().addTopiaEntityListener(this.entityClass, listener);
    }

    @Override
    public void addTopiaEntityVetoable(TopiaEntityVetoable vetoable) {
        this.getContext().addTopiaEntityVetoable(this.entityClass, vetoable);
    }

    @Override
    public void removeTopiaEntityListener(TopiaEntityListener listener) {
        this.getContext().removeTopiaEntityListener(this.entityClass, listener);
    }

    @Override
    public void removeTopiaEntityVetoable(TopiaEntityVetoable vetoable) {
        this.getContext().removeTopiaEntityVetoable(this.entityClass, vetoable);
    }

    @Override
    public E create(E entity) throws TopiaException {
        try {
            String topiaId = TopiaId.create(this.entityClass);
            TopiaEntityAbstract entityAbstract = (TopiaEntityAbstract)entity;
            entityAbstract.setTopiaId(topiaId);
            entityAbstract.setTopiaContext(this.getContext());
            this.getSession().save(entity);
            this.getContext().getFiresSupport().warnOnUpdateEntity((TopiaEntity)entity);
            return entity;
        }
        catch (HibernateException eee) {
            throw new TopiaException(eee);
        }
    }

    @Override
    public E create(Map<String, Object> properties) throws TopiaException {
        E result = this.newInstance();
        if (result instanceof TopiaEntity) {
            String topiaId = TopiaId.create(this.entityClass);
            TopiaEntityAbstract entity = (TopiaEntityAbstract)result;
            entity.setTopiaId(topiaId);
            entity.setTopiaContext(this.getContext());
        }
        try {
            for (Map.Entry<String, Object> e : properties.entrySet()) {
                String propertyName = e.getKey();
                Object value = e.getValue();
                PropertyUtils.setProperty(result, (String)propertyName, (Object)value);
            }
        }
        catch (IllegalAccessException eee) {
            throw new IllegalArgumentException("Can't put properties on new Object", eee);
        }
        catch (InvocationTargetException eee) {
            throw new IllegalArgumentException("Can't put properties on new Object", eee);
        }
        catch (NoSuchMethodException eee) {
            throw new IllegalArgumentException("Can't put properties on new Object", eee);
        }
        result.postCreate();
        this.getSession().save(result);
        this.getContext().getFiresSupport().warnOnCreateEntity((TopiaEntity)result);
        return result;
    }

    @Override
    public E update(E e) throws TopiaException {
        try {
            this.getSession().saveOrUpdate(e);
            this.getContext().getFiresSupport().warnOnUpdateEntity((TopiaEntity)e);
            return e;
        }
        catch (HibernateException eee) {
            throw new TopiaException(eee);
        }
    }

    @Override
    public void delete(E e) throws TopiaException {
        try {
            this.getSession().delete(e);
            this.getContext().getFiresSupport().warnOnDeleteEntity((TopiaEntity)e);
        }
        catch (HibernateException eee) {
            throw new TopiaException(eee);
        }
    }

    @Override
    public E findByTopiaId(String k) throws TopiaException {
        return this.findByQuery(this.createQuery().add("topiaId", k));
    }

    @Override
    public List<E> findAll() throws TopiaException {
        return this.findAllByQuery(this.createQuery());
    }

    @Override
    public List<String> findAllIds() throws TopiaException {
        return this.createQuery().setSelect("topiaId").execute();
    }

    @Override
    public TopiaQuery createQuery() {
        return new TopiaQuery(this);
    }

    @Override
    public TopiaQuery createQuery(String entityAlias) {
        return new TopiaQuery(this, entityAlias);
    }

    @Override
    public E findByQuery(TopiaQuery query) throws TopiaException {
        return query.executeToEntity(this.context, this.getEntityClass());
    }

    @Override
    public List<E> findAllByQuery(TopiaQuery query) throws TopiaException {
        return query.executeToEntityList(this.context, this.getEntityClass());
    }

    @Override
    public Map<String, E> findAllMappedByQuery(TopiaQuery query) throws TopiaException {
        return query.executeToEntityMap(this.context, this.getEntityClass());
    }

    @Override
    public <K> Map<K, E> findAllMappedByQuery(TopiaQuery query, String keyName, Class<K> keyClass) throws TopiaException {
        return query.executeToEntityMap(this.context, this.getEntityClass(), keyName, keyClass);
    }

    @Override
    public List<E> findAllWithOrder(String ... propertyNames) throws TopiaException {
        TopiaQuery query = this.createQuery();
        for (String propertyName : propertyNames) {
            query.addOrder(propertyName);
        }
        return this.findAllByQuery(query);
    }

    @Override
    public long size() throws TopiaException {
        return this.createQuery().executeCount(this.context);
    }

    @Override
    public E findByProperties(Map<String, Object> properties) throws TopiaException {
        return this.findByQuery(this.createQuery().add(properties));
    }

    @Override
    public List<E> findAllByProperties(Map<String, Object> properties) throws TopiaException {
        return this.findAllByQuery(this.createQuery().add(properties));
    }

    private Criteria createCriteria(FlushMode mode) throws TopiaException {
        Criteria criteria = this.getSession().createCriteria(this.entityClass);
        criteria.setFlushMode(mode);
        return criteria;
    }

    private Session getSession() throws TopiaException {
        return this.getContext().getHibernate();
    }

    @Override
    public List<Permission> getRequestPermission(String topiaId, int actions) throws TopiaException {
        return null;
    }
}

