package org.nuiton.topiatest.deletetest;

import java.util.Collection;
import org.nuiton.topia.persistence.SearchFields;
import org.nuiton.topia.persistence.TopiaEntity;

@SearchFields (
  txtFields={"contactValue","type"}
)

public interface Contact2 extends TopiaEntity {     String CONTACT_VALUE = "contactValue";
     String TYPE = "type";
     String PARTY2 = "party2";
    /**
     * setContactValue :
     * @param contactValue La valeur de l'attribut contactValue à positionner.
     */

     void setContactValue(String contactValue);

    /**
     * getContactValue :
     * @return String 
     */

     String getContactValue();

    /**
     * setType :
     * @param type La valeur de l'attribut type à positionner.
     */

     void setType(String type);

    /**
     * getType :
     * @return String 
     */

     String getType();

    /**
     * addParty2 :
     * @param party2 L'instance de party2 à ajouter
     */

     void addParty2(Party2 party2);

    /**
     * addAllParty2 :
     * @param party2 Les instances de party2 à ajouter
     */

     void addAllParty2(Collection<Party2> party2);

    /**
     * setParty2 :
     * @param party2 La Collection de party2 à ajouter
     */

     void setParty2(Collection<Party2> party2);

    /**
     * removeParty2 :
     * @param party2 Vide la Collection de party2
     */

     void removeParty2(Party2 party2);

    /**
     * clearParty2 :
     */

     void clearParty2();

    /**
     * getParty2 :
     * @return Collection<Party2> 
     */

     Collection<Party2> getParty2();

    /**
     * getParty2ByTopiaId :
     * Recupère l'attribut party2 à partir de son topiaId
     * @param topiaId le topia id de l'entité recherchée
     * @return Party2 
     */

     Party2 getParty2ByTopiaId(String topiaId);

    /**
     * sizeParty2 :
     * Retourne le nombre d'éléments de la collection party2
     * @return int 
     */

     int sizeParty2();

    /**
     * isParty2Empty :
     * Retourne {@code true} si la collection party2 est vide.
     * @return boolean 
     */

     boolean isParty2Empty();


} //Contact2
